/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits.unionpay.impl;

import cn.com.duiba.biz.credits.unionpay.BaseUnionPayRequest;
import cn.com.duiba.constant.GdUnionBankConstants;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.tool.DES3Tool;
import cn.com.duiba.tool.UnionPayBankUtil;
import com.alibaba.fastjson.JSON;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GdUnionPayRequest
extends BaseUnionPayRequest {
    @Autowired
    private GdUnionBankConstants gdUnionBankConstants;

    @Override
    public Set<Long> getAppIdSet() {
        return this.gdUnionBankConstants.getAppIdSet();
    }

    @Override
    public HttpRequestBase getVirtualRequest(SupplierRequest request, String merchantCoding) {
        if (StringUtils.isBlank((CharSequence)merchantCoding) || !merchantCoding.startsWith(this.gdUnionBankConstants.getVirtualCreditsPre())) {
            return null;
        }
        Map<String, String> authParamMap = this.getUrlParams(request);
        Map<String, String> requestParams = this.buildVirtualRequestParams(authParamMap, request.getParams(), Long.valueOf(request.getAppId()), merchantCoding.trim());
        LOGGER.info("\u94f6\u8054\u865a\u62df\u5546\u54c1\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString(requestParams));
        HttpPost post = new HttpPost(this.gdUnionBankConstants.getVirtualUrl());
        post.setEntity((HttpEntity)new StringEntity(JSON.toJSONString(requestParams), ContentType.APPLICATION_JSON));
        return post;
    }

    private Map<String, String> buildVirtualRequestParams(Map<String, String> authParamMap, Map<String, String> params, Long appId, String merchantCoding) {
        Map<String, String> requestParams = this.buildCommReq(authParamMap, params, appId);
        requestParams.put("activityNo", merchantCoding.replace(this.gdUnionBankConstants.getVirtualCreditsPre(), ""));
        requestParams.put("signature", UnionPayBankUtil.sign(requestParams, this.unionPayConstants.getPrivateKey()));
        if (StringUtils.isNotBlank((CharSequence)params.get("devAppId"))) {
            try {
                LOGGER.info("appId:{},devAppId:{},SymmetricKey:{}", new Object[]{appId, params.get("devAppId"), this.unionPayConstants.getSymmetricKey(params.get("devAppId"))});
                requestParams.put("mobile", DES3Tool.getEncryptedValue(params.get("mobile"), this.unionPayConstants.getSymmetricKey(params.get("devAppId"))));
            }
            catch (Exception e) {
                LOGGER.warn("\u94f6\u8054\u865a\u62df\u5546\u54c1\u8bf7\u6c42\u53c2\u6570\u52a0\u5bc6\u5931\u8d25, SymmetricKey: =>{}, mobile:{}", new Object[]{this.unionPayConstants.getSymmetricKey(params.get("devAppId")), params.get("mobile"), e});
            }
        }
        return requestParams;
    }

    @Override
    public String getVirtualResponse(SupplierRequest request, String body, String merchantCoding) {
        return this.getBaseResponse(body, request, this.gdUnionBankConstants, merchantCoding);
    }
}

