/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits.unionpay.impl;

import cn.com.duiba.biz.Exception.ThirdpatyException;
import cn.com.duiba.biz.credits.unionpay.UnionPayRequest;
import cn.com.duiba.constant.GuiYangUnionBankConstants;
import cn.com.duiba.constant.UnionPayConstants;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.DES3Tool;
import cn.com.duiba.tool.UnionPayBankUtil;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GuiYangUnionPayRequest
implements UnionPayRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(GuiYangUnionPayRequest.class);
    @Autowired
    private GuiYangUnionBankConstants guiYangUnionBankConstants;
    @Autowired
    private UnionPayConstants unionPayConstants;

    @Override
    public Set<Long> getAppIdSet() {
        return this.guiYangUnionBankConstants.getAppIdSet();
    }

    @Override
    public HttpRequestBase getVirtualRequest(SupplierRequest request, String merchantCoding) {
        if (StringUtils.isBlank((CharSequence)merchantCoding) || !merchantCoding.startsWith(this.guiYangUnionBankConstants.getVirtualCreditsPre())) {
            return null;
        }
        String url = request.getHttpUrl();
        Long appId = Long.valueOf(request.getAppId());
        String authParams = url.substring(url.indexOf(63) + 1);
        Map<String, String> authParamMap = AssembleTool.getUrlParams(authParams);
        String[] arr = merchantCoding.split("_");
        if (arr.length < 2) {
            LOGGER.info("\u8d35\u9633\u4e2d\u4fe1\u5546\u54c1\u7f16\u7801\u9519\u8bef:{}, orderNum:{}", (Object)merchantCoding, (Object)authParamMap.get("orderNum"));
            throw new ThirdpatyException("\u8d35\u9633\u4e2d\u4fe1\u5546\u54c1\u7f16\u7801\u9519\u8bef");
        }
        Map<String, String> requestParams = this.buildVirtualRequestParams(authParamMap, appId, arr[1]);
        LOGGER.info("\u8d35\u9633\u4e2d\u4fe1\u865a\u62df\u5546\u54c1\u8bf7\u6c42url={} req={}", (Object)this.guiYangUnionBankConstants.getVirtualUrl(), (Object)JSON.toJSONString(requestParams));
        HttpPost post = new HttpPost(this.guiYangUnionBankConstants.getVirtualUrl());
        post.setEntity((HttpEntity)new StringEntity(JSON.toJSONString(requestParams), ContentType.APPLICATION_JSON));
        return post;
    }

    private Map<String, String> buildVirtualRequestParams(Map<String, String> authParamMap, Long appId, String pointAt) {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put("appId", this.unionPayConstants.getAppConfig(String.valueOf(appId)).getAppId());
        requestParams.put("transSeqId", authParamMap.get("orderNum"));
        requestParams.put("transTs", DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmss"));
        requestParams.put("nonceStr", UnionPayBankUtil.createNonceStr());
        requestParams.put("insAcctId", this.guiYangUnionBankConstants.getInsAcctId());
        String mobile = this.guiYangUnionBankConstants.getMobileUidAppIdSet().contains(appId) ? authParamMap.get("uid") : authParamMap.get("account");
        requestParams.put("mobile", mobile);
        requestParams.put("acctEntityTp", "01");
        requestParams.put("pointId", this.guiYangUnionBankConstants.getPointId());
        requestParams.put("pointAt", pointAt);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("campaignId", (Object)authParamMap.get("orderNum"));
        jsonObject.put("campaignName", (Object)authParamMap.get("orderNum"));
        requestParams.put("busiInfo", jsonObject.toJSONString());
        String desc = authParamMap.get("description");
        if (StringUtils.isNotBlank((CharSequence)desc) && desc.length() > 200) {
            desc = desc.substring(0, 200);
        }
        requestParams.put("transDigest", desc);
        requestParams.put("timestamp", Long.toString(System.currentTimeMillis() / 1000L));
        requestParams.put("signature", UnionPayBankUtil.sign(requestParams, this.unionPayConstants.getPrivateKey()));
        String symmetricKey = this.unionPayConstants.getSymmetricKey(String.valueOf(appId));
        try {
            LOGGER.info("\u8d35\u9633\u4e2d\u4fe1\u53c2\u6570\u52a0\u5bc6appId={},SymmetricKey={},mobile={}", new Object[]{appId, symmetricKey, mobile});
            requestParams.put("mobile", DES3Tool.getEncryptedValue(mobile, symmetricKey));
        }
        catch (Exception e) {
            LOGGER.warn("\u8d35\u9633\u4e2d\u4fe1\u865a\u62df\u5546\u54c1\u8bf7\u6c42\u53c2\u6570\u52a0\u5bc6\u5931\u8d25, mobile={}, SymmetricKey={}", new Object[]{mobile, symmetricKey, e});
            throw new ThirdpatyException("\u8d35\u9633\u4e2d\u4fe1\u8bf7\u6c42\u53c2\u6570\u52a0\u5bc6\u5931\u8d25");
        }
        return requestParams;
    }

    @Override
    public String getVirtualResponse(SupplierRequest request, String body, String merchantCoding) {
        if (StringUtils.isBlank((CharSequence)merchantCoding) || !merchantCoding.startsWith(this.guiYangUnionBankConstants.getVirtualCreditsPre())) {
            return null;
        }
        return this.getBaseResponse(body, request);
    }

    @NotNull
    public String getBaseResponse(String body, SupplierRequest request) {
        HashMap<String, String> map = new HashMap<String, String>();
        LOGGER.info("\u8d35\u9633\u4e2d\u4fe1\u865a\u62df\u5546\u54c1\u8fd4\u56de\u7ed3\u679c\u4e3a orderId={} resp={}", (Object)request.getOrderId(), (Object)(body.length() > 500 ? body.substring(0, 500) : body));
        if (StringUtils.isBlank((CharSequence)body)) {
            throw new ThirdpatyException("\u8d35\u9633\u4e2d\u4fe1\uff0c\u865a\u62df\u5546\u54c1\u5b9a\u5236\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
        }
        try {
            JSONObject jsonObject = JSON.parseObject((String)body);
            map.put("status", Objects.equals("00", jsonObject.getString("resp")) ? "success" : "fail");
            map.put("errorMessage", StringEscapeUtils.unescapeHtml4((String)jsonObject.getString("msg")));
            JSONObject params = jsonObject.getJSONObject("params");
            if (params != null) {
                map.put("supplierBizId", params.getString("transSeqId"));
            }
        }
        catch (Exception e) {
            LOGGER.error("\u8d35\u9633\u4e2d\u4fe1\uff0c\u865a\u62df\u5546\u54c1\u5b9a\u5236\uff0c\u7ed3\u679c\u89e3\u6790\u9519\u8bef:{}", (Object)body, (Object)e);
            map.put("status", "fail");
            map.put("errorMessage", "\u865a\u62df\u5546\u54c1\u5145\u503c\u63a5\u53e3\u54cd\u5e94\u89e3\u6790\u9519\u8bef");
        }
        return JSON.toJSONString(map);
    }
}

