/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.constant;

import cn.com.duiba.constant.LvYunSin;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(value="mingyujiudian.lvyun")
public class MingYuJiuDianConfig {
    private static final Logger logger = LoggerFactory.getLogger(MingYuJiuDianConfig.class);
    private Set<Long> appIds = Sets.newHashSet((Object[])new Long[]{78412L});
    private String userName = "yjyMYSLGTR";
    private String password = "yjyMYSLGTR";
    private String lvYunAppKey = "12846";
    private String lvYunAppSecret = "224f50ddde4550b08f03a4ee0b60bb8d";
    private String sessionIdUrl = "http://118.25.218.97:8102/ipmsgroup/router";
    private String subCreditsUrl = "http://118.25.218.97:8101/ipmsmember/membercard/pointApplyByInterfaceMemberId";
    private String addCreditsUrl = "http://118.25.218.97:8101/ipmsmember/membercard/pointPayByInterface";
    private String getCreditsUrl = "http://118.25.218.97:8101/ipmsmember/membercard/getCardPointTotalByMemberId";
    private String coupons1Url = "http://118.25.218.97:8102/ipmsgroup/coupon/onlineSaleCouponPack";
    private String coupons2Url = "http://118.25.218.97:8102/ipmsgroup/coupon/onlineSalesCoupon";
    private String hotelGroupId = "2";
    private String hotelGroupCode = "MYSLG-TR";
    private String coupons1 = "coupons1_";
    private String coupons2 = "coupons2_";
    private String credits = "credits_";
    private String sessionId;
    private Long sessionIdTime;

    public String getSign() {
        HashMap<String, Object> signParams = new HashMap<String, Object>(16);
        String appSecret = this.lvYunAppSecret;
        signParams.put("hotelGroupCode", this.hotelGroupCode);
        signParams.put("v", "3.0");
        signParams.put("usercode", this.userName);
        signParams.put("method", "user.login");
        signParams.put("local", "zh_CN");
        signParams.put("format", "json");
        signParams.put("appKey", this.lvYunAppKey);
        signParams.put("password", this.password);
        LvYunSin t = new LvYunSin();
        return t.getSign(signParams, appSecret);
    }

    public String getSign(Map<String, String> signParams) {
        HashMap<String, Object> map = new HashMap<String, Object>(signParams);
        String appSecret = this.lvYunAppSecret;
        map.put("hotelGroupId", this.hotelGroupId);
        map.put("appKey", this.lvYunAppKey);
        logger.info("getSign signParams:{}", (Object)signParams.toString());
        LvYunSin t = new LvYunSin();
        String sign = t.getSign(map, appSecret);
        logger.info("getSign signParams:{},sign={}", (Object)JSON.toJSONString(signParams), (Object)sign);
        return sign;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getSessionId(CloseableHttpClient httpClient) {
        if (this.sessionId != null && this.sessionIdTime != null && System.currentTimeMillis() > this.sessionIdTime + 43200000L) {
            return this.sessionId;
        }
        HttpPost httpPost = new HttpPost(this.getSessionIdUrl());
        httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");
        httpPost.setHeader("User-Agent", "Apache-HttpClient/4.1.1(java 1.5)");
        httpPost.setHeader("Connection", "Keep-Alive");
        ArrayList<BasicNameValuePair> pairList = new ArrayList<BasicNameValuePair>();
        BasicNameValuePair methodPair = new BasicNameValuePair("method", "user.login");
        BasicNameValuePair vPair = new BasicNameValuePair("v", "3.0");
        BasicNameValuePair formatPair = new BasicNameValuePair("format", "json");
        BasicNameValuePair localPair = new BasicNameValuePair("local", "zh_CN");
        BasicNameValuePair appKeyPair = new BasicNameValuePair("appKey", this.getLvYunAppKey());
        BasicNameValuePair hotelGroupCodePair = new BasicNameValuePair("hotelGroupCode", this.getHotelGroupCode());
        BasicNameValuePair userCodePair = new BasicNameValuePair("usercode", this.getUserName());
        BasicNameValuePair passwordPair = new BasicNameValuePair("password", this.getPassword());
        BasicNameValuePair sign = new BasicNameValuePair("sign", this.getSign());
        pairList.add(methodPair);
        pairList.add(vPair);
        pairList.add(formatPair);
        pairList.add(localPair);
        pairList.add(appKeyPair);
        pairList.add(hotelGroupCodePair);
        pairList.add(userCodePair);
        pairList.add(passwordPair);
        pairList.add(sign);
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairList, Charset.forName("UTF-8")));
        try (CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);){
            String responseEntity = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
            logger.info("getSessionId http response= {}", (Object)responseEntity);
            JSONObject jsonObject = JSONObject.parseObject((String)responseEntity);
            this.sessionId = jsonObject.getString("resultInfo");
            this.sessionIdTime = System.currentTimeMillis();
            String string = this.sessionId;
            return string;
        }
        catch (IOException e) {
            logger.error("getSessionId failure ,e:", (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getCredits(String memberId, CloseableHttpClient httpClient) {
        if (StringUtils.isBlank((CharSequence)memberId)) {
            return "0";
        }
        String sessionId = this.getSessionId(httpClient);
        HashMap<String, String> newParams = new HashMap<String, String>();
        newParams.put("sessionId", sessionId);
        newParams.put("memberId", memberId);
        logger.info("LvYunSmsCodeAdapter getSendSmsCodeHttpPost newparams:{}", newParams);
        HttpPost httpPost = new HttpPost(this.getGetCreditsUrl());
        httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");
        httpPost.setHeader("User-Agent", "Apache-HttpClient/4.1.1(java 1.5)");
        httpPost.setHeader("Connection", "Keep-Alive");
        ArrayList<BasicNameValuePair> pairList = new ArrayList<BasicNameValuePair>();
        BasicNameValuePair sessionIdPair = new BasicNameValuePair("sessionId", sessionId);
        BasicNameValuePair mobilePair = new BasicNameValuePair("memberId", memberId);
        BasicNameValuePair hotelGroupIdPair = new BasicNameValuePair("hotelGroupId", this.getHotelGroupId());
        BasicNameValuePair appKeyPair = new BasicNameValuePair("appKey", this.getLvYunAppKey());
        BasicNameValuePair signPair = new BasicNameValuePair("sign", this.getSign(newParams));
        pairList.add(sessionIdPair);
        pairList.add(mobilePair);
        pairList.add(hotelGroupIdPair);
        pairList.add(signPair);
        pairList.add(appKeyPair);
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairList, Charset.forName("UTF-8")));
        try (CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);){
            String responseEntity = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
            logger.info("smsCode http response= {}", (Object)responseEntity);
            JSONObject jsonObject = JSONObject.parseObject((String)responseEntity);
            JSONObject result = jsonObject.getJSONObject("result");
            if (result == null) {
                String string2 = "0";
                return string2;
            }
            Double balance = result.getDouble("balance");
            String string = balance == null ? "0" : balance.toString();
            return string;
        }
        catch (IOException e) {
            logger.error("smsCode failure ,e:", (Throwable)e);
            return "0";
        }
    }

    public Set<Long> getAppIds() {
        return this.appIds;
    }

    public void setAppIds(Set<Long> appIds) {
        this.appIds = appIds;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getLvYunAppKey() {
        return this.lvYunAppKey;
    }

    public void setLvYunAppKey(String lvYunAppKey) {
        this.lvYunAppKey = lvYunAppKey;
    }

    public String getLvYunAppSecret() {
        return this.lvYunAppSecret;
    }

    public void setLvYunAppSecret(String lvYunAppSecret) {
        this.lvYunAppSecret = lvYunAppSecret;
    }

    public String getHotelGroupId() {
        return this.hotelGroupId;
    }

    public void setHotelGroupId(String hotelGroupId) {
        this.hotelGroupId = hotelGroupId;
    }

    public String getHotelGroupCode() {
        return this.hotelGroupCode;
    }

    public void setHotelGroupCode(String hotelGroupCode) {
        this.hotelGroupCode = hotelGroupCode;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getSessionIdUrl() {
        return this.sessionIdUrl;
    }

    public void setSessionIdUrl(String sessionIdUrl) {
        this.sessionIdUrl = sessionIdUrl;
    }

    public String getSubCreditsUrl() {
        return this.subCreditsUrl;
    }

    public void setSubCreditsUrl(String subCreditsUrl) {
        this.subCreditsUrl = subCreditsUrl;
    }

    public String getAddCreditsUrl() {
        return this.addCreditsUrl;
    }

    public void setAddCreditsUrl(String addCreditsUrl) {
        this.addCreditsUrl = addCreditsUrl;
    }

    public String getGetCreditsUrl() {
        return this.getCreditsUrl;
    }

    public void setGetCreditsUrl(String getCreditsUrl) {
        this.getCreditsUrl = getCreditsUrl;
    }

    public String getCoupons1() {
        return this.coupons1;
    }

    public void setCoupons1(String coupons1) {
        this.coupons1 = coupons1;
    }

    public String getCoupons2() {
        return this.coupons2;
    }

    public void setCoupons2(String coupons2) {
        this.coupons2 = coupons2;
    }

    public String getCoupons1Url() {
        return this.coupons1Url;
    }

    public void setCoupons1Url(String coupons1Url) {
        this.coupons1Url = coupons1Url;
    }

    public String getCoupons2Url() {
        return this.coupons2Url;
    }

    public void setCoupons2Url(String coupons2Url) {
        this.coupons2Url = coupons2Url;
    }

    public String getCredits() {
        return this.credits;
    }

    public void setCredits(String credits) {
        this.credits = credits;
    }
}

