/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.constant;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="skip.nofity")
public class SkipNotifyConfig {
    private Set<Long> appIdSet = Sets.newHashSet((Object[])new Long[]{-1L});
    private Set<Long> successAppIds = Collections.emptySet();
    private Set<Long> failedAppIds = Collections.emptySet();

    public Set<Long> getAppIdSet() {
        return this.appIdSet;
    }

    public void setAppIdSet(Set<Long> appIdSet) {
        this.appIdSet = appIdSet;
    }

    public boolean hasNotNotify(Long appId, Boolean result) {
        if (appId == null || result == null) {
            return true;
        }
        return this.hasNotNotify(appId) || result != false && this.hasSuccessNotNotify(appId) || result == false && this.hasFailedNotNotify(appId);
    }

    public boolean hasNotNotify(Long appId) {
        if (CollectionUtils.isEmpty(this.appIdSet)) {
            return false;
        }
        return this.appIdSet.contains(appId);
    }

    public Set<Long> getSuccessAppIds() {
        return this.successAppIds;
    }

    public void setSuccessAppIds(Set<Long> successAppIds) {
        this.successAppIds = successAppIds;
    }

    public Set<Long> getFailedAppIds() {
        return this.failedAppIds;
    }

    public void setFailedAppIds(Set<Long> failedAppIds) {
        this.failedAppIds = failedAppIds;
    }

    public boolean hasSuccessNotNotify(Long appId) {
        return CollectionUtils.isNotEmpty(this.successAppIds) && this.successAppIds.contains(appId);
    }

    public boolean hasFailedNotNotify(Long appId) {
        return CollectionUtils.isNotEmpty(this.failedAppIds) && this.failedAppIds.contains(appId);
    }
}

