/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.constant.hsbc;

import cn.com.duiba.biz.credits.strategy.ApiStrategyRouter;
import cn.com.duiba.biz.credits.strategy.Impl.HsbcApiStrategy;
import com.google.common.collect.Sets;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.Base64Utils;

@Configuration
@ConfigurationProperties(prefix="hsbc")
public class HsbcConfig
implements InitializingBean {
    @Resource
    private HsbcApiStrategy hsbcApiStrategy;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Set<Long> appIds = Sets.newHashSet((Object[])new Long[]{-1L});
    private String userInfoUrl = "";
    private static final String ALGORITHM_RSA = "RSA";
    private PrivateKey rsaDuibaPrivateKey;
    private PrivateKey rsaHsbcPrivateKey;
    private PublicKey rsaDuibaPublicKey;
    private PublicKey rsaHsbcPublicKey;
    private String rsaDuibaPrivateKeyConf;
    private String rsaDuibaPublicKeyConf;
    private String rsaHsbcPublicKeyConf;
    private String rsaHsbcPrivateKeyConf;
    private String rsaHsbcJwtKeyConf = "MIIEvAIBADANBgkqhkiG9w0BAQEFAASCBKYwggSiAgEAAoIBAQDHHMnMZUh0ILinlPH8x+0NmyYcg8SHpahFmZUZ16v9MUY5HbYTz4CjkYa7OmaXuxgoA7X2r30zdqAL6MEahfd+fnJ4fmZUb9I9hV9emlIjEunpKwSEDlc8rzC7WOqkDuZW9GfbNI76QFXB2lAnQQDwyIrO10uFSD5Kvvb6C0+Q3U5OGUpdydtI2vQ7IoW9ZxAd9r//99aLibGCBrnhTbnyBVxRt5Mo23aYPiwerIx2a6pMYkWz9vqZgnAhClRBcR/qT6JSF8u0zz26ZyS1Qa7k7Ad4caBytp6uO4M1bAsd9USvqNwxfJ0m4YMo1KehGrqIOSj52aavAhmwvg+Q1vdNAgMBAAECggEAK2EEPfma7WHrmOcESXQtGxfAF9pFSOA4ZuFs8HJiUAkaKXtlna9JcVlVJxk0HL5wJteYHyRgfIPNnoqY93RUVUSrH8E5/g9WmHykKHIqjuWh/GCY3URakSgBz+8xP4jXef5JWiJ7O94kUNWFPOgWkl6+jw2ssF7q41HzcMpiDUcmua4f5gHeu4BEORoAmvDnVdUGdhwitL18XV2/zuMrE3W1BayZfGvbTPo1z3v+SCpo/z7l/+UDgRINyo2KUHPBYXabuGMLodT9gkieVJnGiw0nhWREVNM1BXkcktaYabm42dELRSdzf9mXdTiH9al0xJW4NnjgiF8lS05O6RxRAQKBgQD8X9+ymDYfjlNEavAGxI7kfTi0qP3Bsgfu/RCNS+yYqlI2CjaGIuPqnqroK76Pdg9VyY3QajZHAITobLbf9OOsy5NZwgbsSN0XKQwYtCOn6mOWw/vjGPaUG6u2UCCTi8wiqzDKVnXnTWZutuwrij/9yb3iJ+0MztzLAT5xiGvbrQKBgQDJ+QoNB4/9nRJS8uey1/hd/0Lcs8Usm9NIwvXdwNLOCgsjx751CHP711ac9RWwVMwMC6Kgjl6QtHdvvU2FnoaagfVi3Z2xLubwQP4WofsCDRPjFiUGcsCeKE7btN0a+e9swbNlw09r4lq2FZs49QOAbYnJDss73aQvDKsTMiL+IQKBgAUVSUQnnK92BmdSYBNC0j3357R70uCb3V0K69JsvQ82HwHHouGAwmZvW7Hhb60kC5sGvDx+Zyl28TZdOjG4lP1d/FHKfqkzroBQ61V0C2PObMMUn3YrgovpIsRBSOav4iSwngL1StqlzHJebNNTrYZHEfQEKdogMIJGPCO9Q67hAoGAOTE6NWJU1d4qmC6Mico6XHOx/UkypmUhuVLryHWXvBx/9wvS1NUl8sSRlDSahaoddbO9w3VNNfDEeXHDh/jR6OKwF+TliIzdfF8LFGGd8IC/huh4Z5ELFj4XxoM6sS7hK4zWPhTGYqhgQ3tuzvwil7Vs9PApgLRMj74om3DxE8ECgYA2hyJ2TLIFUHO0W3hBwSxtnGK2gBsUWDi9v6e/b5JIBBHw1Oh1IGv4ziNxx8qZ3PsqxIKIOeBneDT7W1Uwrh68HH7TfYroOoLwUkShlpA73Thnffc4tRN76vrz50oXC3gFx4FH0N9dA2a3PT1olBORnaoS427A2M5vazjRApIXYA==";

    public void afterPropertiesSet() {
        ApiStrategyRouter.register(this.appIds, this.hsbcApiStrategy);
        try {
            if (StringUtils.isBlank((String)this.rsaDuibaPrivateKeyConf) || StringUtils.isBlank((String)this.rsaHsbcPublicKeyConf)) {
                throw new IllegalArgumentException("\u516c\u3001\u79c1\u94a5\u914d\u7f6e\u4e3a\u7a7a");
            }
            this.rsaDuibaPrivateKey = this.generatePrivateKey(this.rsaDuibaPrivateKeyConf);
            this.rsaHsbcPrivateKey = this.generatePrivateKey(this.rsaHsbcPrivateKeyConf);
            this.rsaDuibaPublicKey = this.generatePublicKey(this.rsaDuibaPublicKeyConf);
            this.rsaHsbcPublicKey = this.generatePublicKey(this.rsaHsbcPublicKeyConf);
        }
        catch (Exception e) {
            this.log.error("[hsbc] \u79d8\u94a5\u521d\u59cb\u5316\u5931\u8d25", (Throwable)e);
        }
    }

    private PrivateKey generatePrivateKey(String privateKeyConf) throws Exception {
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(Base64Utils.decodeFromString((String)privateKeyConf));
        KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM_RSA);
        return keyFactory.generatePrivate(keySpec);
    }

    private PublicKey generatePublicKey(String publicKeyConf) throws Exception {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(Base64Utils.decodeFromString((String)publicKeyConf));
        KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM_RSA);
        return keyFactory.generatePublic(keySpec);
    }

    public boolean isHsbcApp(Long appId) {
        return this.appIds.contains(appId);
    }

    public HsbcApiStrategy getHsbcApiStrategy() {
        return this.hsbcApiStrategy;
    }

    public void setHsbcApiStrategy(HsbcApiStrategy hsbcApiStrategy) {
        this.hsbcApiStrategy = hsbcApiStrategy;
    }

    public Set<Long> getAppIds() {
        return this.appIds;
    }

    public void setAppIds(Set<Long> appIds) {
        this.appIds = appIds;
    }

    public PrivateKey getRsaDuibaPrivateKey() {
        return this.rsaDuibaPrivateKey;
    }

    public void setRsaDuibaPrivateKey(PrivateKey rsaDuibaPrivateKey) {
        this.rsaDuibaPrivateKey = rsaDuibaPrivateKey;
    }

    public PublicKey getRsaHsbcPublicKey() {
        return this.rsaHsbcPublicKey;
    }

    public void setRsaHsbcPublicKey(PublicKey rsaHsbcPublicKey) {
        this.rsaHsbcPublicKey = rsaHsbcPublicKey;
    }

    public String getRsaDuibaPrivateKeyConf() {
        return this.rsaDuibaPrivateKeyConf;
    }

    public void setRsaDuibaPrivateKeyConf(String rsaDuibaPrivateKeyConf) {
        this.rsaDuibaPrivateKeyConf = rsaDuibaPrivateKeyConf;
    }

    public String getRsaHsbcPublicKeyConf() {
        return this.rsaHsbcPublicKeyConf;
    }

    public void setRsaHsbcPublicKeyConf(String rsaHsbcPublicKeyConf) {
        this.rsaHsbcPublicKeyConf = rsaHsbcPublicKeyConf;
    }

    public PublicKey getRsaDuibaPublicKey() {
        return this.rsaDuibaPublicKey;
    }

    public void setRsaDuibaPublicKey(PublicKey rsaDuibaPublicKey) {
        this.rsaDuibaPublicKey = rsaDuibaPublicKey;
    }

    public String getRsaDuibaPublicKeyConf() {
        return this.rsaDuibaPublicKeyConf;
    }

    public void setRsaDuibaPublicKeyConf(String rsaDuibaPublicKeyConf) {
        this.rsaDuibaPublicKeyConf = rsaDuibaPublicKeyConf;
    }

    public PrivateKey getRsaHsbcPrivateKey() {
        return this.rsaHsbcPrivateKey;
    }

    public void setRsaHsbcPrivateKey(PrivateKey rsaHsbcPrivateKey) {
        this.rsaHsbcPrivateKey = rsaHsbcPrivateKey;
    }

    public String getRsaHsbcPrivateKeyConf() {
        return this.rsaHsbcPrivateKeyConf;
    }

    public void setRsaHsbcPrivateKeyConf(String rsaHsbcPrivateKeyConf) {
        this.rsaHsbcPrivateKeyConf = rsaHsbcPrivateKeyConf;
    }

    public String getUserInfoUrl() {
        return this.userInfoUrl;
    }

    public void setUserInfoUrl(String userInfoUrl) {
        this.userInfoUrl = userInfoUrl;
    }

    public String getRsaHsbcJwtKeyConf() {
        return this.rsaHsbcJwtKeyConf;
    }

    public void setRsaHsbcJwtKeyConf(String rsaHsbcJwtKeyConf) {
        this.rsaHsbcJwtKeyConf = rsaHsbcJwtKeyConf;
    }
}

