/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.remoteimpl.yumin;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.constant.yumin.YmBankConfig;
import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.thirdparty.api.yumin.RemoteYmBankService;
import cn.com.duiba.thirdparty.dto.yumin.CheckBuyPermRequestDto;
import cn.com.duiba.thirdparty.dto.yumin.CheckBuyPermResponseDto;
import cn.com.duiba.thirdparty.dto.yumin.GoodsParamDto;
import cn.com.duiba.tool.AssembleTool;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RemoteYmBankServiceImpl
implements RemoteYmBankService {
    private static final Logger log = LoggerFactory.getLogger(RemoteYmBankServiceImpl.class);
    private static final RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(5000).setSocketTimeout(10000).setConnectionRequestTimeout(500).build();
    private static final int FIVE_SECONDS = 5000;
    private static final int TEN_SECONDS = 10000;
    private static final String CHECK_BUY_PERMISSION_PATH = "duiba/integral_mall/buyPermissions";
    @Resource(name="httpClient")
    private CloseableHttpClient httpClient;
    @Resource
    private YmBankConfig ymBankConfig;

    public CheckBuyPermResponseDto checkBuyPerm(CheckBuyPermRequestDto requestDto) throws BizException {
        HashMap param = Maps.newHashMap();
        param.put("appKey", requestDto.getAppKey());
        param.put("appSecret", requestDto.getAppSecret());
        param.put("timestamp", String.valueOf(System.currentTimeMillis()));
        param.put("uid", requestDto.getUid());
        param.put("goodsId", requestDto.getGoodsId());
        GoodsParamDto dto = requestDto.getGoodsParam();
        if (null != dto && null != dto.getAppItemId()) {
            GoodsParamDto goodsParamDto = new GoodsParamDto();
            goodsParamDto.setAppItemId(dto.getAppItemId());
            if (dto.getSmall_image() != null) {
                goodsParamDto.setSmall_image(dto.getSmall_image());
            } else {
                goodsParamDto.setSmall_image("");
            }
            if (dto.getLogo() != null) {
                goodsParamDto.setLogo(dto.getLogo());
            } else {
                goodsParamDto.setLogo("");
            }
            if (dto.getBanner_image() != null) {
                goodsParamDto.setBanner_image(dto.getBanner_image());
            } else {
                goodsParamDto.setBanner_image("");
            }
            if (dto.getTitle() != null) {
                goodsParamDto.setTitle(dto.getTitle());
            } else {
                goodsParamDto.setTitle("");
            }
            if (dto.getUrl() != null) {
                goodsParamDto.setUrl(dto.getUrl());
            } else {
                goodsParamDto.setUrl("");
            }
            if (StringUtils.isEmpty((CharSequence)dto.getFacePrice()) || "null".equals(dto.getFacePrice())) {
                goodsParamDto.setFacePrice("");
            } else {
                goodsParamDto.setFacePrice(dto.getFacePrice());
            }
            if (StringUtils.isEmpty((CharSequence)dto.getCash()) || "null".equals(dto.getCash())) {
                goodsParamDto.setCash("");
            } else {
                goodsParamDto.setCash(dto.getCash());
            }
            if (StringUtils.isEmpty((CharSequence)dto.getCredits()) || "null".equals(dto.getCredits())) {
                goodsParamDto.setCredits("0");
            } else {
                goodsParamDto.setCredits(dto.getCredits());
            }
            if (StringUtils.isEmpty((CharSequence)dto.getRemainStock()) || "null".equals(dto.getRemainStock())) {
                goodsParamDto.setRemainStock("");
            } else {
                goodsParamDto.setRemainStock(dto.getRemainStock());
            }
            param.put("goodsParam", JSON.toJSONString((Object)goodsParamDto));
        }
        param.put("sign", SignTool.sign((Map)param));
        param.remove("appSecret");
        String url = this.ymBankConfig.getUrl() + CHECK_BUY_PERMISSION_PATH;
        String assembleUrl = AssembleTool.assembleUrl(url, param);
        log.info("\u88d5\u6c11\u94f6\u884c-\u8bf7\u6c42url\uff0curl:{}", (Object)assembleUrl);
        HttpGet httpGet = new HttpGet(assembleUrl);
        httpGet.setConfig(requestConfig);
        String s = this.ymBankRequest((HttpUriRequest)httpGet);
        CheckBuyPermResponseDto checkBuyPermResponseDto = (CheckBuyPermResponseDto)JSONObject.parseObject((String)s, CheckBuyPermResponseDto.class);
        if (checkBuyPermResponseDto == null || "fail".equals(checkBuyPermResponseDto.getStatus())) {
            throw new BizException("\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        return checkBuyPermResponseDto;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String ymBankRequest(HttpUriRequest httpRequest) {
        try (CloseableHttpResponse response = this.httpClient.execute(httpRequest);){
            String responseStr = EntityUtils.toString((HttpEntity)response.getEntity());
            log.info("\u88d5\u6c11\u94f6\u884c\u54cd\u5e94\u53c2\u6570\uff0cparam:{}", (Object)responseStr);
            String string = responseStr;
            return string;
        }
        catch (Exception e) {
            log.warn("\u88d5\u6c11\u94f6\u884c\u54cd\u5e94\u5f02\u5e38\uff0curl:{},param:{}", new Object[]{httpRequest.getURI().getPath(), JSON.toJSONString((Object)httpRequest), e});
            return null;
        }
    }
}

