/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service;

import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class HttpClientFactory {
    private static final Logger log = LoggerFactory.getLogger(HttpClientFactory.class);
    public static final int CONNECT_TIMEOUT = 30000;
    public static final int DEFAULT_REQUEST_TIMEOUT = 5000;
    public static final int KEEPALIVE_TIMEOUT = 5000;
    public static final int SOCKET_TIMEOUT = 16000;
    public static final int MAX_CONNECT = 8000;
    public static final int MAX_ROUTE_CONNECT = 500;
    public static final int NOTIFY_CONNECT_TIMEOUT = 10000;
    public static final int NOTIFY_KEEPALIVE_TIMEOUT = 5000;
    public static final int NOTIFY_SOCKET_TIMEOUT = 5000;

    @Bean(initMethod="start", destroyMethod="close", name={"httpAsyncClient"})
    public CloseableHttpAsyncClient httpAsyncClient() {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(30000).setConnectionRequestTimeout(5000).setSocketTimeout(16000).build();
        CloseableHttpAsyncClient httpClient = HttpAsyncClients.custom().setDefaultRequestConfig(config).setMaxConnTotal(8000).setMaxConnPerRoute(500).setKeepAliveStrategy((ConnectionKeepAliveStrategy)HttpClientFactory.getKeepAliveStrategy(false)).build();
        log.info("HttpAsyncClientPool started");
        return httpClient;
    }

    @Bean(initMethod="start", destroyMethod="close", name={"addHttpAsyncClient"})
    public CloseableHttpAsyncClient addHttpAsyncClient() {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(30000).setConnectionRequestTimeout(5000).setSocketTimeout(16000).build();
        CloseableHttpAsyncClient httpClient = HttpAsyncClients.custom().setDefaultRequestConfig(config).setMaxConnTotal(3000).setMaxConnPerRoute(200).setKeepAliveStrategy((ConnectionKeepAliveStrategy)HttpClientFactory.getKeepAliveStrategy(false)).build();
        log.info("addHttpAsyncClientPool started");
        return httpClient;
    }

    @Bean(initMethod="start", destroyMethod="close", name={"slowHttpAsyncClient"})
    public CloseableHttpAsyncClient slowHttpAsyncClient() {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(30000).setConnectionRequestTimeout(5000).setSocketTimeout(16000).build();
        CloseableHttpAsyncClient httpClient = HttpAsyncClients.custom().setDefaultRequestConfig(config).setMaxConnTotal(1000).setMaxConnPerRoute(100).setKeepAliveStrategy((ConnectionKeepAliveStrategy)HttpClientFactory.getKeepAliveStrategy(false)).build();
        return httpClient;
    }

    @Bean(initMethod="start", destroyMethod="close", name={"virtualHttpAsyncClient"})
    public CloseableHttpAsyncClient virtualHttpAsyncClient() {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(30000).setConnectionRequestTimeout(5000).setSocketTimeout(16000).build();
        CloseableHttpAsyncClient httpClient = HttpAsyncClients.custom().setDefaultRequestConfig(config).setMaxConnTotal(3000).setMaxConnPerRoute(200).setKeepAliveStrategy((ConnectionKeepAliveStrategy)HttpClientFactory.getKeepAliveStrategy(false)).build();
        log.info("virtualHttpAsyncClient started");
        return httpClient;
    }

    @Bean(initMethod="start", destroyMethod="close", name={"httpAsyncNotifyClient"})
    public CloseableHttpAsyncClient httpAsyncNotifyClient() {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(10000).setConnectionRequestTimeout(5000).setSocketTimeout(5000).build();
        CloseableHttpAsyncClient httpClient = HttpAsyncClients.custom().setDefaultRequestConfig(config).setMaxConnTotal(3800).setMaxConnPerRoute(200).setKeepAliveStrategy((ConnectionKeepAliveStrategy)HttpClientFactory.getKeepAliveStrategy(true)).build();
        return httpClient;
    }

    @Bean(initMethod="start", destroyMethod="close", name={"slowHttpAsyncNotifyClient"})
    public CloseableHttpAsyncClient slowHttpAsyncNotifyClient() {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(10000).setConnectionRequestTimeout(5000).setSocketTimeout(5000).build();
        CloseableHttpAsyncClient httpClient = HttpAsyncClients.custom().setDefaultRequestConfig(config).setMaxConnTotal(1000).setMaxConnPerRoute(100).setKeepAliveStrategy((ConnectionKeepAliveStrategy)HttpClientFactory.getKeepAliveStrategy(true)).build();
        return httpClient;
    }

    private static DefaultConnectionKeepAliveStrategy getKeepAliveStrategy(final boolean isNotification) {
        return new DefaultConnectionKeepAliveStrategy(){

            public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                long duration = super.getKeepAliveDuration(response, context);
                if (duration == -1L) {
                    if (isNotification) {
                        return 5000L;
                    }
                    return 5000L;
                }
                return duration;
            }
        };
    }
}

