/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.impl;

import cn.com.duiba.service.Encryptor;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class AESEncryptor
implements Encryptor {
    @Override
    public byte[] encrypt(String algorithm, byte[] text, Key key) {
        try {
            Cipher cipher = Cipher.getInstance(algorithm);
            cipher.init(1, key);
            return cipher.doFinal(text);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public byte[] decrypt(String algorithm, byte[] cryptograph, Key key) {
        try {
            Cipher cipher = Cipher.getInstance(algorithm);
            cipher.init(2, key);
            return cipher.doFinal(cryptograph);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public Key generateKey(String algorithm, int bits, byte[] key) {
        try {
            KeyGenerator generator = KeyGenerator.getInstance(algorithm);
            SecureRandom securerandom = SecureRandom.getInstance("SHA1PRNG");
            securerandom.setSeed(key);
            generator.init(bits, securerandom);
            SecretKey secretKey = generator.generateKey();
            return new SecretKeySpec(secretKey.getEncoded(), algorithm);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

