/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.impl;

import cn.com.duiba.config.BlackHostConfig;
import cn.com.duiba.notifycenter.service.NotifyHttpClientPool;
import cn.com.duiba.service.HttpAsyncClientPool;
import cn.com.duiba.service.SlowRequestHandler;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.CanAccessInsideNetwork;
import com.alibaba.ttl.threadpool.TtlExecutors;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SlowRequestHandlerImpl
implements SlowRequestHandler,
InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(NotifyHttpClientPool.class);
    private static volatile Cache<String, AtomicLong> urlCache1 = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(20L, TimeUnit.SECONDS).build();
    private static volatile Cache<String, AtomicLong> urlCache2 = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(30L, TimeUnit.SECONDS).build();
    private static final int MAX_SIZE = 50000;
    private final BlockingQueue<NotifyHttpClientPool.CallbackProcesser> notifySlowRequestQueue = new LinkedBlockingQueue<NotifyHttpClientPool.CallbackProcesser>(50000);
    private final BlockingQueue<HttpAsyncClientPool.CallbackProcesser> creditsSlowRequestQueue = new LinkedBlockingQueue<HttpAsyncClientPool.CallbackProcesser>(50000);
    private final ExecutorService executorService = TtlExecutors.getTtlExecutorService((ExecutorService)Executors.newFixedThreadPool(2, new ThreadFactory(){
        private int count = 1;

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "SlowRequest-" + this.count++);
        }
    }));
    private volatile boolean isWork = true;
    @Resource(name="httpAsyncClient")
    @CanAccessInsideNetwork
    private CloseableHttpAsyncClient httpClient;
    private final long logSlowReqRtVal = 1000L;
    @Autowired
    private BlackHostConfig blackHostConfig;

    @Override
    public boolean isSlow(String url) {
        AtomicLong val1 = (AtomicLong)urlCache1.getIfPresent((Object)url);
        if (val1 != null && val1.get() >= 1L) {
            return true;
        }
        AtomicLong val2 = (AtomicLong)urlCache2.getIfPresent((Object)url);
        return val2 != null && val2.get() >= 3L;
    }

    @Override
    public synchronized void addSlow(String url, int delay) {
        if (delay >= 4) {
            AtomicLong val1 = (AtomicLong)urlCache1.getIfPresent((Object)url);
            if (val1 != null) {
                val1.incrementAndGet();
            } else {
                urlCache1.put((Object)url, (Object)new AtomicLong(1L));
            }
        } else {
            AtomicLong val2 = (AtomicLong)urlCache2.getIfPresent((Object)url);
            if (val2 != null) {
                val2.incrementAndGet();
            } else {
                urlCache2.put((Object)url, (Object)new AtomicLong(1L));
            }
        }
    }

    @Override
    public boolean addQueue(NotifyHttpClientPool.CallbackProcesser callbackProcesser) {
        if (this.notifySlowRequestQueue.size() > 50000) {
            log.warn("notify slow queue size exceeds {}", (Object)50000);
        }
        return this.notifySlowRequestQueue.add(callbackProcesser);
    }

    @Override
    public boolean addQueue(HttpAsyncClientPool.CallbackProcesser callbackProcesser) {
        if (this.creditsSlowRequestQueue.size() > 50000) {
            log.warn("credits slow queue size exceeds {}", (Object)50000);
        }
        return this.creditsSlowRequestQueue.add(callbackProcesser);
    }

    public void sendNotifyMsg() {
        NotifyHttpClientPool.CallbackProcesser processer = null;
        try {
            processer = this.notifySlowRequestQueue.take();
        }
        catch (InterruptedException e) {
            log.warn("", (Throwable)e);
        }
        if (processer == null) {
            return;
        }
        long s = System.currentTimeMillis();
        this.httpClient.execute(processer.getRequest(), (FutureCallback)processer);
        long cost = System.currentTimeMillis() - s;
        if (cost > 1000L) {
            log.warn("slow queue execute cost {}ms, host={}, appId={}", new Object[]{cost, processer.getRequest().getURI().getHost(), processer.getAppId()});
        }
    }

    public void sendCreditsMsg() {
        HttpAsyncClientPool.CallbackProcesser processer = null;
        try {
            processer = this.creditsSlowRequestQueue.take();
        }
        catch (InterruptedException e) {
            log.warn("", (Throwable)e);
        }
        if (processer == null) {
            return;
        }
        long s = System.currentTimeMillis();
        this.httpClient.execute(processer.getRequest(), (FutureCallback)processer);
        long cost = System.currentTimeMillis() - s;
        if (cost > 1000L) {
            log.warn("slow queue execute cost {}ms, host={}, key={}", new Object[]{cost, processer.getRequest().getURI().getHost(), processer.getQueueKey()});
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                while (SlowRequestHandlerImpl.this.isWork) {
                    try {
                        SlowRequestHandlerImpl.this.sendNotifyMsg();
                    }
                    catch (Exception e) {
                        log.warn("sendNotifyMsg failed", (Throwable)e);
                    }
                }
            }
        });
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                while (SlowRequestHandlerImpl.this.isWork) {
                    try {
                        SlowRequestHandlerImpl.this.sendCreditsMsg();
                    }
                    catch (Exception e) {
                        log.warn("sendCreditsMsg failed", (Throwable)e);
                    }
                }
            }
        });
    }

    public void destroy() throws Exception {
        this.isWork = false;
        this.executorService.shutdown();
    }

    @Override
    public boolean isBlackHost(String urlPath) {
        String blackHostCfg = this.blackHostConfig.getBlackHostConfig();
        if (StringUtils.isBlank((String)blackHostCfg)) {
            return false;
        }
        List<String> blackHostList = Arrays.asList(blackHostCfg.trim().split(","));
        for (String blackHost : blackHostList) {
            if (!urlPath.startsWith(blackHost)) continue;
            return true;
        }
        return false;
    }
}

