/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tool;

import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.domain.TopSecretDO;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.wolf.utils.DateUtils;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import net.sf.json.JSONObject;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;

public class CaiNiaoTool {
    private static final String SIGN_METHOD_HMAC = "hmac";
    public static final String CHARSET_UTF8 = "utf-8";
    public static final String CONTENT_ENCODING_GZIP = "gzip";
    public static final String DUIBA_PREFIX = "duiba_";

    public static Map<String, String> buildParamMap(Map<String, String> authParams, String method, String bizParamKey, Map<String, String> feildMap, TopSecretDO topSecretDO) {
        Map<String, String> params = CaiNiaoTool.buildPlatformParam(topSecretDO.getAppKey(), method);
        if (StringUtils.isNotBlank((String)authParams.get("timestamp")) && authParams.get("timestamp").indexOf(":") == -1) {
            authParams.put("timestamp", DateUtils.getSecondStr((long)Long.valueOf(authParams.get("timestamp"))));
        }
        params.put(bizParamKey, CaiNiaoTool.getBizParamStr(authParams, feildMap, topSecretDO.getAddPrefix()));
        try {
            params.put("sign", CaiNiaoTool.signTopRequest(params, topSecretDO.getAppSecret()));
        }
        catch (IOException e) {
            throw new IllegalStateException("\u7b7e\u540d\u51fa\u9519", e);
        }
        return params;
    }

    public static HttpRequestBase setHttpRequestHeader(String url, Map<String, String> params) {
        HttpPost http = AssembleTool.assembleRequest(url, params);
        http.setHeader("Accept", "text/xml,text/javascript");
        http.setHeader("User-Agent", "top-sdk-java");
        http.setHeader("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");
        http.setHeader("Accept-Encoding", CONTENT_ENCODING_GZIP);
        return http;
    }

    public static String getBizParamStr(Map<String, String> bizParams, Map<String, String> bizFeildMap, boolean addPrefix) {
        Map<String, String> authParams = MapUtils.isEmpty(bizFeildMap) ? bizParams : CaiNiaoTool.filterParamMap(bizParams, bizFeildMap);
        if (addPrefix) {
            authParams = CaiNiaoTool.buildPrefixMap(authParams);
        }
        String sign = SignTool.sign(authParams);
        authParams.put("duiba_sign", sign);
        if (addPrefix) {
            authParams.remove("duiba_appSecret");
        } else {
            authParams.remove("appSecret");
        }
        JSONObject jsonObject = JSONObject.fromObject(authParams);
        return jsonObject.toString();
    }

    private static Map<String, String> buildPrefixMap(Map<String, String> paramMap) {
        HashMap<String, String> urlParamMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : paramMap.entrySet()) {
            if (!StringUtils.isNotBlank((String)entry.getKey())) continue;
            if (entry.getKey().trim().startsWith(DUIBA_PREFIX)) {
                urlParamMap.put(entry.getKey().trim(), entry.getValue());
                continue;
            }
            urlParamMap.put(DUIBA_PREFIX + entry.getKey().trim(), entry.getValue());
        }
        return urlParamMap;
    }

    private static Map<String, String> filterParamMap(Map<String, String> bizParams, Map<String, String> bizFeildMap) {
        HashMap<String, String> authParams = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : bizParams.entrySet()) {
            if (StringUtils.isBlank((String)entry.getKey())) continue;
            String key = bizFeildMap.get(entry.getKey().trim());
            if (StringUtils.isNotBlank((String)key)) {
                authParams.put(key, entry.getValue());
                continue;
            }
            authParams.put(entry.getKey(), entry.getValue());
        }
        return authParams;
    }

    public static Map<String, String> buildPlatformParam(String appKey, String method) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("method", method);
        params.put("app_key", appKey);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        params.put("timestamp", df.format(new Date()));
        params.put("format", "json");
        params.put("v", "2.0");
        params.put("sign_method", SIGN_METHOD_HMAC);
        return params;
    }

    public static String signTopRequest(Map<String, String> params, String secret) throws IOException {
        Object[] keys = params.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        StringBuilder query = new StringBuilder();
        for (Object key : keys) {
            String value = params.get(key);
            if (!CaiNiaoTool.isNotEmpty((String)key) || !CaiNiaoTool.isNotEmpty(value)) continue;
            query.append((String)key).append(value);
        }
        byte[] bytes = CaiNiaoTool.encryptHMAC(query.toString(), secret);
        return CaiNiaoTool.byte2hex(bytes);
    }

    private static byte[] encryptHMAC(String data, String secret) throws IOException {
        byte[] bytes = null;
        try {
            SecretKeySpec secretKey = new SecretKeySpec(secret.getBytes(CHARSET_UTF8), "HmacMD5");
            Mac mac = Mac.getInstance(secretKey.getAlgorithm());
            mac.init(secretKey);
            bytes = mac.doFinal(data.getBytes(CHARSET_UTF8));
        }
        catch (GeneralSecurityException gse) {
            throw new IOException(gse.toString());
        }
        return bytes;
    }

    private static String byte2hex(byte[] bytes) {
        StringBuilder sign = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(bytes[i] & 0xFF);
            if (hex.length() == 1) {
                sign.append("0");
            }
            sign.append(hex.toUpperCase());
        }
        return sign.toString();
    }

    private static boolean isNotEmpty(String value) {
        int strLen;
        if (value == null || (strLen = value.length()) == 0) {
            return false;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(value.charAt(i))) continue;
            return true;
        }
        return false;
    }
}

