/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tool;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;

public class ZjUnionBankUtil {
    private static final String SHA_256_WITH_RSA = "SHA256withRSA";
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final String RSA = "RSA";

    public static String sign(JSONObject reqMsg, String privateKey) throws Exception {
        return ZjUnionBankUtil.sign(reqMsg, ZjUnionBankUtil.getPrivateKey(privateKey));
    }

    public static String sign(JSONObject reqMsg, PrivateKey privateKey) throws Exception {
        String sb = ZjUnionBankUtil.getStrByParam(reqMsg);
        Signature signature = Signature.getInstance(SHA_256_WITH_RSA);
        signature.initSign(privateKey);
        signature.update(ZjUnionBankUtil.sha256(sb.getBytes("UTF-8")).toLowerCase().getBytes());
        return Base64.encodeBase64String((byte[])signature.sign());
    }

    public static final String bytesToHexString(byte[] bArray) {
        StringBuffer sb = new StringBuffer(bArray.length);
        for (int i = 0; i < bArray.length; ++i) {
            String sTemp = Integer.toHexString(0xFF & bArray[i]);
            if (sTemp.length() < 2) {
                sb.append(0);
            }
            sb.append(sTemp.toUpperCase());
        }
        return sb.toString();
    }

    public static String sha256(byte[] data) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        return ZjUnionBankUtil.bytesToHexString(messageDigest.digest(data));
    }

    public static boolean verifySign(JSONObject reqMsg, String signText, String publicKeyStr) throws Exception {
        if (reqMsg == null || signText == null || publicKeyStr == null) {
            return false;
        }
        String sb = ZjUnionBankUtil.getStrByParam(reqMsg);
        return ZjUnionBankUtil.verifySign(sb, signText, ZjUnionBankUtil.getPublicKey(publicKeyStr));
    }

    private static String getStrByParam(JSONObject reqMsg) {
        TreeMap sortParams = new TreeMap((Map)JSONObject.toJavaObject((JSON)reqMsg, Map.class));
        TreeMap tree = new TreeMap();
        Iterator it = sortParams.entrySet().iterator();
        Set keySets = sortParams.keySet();
        ArrayList<String> keyList = new ArrayList<String>();
        for (String key : keySets) {
            keyList.add(key);
        }
        Collections.sort(keyList);
        while (it.hasNext()) {
            Map.Entry en = it.next();
            tree.put(en.getKey(), en.getValue());
        }
        it = tree.entrySet().iterator();
        StringBuffer sf = new StringBuffer();
        for (int i = 0; i < keyList.size(); ++i) {
            String key = (String)keyList.get(i);
            String value = (String)tree.get(key);
            if ("signature".equals(key) || "sign".equals(key)) continue;
            sf.append(key + "=" + value + "&");
        }
        return sf.substring(0, sf.length() - 1);
    }

    public static boolean verifySign(String plainText, String signText, PublicKey publicKey) throws Exception {
        Signature verifySign = Signature.getInstance(SHA_256_WITH_RSA);
        verifySign.initVerify(publicKey);
        verifySign.update(ZjUnionBankUtil.sha256(plainText.getBytes()).toLowerCase().getBytes(StandardCharsets.UTF_8));
        return verifySign.verify(Base64.decodeBase64((String)signText));
    }

    public static PublicKey getPublicKey(String publicKeyStr) throws Exception {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(Base64.decodeBase64((String)publicKeyStr));
        KeyFactory keyFactory = KeyFactory.getInstance(RSA);
        return keyFactory.generatePublic(keySpec);
    }

    public static PrivateKey getPrivateKey(String key) throws Exception {
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(Base64.decodeBase64((String)key));
        KeyFactory keyFactory = KeyFactory.getInstance(RSA);
        return keyFactory.generatePrivate(keySpec);
    }

    public static String encerypt(String data, String publicKeyStr) throws Exception {
        Cipher cipher = Cipher.getInstance(RSA);
        cipher.init(1, ZjUnionBankUtil.getPublicKey(publicKeyStr));
        byte[] cipherText = cipher.doFinal(data.getBytes());
        return Base64.encodeBase64String((byte[])cipherText);
    }
}

