/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tool.haoxiangni;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SignUtils.class);

    public static String getSign(Map<String, Object> params, String secret) {
        JSONObject jsonObject = JSONObject.parseObject((String)JSON.toJSONString(params));
        Object[] keys = params.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        StringBuilder query = new StringBuilder(secret);
        Object[] var5 = keys;
        int var6 = keys.length;
        for (int var7 = 0; var7 < var6; ++var7) {
            Object key = var5[var7];
            String value = jsonObject.getString((String)key);
            if (value == null || "".equals(value) || value.startsWith("[") || value.startsWith("{")) continue;
            query.append((String)key).append(value);
        }
        try {
            return SignUtils.encryptMD5(query.toString());
        }
        catch (IOException var10) {
            LOGGER.error("MD5\u52a0\u5bc6\u5f02\u5e38", (Throwable)var10);
            return null;
        }
    }

    private static String encryptMD5(String data) throws IOException {
        byte[] bytes;
        Object var1 = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            bytes = md.digest(data.getBytes("utf-8"));
        }
        catch (GeneralSecurityException var3) {
            throw new IOException(var3.getMessage());
        }
        return SignUtils.byte2hex(bytes);
    }

    private static String byte2hex(byte[] b) {
        StringBuilder hs = new StringBuilder();
        for (int n = 0; b != null && n < b.length; ++n) {
            String stmp = Integer.toHexString(b[n] & 0xFF);
            if (stmp.length() == 1) {
                hs.append('0');
            }
            hs.append(stmp);
        }
        return hs.toString().toUpperCase();
    }

    public static void main(String[] args) {
        SignUtils.infoGetReq();
    }

    public static void accessTokenReq() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appKey", "NS10000186035");
        map.put("groupId", 10000186L);
        map.put("nonce", System.currentTimeMillis());
        System.out.println(map.get("nonce"));
        String sign = SignUtils.getSign(map, "D596D045174ACE4AF62315C75C7FEA01");
        System.out.println(sign);
    }

    public static void infoGetReq() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appKey", "NS10000186035");
        map.put("groupId", 10000186L);
        map.put("nonce", System.currentTimeMillis());
        map.put("accessToken", "5ae3a76e068e47a3853ce4333917d467");
        map.put("wechatUnionid", "ocUyqwRH1nzg6qCpTBYGrL8NMcIg-1");
        System.out.println(map.get("nonce"));
        String sign = SignUtils.getSign(map, "D596D045174ACE4AF62315C75C7FEA01");
        System.out.println(sign);
    }
}

