/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tool.hn;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class HmacSha {
    private static final String KEY_MAC = "HmacSHA256";
    private static final String[] hexDigits = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};

    public static String encryptBase64(byte[] key) throws Exception {
        return new BASE64Encoder().encodeBuffer(key);
    }

    public static byte[] decryptBase64(String key) throws Exception {
        return new BASE64Decoder().decodeBuffer(key);
    }

    public static String init() {
        String str = "";
        try {
            KeyGenerator generator = KeyGenerator.getInstance(KEY_MAC);
            SecretKey key = generator.generateKey();
            str = HmacSha.encryptBase64(key.getEncoded());
        }
        catch (NoSuchAlgorithmException var3) {
            var3.printStackTrace();
        }
        catch (Exception var4) {
            var4.printStackTrace();
        }
        return str;
    }

    public static byte[] encryptHMAC(byte[] data, String key) {
        byte[] bytes = null;
        try {
            SecretKeySpec secretKey = new SecretKeySpec(key.getBytes(), KEY_MAC);
            Mac mac = Mac.getInstance(KEY_MAC);
            mac.init(secretKey);
            bytes = mac.doFinal(data);
        }
        catch (Exception var5) {
            var5.printStackTrace();
        }
        return bytes;
    }

    public static String encryptHMAC(String data, String key) throws UnsupportedEncodingException {
        if (data != null && !"".equals(data)) {
            byte[] bytes = HmacSha.encryptHMAC(data.getBytes("utf-8"), key);
            return HmacSha.byteArrayToHexString(bytes);
        }
        return null;
    }

    private static String byteToHexString(byte b) {
        int ret = b;
        if (b < 0) {
            ret = b + 256;
        }
        int m = ret / 16;
        int n = ret % 16;
        return hexDigits[m] + hexDigits[n];
    }

    private static String byteArrayToHexString(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            sb.append(HmacSha.byteToHexString(bytes[i]));
        }
        return sb.toString().toUpperCase();
    }

    public static String HMACSHA256(byte[] data, byte[] key) {
        try {
            SecretKeySpec signingKey = new SecretKeySpec(key, KEY_MAC);
            Mac mac = Mac.getInstance(KEY_MAC);
            mac.init(signingKey);
            return HmacSha.byte2hex(mac.doFinal(data));
        }
        catch (NoSuchAlgorithmException var4) {
            var4.printStackTrace();
        }
        catch (InvalidKeyException var5) {
            var5.printStackTrace();
        }
        return null;
    }

    public static String byte2hex(byte[] b) {
        StringBuilder hs = new StringBuilder();
        for (int n = 0; b != null && n < b.length; ++n) {
            String stmp = Integer.toHexString(b[n] & 0xFF);
            if (stmp.length() == 1) {
                hs.append('0');
            }
            hs.append(stmp);
        }
        return hs.toString().toUpperCase();
    }

    public static void main(String[] args) throws Exception {
        String key = "d2adf0130212287302982b914abc9e50";
        System.out.println("Mac\u5bc6\u94a5:\n" + key);
        String word = "d2adf0130212287302982b914abc9e50RegionId4accessToken58d238d7-45ff-4f02-bc94-6cd93c5fff2cappId501123busiSerial2016102011223320345443content{\"timestamp\":\"2016-09-21 17:11:11\",\"apptx\":\"1820160819163325473\",\"msg\":{\"channelId\":\"74af217\",\"channelType\":\"2010100\",\"city\":\"743\",\"district\":\"742019\",\"netType\":\"2G\",\"number\":\"18593750102\",\"operatorId\":\"Axxh01\",\"province\":\"74\"}}formatjsonmethodABILITY_10001600openId1operId1timestamp20161020091800version1d2adf0130212287302982b914abc9e50";
        System.out.println(HmacSha.encryptHMAC(word, key));
        System.out.println(HmacSha.HMACSHA256(word.getBytes(), key.getBytes()));
    }
}

