/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tool.hsbc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ResourceUtils;

public class SignUtil {
    private static String CHARSET_ENCODING = "UTF-8";
    private static String ALGORITHM = "SHA256withRSA";
    private static final Logger LOG = LoggerFactory.getLogger(SignUtil.class);

    public static String sign(String srcData, String privateKeyPath, String privateKeyPwd) {
        if (srcData == null || privateKeyPath == null || privateKeyPwd == null) {
            return "";
        }
        try {
            PrivateKey key = SignUtil.readPrivate(privateKeyPath, privateKeyPwd);
            Signature signature = Signature.getInstance(ALGORITHM);
            signature.initSign(key);
            signature.update(srcData.getBytes(CHARSET_ENCODING));
            byte[] signedData = signature.sign();
            return Base64.getEncoder().encodeToString(signedData);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static boolean verify(String srcData, String signedData, String publicKeyPath) {
        if (srcData == null || signedData == null || publicKeyPath == null) {
            return false;
        }
        try {
            PublicKey publicKey = SignUtil.readPublic(publicKeyPath);
            Signature sign = Signature.getInstance(ALGORITHM);
            sign.initVerify(publicKey);
            sign.update(srcData.getBytes(CHARSET_ENCODING));
            return sign.verify(Base64.getDecoder().decode(signedData));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PublicKey readPublic(String publicKeyPath) {
        if (publicKeyPath == null) {
            return null;
        }
        PublicKey pk = null;
        FileInputStream bais = null;
        try {
            CertificateFactory certificatefactory = CertificateFactory.getInstance("X.509");
            bais = new FileInputStream(publicKeyPath);
            X509Certificate cert = (X509Certificate)certificatefactory.generateCertificate(bais);
            pk = cert.getPublicKey();
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            if (bais != null) {
                try {
                    bais.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return pk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PrivateKey readPrivate(String privateKeyPath, String privateKeyPwd) {
        if (privateKeyPath == null || privateKeyPwd == null) {
            return null;
        }
        InputStream stream = null;
        try {
            PrivateKey key;
            KeyStore store = KeyStore.getInstance("JKS");
            File url = ResourceUtils.getFile((String)"classpath:certs/keystore.p12");
            stream = new FileInputStream(url);
            store.load(stream, privateKeyPwd.toCharArray());
            Enumeration<String> en = store.aliases();
            String pName = null;
            while (en.hasMoreElements()) {
                String n = en.nextElement();
                if (!store.isKeyEntry(n)) continue;
                pName = n;
            }
            PrivateKey privateKey = key = (PrivateKey)store.getKey(pName, privateKeyPwd.toCharArray());
            return privateKey;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public static PrivateKey readPrivateFromPEMFile(String privateKey) throws Exception {
        privateKey = privateKey.replaceAll("-*BEGIN.*KEY-*", "").replaceAll("-*END.*KEY-*", "").replaceAll("\\s+", "");
        byte[] encodedKey = Base64.getDecoder().decode(privateKey);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(encodedKey);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        PrivateKey privKey = kf.generatePrivate(keySpec);
        return privKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFileContent(File file) {
        BufferedReader reader = null;
        StringBuffer sbf = new StringBuffer();
        try {
            String tempStr;
            reader = new BufferedReader(new FileReader(file));
            while ((tempStr = reader.readLine()) != null) {
                sbf.append(tempStr + "\n");
            }
            reader.close();
            System.out.println("\u6587\u4ef6\u5185\u5bb9\uff1a" + tempStr);
            String string = sbf.toString();
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
        return sbf.toString();
    }
}

