/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.api.bo.subcredits.SubCreditsMsgDto;
import cn.com.duiba.constant.CebBankConfig;
import cn.com.duiba.credits.sdk.CreditConsumeParams;
import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.dao.AppDAO;
import cn.com.duiba.domain.AppDO;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.enums.cebbank.CebBankTransCodeEnum;
import cn.com.duiba.enums.cebbank.CebBankTypeEnum;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.thirdparty.dto.cebbank.CebBankObjectNotifyDto;
import cn.com.duiba.tool.AssembleTool;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CebBankApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(CebBankApi.class);
    @Autowired
    private CebBankConfig cebBankConfig;
    @Autowired
    private AppDAO appDAO;

    public boolean isCebBank(Long appId) {
        return appId != null && CollectionUtils.isNotEmpty(this.cebBankConfig.getAppIdSet()) && this.cebBankConfig.getAppIdSet().contains(appId);
    }

    public CreditsMessage getSubCreditsMessage(CreditsMessage request) {
        String url = request.getHttpUrl();
        String newUrl = url.substring(0, url.indexOf(63));
        String params = url.substring(url.indexOf(63) + 1);
        Map<String, String> requestParams = this.buildRequestParams(Long.valueOf(request.getAppId()), params, request.getRelationId(), request.getParams());
        request.setHttpUrl(AssembleTool.assembleUrl(newUrl, requestParams));
        LOGGER.info("\u5149\u5927\u94f6\u884c-\u6784\u9020\u6263\u79ef\u5206\u8bf7\u6c42-\u5165\u53e3\u662fremote\u63a5\u53e3\uff0chttpUrl:{}", (Object)request.getHttpUrl());
        return request;
    }

    private Map<String, String> buildRequestParams(Long appId, String authParams, String relationId, Map<String, String> paramMap) {
        Map<String, String> authParamMap = AssembleTool.getUrlParams(authParams);
        AppDO appDO = this.appDAO.getAppByCache(appId);
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put("uid", authParamMap.get("uid"));
        requestParams.put("credits", authParamMap.get("credits"));
        requestParams.put("appKey", appDO.getAppKey());
        requestParams.put("timestamp", String.valueOf(System.currentTimeMillis()));
        requestParams.put("description", authParamMap.get("description"));
        requestParams.put("orderNum", relationId);
        requestParams.put("type", CebBankTypeEnum.GAME.getCode());
        requestParams.put("transType", paramMap.get("opId"));
        requestParams.put("transCode", CebBankTransCodeEnum.SUB_CREDITS.getCode());
        requestParams.put("appSecret", this.appDAO.getAppSecret(appDO));
        requestParams.put("sign", SignTool.sign(requestParams));
        requestParams.remove("appSecret");
        requestParams.put("appId", String.valueOf(appId));
        return requestParams;
    }

    public SubCreditsMsgWrapper getSubCreditsMessage(SubCreditsMsgWrapper subCreditsMsgWrapper) {
        String url = subCreditsMsgWrapper.getHttpUrl();
        String newUrl = url.substring(0, url.indexOf(63));
        Map<String, String> requestParams = this.buildRequestParams(subCreditsMsgWrapper);
        subCreditsMsgWrapper.setHttpUrl(AssembleTool.assembleUrl(newUrl, requestParams));
        LOGGER.info("\u5149\u5927\u94f6\u884c-\u6784\u9020\u6263\u79ef\u5206\u8bf7\u6c42-\u5165\u53e3\u662frocketmq\uff0chttpUrl:{}", (Object)subCreditsMsgWrapper.getHttpUrl());
        return subCreditsMsgWrapper;
    }

    private Map<String, String> buildRequestParams(SubCreditsMsgWrapper subCreditsMsgWrapper) {
        SubCreditsMsgDto subCreditsMsgDto = subCreditsMsgWrapper.getSubCreditsMsg();
        CreditConsumeParams creditConsumeParams = subCreditsMsgDto.getCreditConsumeParams();
        Map paramMap = subCreditsMsgDto.getParams();
        AppDO appDO = this.appDAO.getAppByCache(subCreditsMsgDto.getAppId());
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put("uid", creditConsumeParams.getUid());
        requestParams.put("credits", String.valueOf(creditConsumeParams.getCredits()));
        requestParams.put("appKey", appDO.getAppKey());
        requestParams.put("timestamp", String.valueOf(System.currentTimeMillis()));
        requestParams.put("description", creditConsumeParams.getDescription());
        requestParams.put("orderNum", subCreditsMsgDto.getRelationId());
        requestParams.put("type", CebBankTypeEnum.GAME.getCode());
        requestParams.put("transType", (String)paramMap.get("opId"));
        requestParams.put("transCode", CebBankTransCodeEnum.SUB_CREDITS.getCode());
        requestParams.put("appSecret", this.appDAO.getAppSecret(appDO));
        requestParams.put("sign", SignTool.sign(requestParams));
        requestParams.remove("appSecret");
        requestParams.put("appId", String.valueOf(subCreditsMsgDto.getAppId()));
        return requestParams;
    }

    public CreditsMessageDto getAddCreditsMessage(CreditsMessageDto request) {
        String url = request.getHttpUrl();
        String newUrl = url.substring(0, url.indexOf(63));
        Map<String, String> requestParams = this.buildAddCreditsRequestParams(request);
        request.setHttpUrl(AssembleTool.assembleUrl(newUrl, requestParams));
        LOGGER.info("\u5149\u5927\u94f6\u884c-\u6784\u9020\u52a0\u79ef\u5206\u8bf7\u6c42\uff0chttpUrl:{}", (Object)request.getHttpUrl());
        return request;
    }

    private Map<String, String> buildAddCreditsRequestParams(CreditsMessageDto request) {
        Map authParams = request.getAuthParams();
        Map paramMap = request.getParams();
        AppDO appDO = this.appDAO.getAppByCache(Long.valueOf(request.getAppId()));
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put("appKey", appDO.getAppKey());
        requestParams.put("uid", (String)authParams.get("uid"));
        requestParams.put("credits", (String)authParams.get("credits"));
        requestParams.put("type", CebBankTypeEnum.GAME.getCode());
        requestParams.put("orderNum", request.getRelationId());
        requestParams.put("timestamp", String.valueOf(System.currentTimeMillis()));
        requestParams.put("description", (String)authParams.get("description"));
        requestParams.put("transType", (String)paramMap.get("opId"));
        requestParams.put("transCode", CebBankTransCodeEnum.ADD_CREDITS.getCode());
        requestParams.put("appSecret", this.appDAO.getAppSecret(appDO));
        requestParams.put("sign", SignTool.sign(requestParams));
        requestParams.remove("appSecret");
        requestParams.put("appId", String.valueOf(request.getAppId()));
        return requestParams;
    }

    public HttpRequestBase getRequestNotify(String notifyUrl, NotifyQueueDO record, AppDO appDO) {
        Map<String, String> requestParams = this.buildNotifyRequestParams(record, appDO);
        HttpGet request = new HttpGet(AssembleTool.assembleUrl(notifyUrl, requestParams));
        request.setConfig(this.getDefaultConfig());
        LOGGER.info("\u5149\u5927\u94f6\u884c-\u6784\u9020\u901a\u77e5\u8bf7\u6c42\uff0chttpUrl:{}", (Object)request.getURI());
        return request;
    }

    private RequestConfig getDefaultConfig() {
        return RequestConfig.custom().setConnectTimeout(30000).setConnectionRequestTimeout(30000).setSocketTimeout(30000).build();
    }

    private Map<String, String> buildNotifyRequestParams(NotifyQueueDO record, AppDO appDO) {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put("appKey", appDO.getAppKey());
        requestParams.put("uid", record.getPartnerUserId());
        requestParams.put("orderNum", String.valueOf(record.getRelationId()));
        requestParams.put("timestamp", String.valueOf(System.currentTimeMillis()));
        requestParams.put("success", record.getResult().toString());
        requestParams.put("bizId", record.getDeveloperBizId());
        requestParams.put("errorMessage", record.getError4developer());
        requestParams.put("transType", String.valueOf(record.getRelationId()));
        requestParams.put("transCode", CebBankTransCodeEnum.NOTIFY.getCode());
        requestParams.put("appSecret", this.appDAO.getAppSecret(appDO));
        requestParams.put("sign", SignTool.sign(requestParams));
        requestParams.remove("appSecret");
        requestParams.put("appId", String.valueOf(record.getAppId()));
        return requestParams;
    }

    public SupplierRequest getVirtualRequest(SupplierRequest request) {
        String url = request.getHttpUrl();
        String newUrl = url.substring(0, url.indexOf(63));
        String authParams = url.substring(url.indexOf(63) + 1);
        Map<String, String> requestParams = this.buildVirtualRequestParams(Long.valueOf(request.getAppId()), authParams, request.getParams());
        request.setHttpUrl(AssembleTool.assembleUrl(newUrl, requestParams));
        LOGGER.info("\u5149\u5927\u94f6\u884c-\u6784\u9020\u865a\u62df\u5546\u54c1\u8bf7\u6c42\uff0chttpUrl:{}", (Object)request.getHttpUrl());
        return request;
    }

    private Map<String, String> buildVirtualRequestParams(Long appId, String authParams, Map<String, String> paramMap) {
        Map<String, String> authParamMap = AssembleTool.getUrlParams(authParams);
        AppDO appDO = this.appDAO.getAppByCache(appId);
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put("appKey", appDO.getAppKey());
        requestParams.put("uid", authParamMap.get("uid"));
        requestParams.put("credits", authParamMap.get("params"));
        requestParams.put("type", CebBankTypeEnum.GAME.getCode());
        requestParams.put("orderNum", authParamMap.get("orderNum"));
        requestParams.put("timestamp", String.valueOf(System.currentTimeMillis()));
        requestParams.put("description", authParamMap.get("description"));
        requestParams.put("transType", paramMap.get("opId"));
        requestParams.put("transCode", CebBankTransCodeEnum.ADD_CREDITS.getCode());
        requestParams.put("appSecret", this.appDAO.getAppSecret(appDO));
        requestParams.put("sign", SignTool.sign(requestParams));
        requestParams.remove("appSecret");
        requestParams.put("appId", String.valueOf(appId));
        return requestParams;
    }

    public Map<String, String> buildRequestPrams(CebBankObjectNotifyDto cebBankObjectNotifyDto) {
        AppDO appDO = this.appDAO.getAppByCache(cebBankObjectNotifyDto.getAppId());
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put("uid", cebBankObjectNotifyDto.getUid());
        requestParams.put("itemCode", cebBankObjectNotifyDto.getItemCode());
        requestParams.put("appKey", appDO.getAppKey());
        requestParams.put("timestamp", String.valueOf(System.currentTimeMillis()));
        requestParams.put("orderNum", cebBankObjectNotifyDto.getOrderNum());
        requestParams.put("transType", cebBankObjectNotifyDto.getTransType());
        requestParams.put("type", CebBankTypeEnum.OBJECT.getCode());
        requestParams.put("userName", cebBankObjectNotifyDto.getUserName());
        requestParams.put("userMobile", cebBankObjectNotifyDto.getUserMobile());
        requestParams.put("address", cebBankObjectNotifyDto.getAddress());
        requestParams.put("province", cebBankObjectNotifyDto.getProvince());
        requestParams.put("city", cebBankObjectNotifyDto.getCity());
        requestParams.put("county", cebBankObjectNotifyDto.getCounty());
        requestParams.put("description", cebBankObjectNotifyDto.getDescription());
        requestParams.put("transCode", CebBankTransCodeEnum.OBJECT_EXCHANGE.getCode());
        requestParams.put("appSecret", this.appDAO.getAppSecret(appDO));
        requestParams.put("sign", SignTool.sign(requestParams));
        requestParams.remove("appSecret");
        requestParams.put("appId", String.valueOf(cebBankObjectNotifyDto.getAppId()));
        return requestParams;
    }
}

