/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.biz.credits.AddCreditsToDeveloper;
import cn.com.duiba.biz.credits.ErweihuoApi;
import cn.com.duiba.domain.HttpMessageDO;
import cn.com.duiba.domain.RequestTypeEnum;
import cn.com.duiba.order.center.api.dto.CreditsCallbackMessage;
import cn.com.duiba.service.HttpAsyncClientPool;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.HttpRequestLog;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomQueryCreditsToDeveloper {
    private static final Logger LOG = LoggerFactory.getLogger(CustomQueryCreditsToDeveloper.class);
    @Autowired
    private HttpAsyncClientPool httpAsyncClientPool;
    @Autowired
    private ErweihuoApi erweihuoApi;
    @Autowired
    private AddCreditsToDeveloper addCreditsToDeveloper;

    public void dealCredits(final HttpMessageDO httpMessage, final CreditsMessageDto req, final CreditsCallbackMessage resp) {
        HttpGet http;
        final CreditsMessageDto creditsMessageDto = this.erweihuoApi.getQueryCreditsMessage(req);
        if ("post".equals(creditsMessageDto.getHttpType())) {
            Map authParams = creditsMessageDto.getAuthParams();
            if (MapUtils.isNotEmpty((Map)authParams)) {
                authParams.remove("appSecret");
            }
            http = AssembleTool.assembleRequest(creditsMessageDto.getHttpUrl(), authParams);
        } else {
            http = new HttpGet(creditsMessageDto.getHttpUrl());
        }
        HttpRequestLog.logUrl("[action queryCredits][request bizId " + creditsMessageDto.getRelationId() + "] [type " + creditsMessageDto.getRelationType() + "] [url " + creditsMessageDto.getHttpUrl() + "][authParams " + creditsMessageDto.getAuthParams() + "][consumerId " + creditsMessageDto.getConsumerId() + "]");
        this.httpAsyncClientPool.submit(creditsMessageDto.getAppId(), (HttpUriRequest)http, new FutureCallback<HttpResponse>(){

            public void completed(HttpResponse response) {
                try {
                    Header header = response.getEntity().getContentEncoding();
                    String result = header != null && header.toString().contains("gzip") ? EntityUtils.toString((HttpEntity)new GzipDecompressingEntity(response.getEntity())) : EntityUtils.toString((HttpEntity)response.getEntity());
                    HttpRequestLog.logUrl("[action queryCredits] [response type completed] [body " + result + "]");
                    Object credits = CustomQueryCreditsToDeveloper.this.erweihuoApi.parseQueryCrditsRsp(result);
                    if (credits == null) {
                        LOG.info("\u67e5\u8be2\u4e8c\u7ef4\u706b\u79ef\u5206\u4e3a\u7a7a");
                        return;
                    }
                    String message = resp.getMessage();
                    if (StringUtils.isBlank((String)message)) {
                        LOG.info("\u4e8c\u7ef4\u706b\u52a0\u79ef\u5206\u89e3\u6790\u7684\u8fd4\u56demessage\u4e3a\u7a7a");
                        return;
                    }
                    JSONObject jsonObject = JSONObject.parseObject((String)message);
                    jsonObject.put("credits", (Object)String.valueOf(credits));
                    resp.setMessage(jsonObject.toJSONString());
                    CustomQueryCreditsToDeveloper.this.addCreditsToDeveloper.sendBlockMq(httpMessage, req, resp);
                }
                catch (Exception e) {
                    LOG.info("toDeveloper completed", (Throwable)e);
                }
            }

            public void failed(Exception ex) {
                LOG.info("toDeveloper cancelled bizId:" + creditsMessageDto.getRelationId() + " bizType:" + creditsMessageDto.getRelationType());
            }

            public void cancelled() {
                LOG.info("toDeveloper cancelled bizId:" + creditsMessageDto.getRelationId() + " bizType:" + creditsMessageDto.getRelationType());
            }
        }, RequestTypeEnum.ADD_CREDITS);
    }
}

