/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.constant.GangZhongLvConfig;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.hutool.core.util.XmlUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GangZhongLvApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(GangZhongLvApi.class);
    @Autowired
    private GangZhongLvConfig gangZhongLvConfig;

    public Boolean isGangZhongLv(Long appId) {
        Set<Long> appIds = this.gangZhongLvConfig.getAppIds();
        if (null == appIds) {
            return false;
        }
        return appIds.contains(appId);
    }

    public HttpRequestBase getAddCreditsMessage(CreditsMessageDto request) {
        String httpUrl = request.getHttpUrl();
        String paramStr = httpUrl.substring(httpUrl.indexOf(63) + 1);
        Map<String, String> params = AssembleTool.getUrlParams(paramStr);
        return this.getAddCreditsRequest(params, httpUrl);
    }

    private HttpPost getAddCreditsRequest(Map<String, String> params, String httpUrl) {
        HttpPost post = new HttpPost(httpUrl);
        String auth = this.gangZhongLvConfig.getAddUserName() + ":" + this.gangZhongLvConfig.getAddPassword();
        post.addHeader("Content-Type", "application/json; charset=UTF-8");
        post.addHeader("Authorization", "Basic " + Base64.encodeBase64String((byte[])auth.getBytes()));
        post.setEntity((HttpEntity)new StringEntity(JSON.toJSONString(this.buildAddCreditsAuthParams(params, params.get("credits"))), "utf-8"));
        return post;
    }

    public HttpRequestBase getSubCreditsMessage(CreditsMessage message) {
        String url = message.getHttpUrl();
        String paramsStr = url.substring(url.indexOf(63) + 1);
        Map<String, String> params = AssembleTool.getUrlParams(paramsStr);
        message.setHttpType("post");
        message.setHttpUrl(url);
        message.setAuthParams(params);
        return this.getXmlRequest(message.getHttpUrl(), params, true);
    }

    public HttpRequestBase getSubCreditsMessage(SubCreditsMsgWrapper message) {
        String url = message.getHttpUrl();
        String paramsStr = url.substring(url.indexOf(63) + 1);
        Map<String, String> params = AssembleTool.getUrlParams(paramsStr);
        message.getSubCreditsMsg().setHttpType(2);
        message.setHttpUrl(url);
        message.getSubCreditsMsg().setAuthParams(params);
        return this.getXmlRequest(message.getHttpUrl(), params, true);
    }

    public HttpRequestBase getVirtualRequest(SupplierRequest request) {
        String url = request.getHttpUrl();
        String paramsStr = url.substring(url.indexOf(63) + 1);
        Map<String, String> params = AssembleTool.getUrlParams(paramsStr);
        String goodsNum = params.get("params");
        request.setAuthParams(params);
        if (goodsNum.startsWith(this.gangZhongLvConfig.getVirtualPre())) {
            return this.getXmlRequest(request.getHttpUrl(), params, false);
        }
        if (goodsNum.startsWith(this.gangZhongLvConfig.getVirtualCreditsPre())) {
            params.put("credits", goodsNum.replace(this.gangZhongLvConfig.getVirtualCreditsPre(), ""));
            return this.getAddCreditsRequest(params, this.gangZhongLvConfig.getAddUrl());
        }
        return AssembleTool.assembleRequest(request.getHttpUrl(), request.getAuthParams());
    }

    private Map<String, Object> buildAddCreditsAuthParams(Map<String, String> urlParams, String credits) {
        HashMap params = Maps.newHashMap();
        HashMap authParams = Maps.newHashMap();
        params.put("Member Number", this.getCreditsOrId(urlParams.get("uid"), false));
        params.put("Exchange Channel", "DUBA");
        params.put("Exchange Place", "PointsShop");
        params.put("Exchange Type", "Points Input");
        params.put("Exchange Product Code", this.gangZhongLvConfig.getAddProductNo());
        params.put("Apply Exchange Point", credits);
        params.put("Partner Order Number", urlParams.get("orderNum"));
        params.put("Description", urlParams.get("description"));
        authParams.put("body", params);
        return authParams;
    }

    private HttpRequestBase getXmlRequest(String httpUrl, Map<String, String> params, Boolean isSub) {
        String content = isSub != false ? this.getSubXmlString(params) : this.getVirtualXmlString(params);
        HttpPost request = new HttpPost(httpUrl);
        request.addHeader("Content-Type", "text/xml; charset=UTF-8");
        request.addHeader("SOAPAction", "\"document/http://siebel.com/CustomUI:MPHRedeemService-InterfaceRedeem\"");
        request.setEntity((HttpEntity)new StringEntity(content, "utf-8"));
        return request;
    }

    private String getSubXmlString(Map<String, String> params) {
        return "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:web=\"http://siebel.com/webservices\" xmlns:cus=\"http://siebel.com/CustomUI\" xmlns:mph=\"http://www.siebel.com/xml/MPH%20Member%20Exchange%20IO\">   <soapenv:Header>      <web:SessionToken/>      <web:SessionType>NONE</web:SessionType>      <web:PasswordText>" + this.gangZhongLvConfig.getPassword() + "</web:PasswordText>      <web:UsernameToken>" + this.gangZhongLvConfig.getUsername() + "</web:UsernameToken>   </soapenv:Header>   <soapenv:Body>      <cus:MPHRedeemService-InterfaceRedeem_Input>         <mph:ListOfMphMemberExchangeIo>            <mph:MphMemberExchange>            <mph:ExchangePoints>" + params.get("credits") + "</mph:ExchangePoints>            <mph:ExchangeProductCode>" + this.gangZhongLvConfig.getSubProductNo() + "</mph:ExchangeProductCode>            <mph:ExchangeChannel>DUBA</mph:ExchangeChannel>            <mph:MPHCardNumber>" + params.get("uid") + "</mph:MPHCardNumber>            <mph:ExchangeType>Points deduction</mph:ExchangeType>            <mph:ExchangePlace>PointsShop</mph:ExchangePlace>            <mph:MPHOrderNumber>" + params.get("orderNum") + "</mph:MPHOrderNumber>         </mph:MphMemberExchange>         </mph:ListOfMphMemberExchangeIo>      </cus:MPHRedeemService-InterfaceRedeem_Input>   </soapenv:Body></soapenv:Envelope>";
    }

    private String getVirtualXmlString(Map<String, String> params) {
        return "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:web=\"http://siebel.com/webservices\" xmlns:cus=\"http://siebel.com/CustomUI\" xmlns:mph=\"http://www.siebel.com/xml/MPH%20Member%20Exchange%20IO\">   <soapenv:Header>      <web:SessionToken/>      <web:SessionType>NONE</web:SessionType>      <web:PasswordText>" + this.gangZhongLvConfig.getPassword() + "</web:PasswordText>      <web:UsernameToken>" + this.gangZhongLvConfig.getUsername() + "</web:UsernameToken>   </soapenv:Header>   <soapenv:Body>      <cus:MPHRedeemService-InterfaceRedeem_Input>         <mph:ListOfMphMemberExchangeIo>            <mph:MphMemberExchange>            <mph:ExchangePoints>0</mph:ExchangePoints>            <mph:ExchangeProductCode>" + params.get("params").replace(this.gangZhongLvConfig.getVirtualPre(), "") + "</mph:ExchangeProductCode>            <mph:ExchangeChannel>DUBA</mph:ExchangeChannel>            <mph:MPHCardNumber>" + params.get("uid") + "</mph:MPHCardNumber>            <mph:ExchangeType>Receive Voucher</mph:ExchangeType>            <mph:ExchangePlace>PointsShop</mph:ExchangePlace>            <mph:CouponAmount>0</mph:CouponAmount>            <mph:MPHOrderNumber>" + params.get("orderNum") + "</mph:MPHOrderNumber>            </mph:MphMemberExchange>         </mph:ListOfMphMemberExchangeIo>      </cus:MPHRedeemService-InterfaceRedeem_Input>   </soapenv:Body></soapenv:Envelope>";
    }

    public String parseCreditsRsp(String body, Boolean addCredits, Map<String, String> authParams) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            if (addCredits.booleanValue()) {
                JSONObject bodyJson = JSONObject.parseObject((String)body);
                String items = bodyJson.getString("items");
                HashMap resMap = (HashMap)JSON.parseObject((String)items, HashMap.class);
                String code = (String)resMap.get("Code");
                if ("0".equals(code)) {
                    map.put("status", "ok");
                } else {
                    map.put("status", "fail");
                    map.put("errorMessage", (String)resMap.get("Error Message"));
                }
                map.put("credits", this.getCreditsOrId(authParams.get("uid"), true));
                return JSONObject.toJSONString(map);
            }
            Map out = (Map)((Map)XmlUtil.xmlToMap((String)body).get("SOAP-ENV:Body")).get("ns:MPHRedeemService-InterfaceRedeem_Output");
            String code = (String)out.get("ns:Message_spcCode");
            if ("10".equals(code)) {
                map.put("status", "ok");
                map.put("bizId", (String)out.get("ns:Id"));
            } else {
                map.put("status", "fail");
                map.put("errorMessage", (String)out.get("ns:Message"));
            }
            map.put("credits", this.getCreditsOrId(authParams.get("uid"), true));
        }
        catch (Exception e) {
            LOGGER.error("\u6e2f\u4e2d\u65c5\u9152\u5e97\u65b0\u589e/\u6263\u51cf\u79ef\u5206\u63a5\u53e3\u89e3\u6790\u9519\u8bef:{}--\u662f\u5426\u65b0\u589e:{}", new Object[]{body, addCredits, e});
            map.put("status", "fail");
            map.put("errorMessage", "\u89e3\u6790\u79ef\u5206\u7ed3\u679c\u9519\u8bef");
        }
        return JSONObject.toJSONString(map);
    }

    public String getVirtualResponse(SupplierRequest request, String body) {
        Map<String, String> params = request.getAuthParams();
        String goodsNum = params.get("params");
        String uid = params.get("uid");
        HashMap<String, String> duibaDoc = new HashMap<String, String>();
        try {
            if (goodsNum.startsWith(this.gangZhongLvConfig.getVirtualPre())) {
                Map out = (Map)((Map)XmlUtil.xmlToMap((String)body).get("SOAP-ENV:Body")).get("ns:MPHRedeemService-InterfaceRedeem_Output");
                String code = (String)out.get("ns:Message_spcCode");
                if ("10".equals(code)) {
                    duibaDoc.put("status", "success");
                    duibaDoc.put("supplierBizId", (String)out.get("ns:Id"));
                } else {
                    duibaDoc.put("status", "fail");
                    duibaDoc.put("errorMessage", (String)out.get("ns:Message"));
                }
                duibaDoc.put("credits", this.getCreditsOrId(uid, true));
                return JSON.toJSONString(duibaDoc);
            }
            if (goodsNum.startsWith(this.gangZhongLvConfig.getVirtualCreditsPre())) {
                String addRes = this.parseCreditsRsp(body, true, params);
                HashMap resMap = (HashMap)JSON.parseObject((String)addRes, HashMap.class);
                if ("ok".equals(resMap.get("status"))) {
                    duibaDoc.put("status", "success");
                } else {
                    duibaDoc.put("status", "fail");
                    duibaDoc.put("errorMessage", (String)resMap.get("errorMessage"));
                }
                duibaDoc.put("credits", (String)resMap.get("credits"));
                return JSON.toJSONString(duibaDoc);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u6e2f\u4e2d\u65c5\u9152\u5e97\u4f18\u60e0\u5238\u5151\u6362\u63a5\u53e3\u89e3\u6790\u9519\u8bef:{} \u662f\u5426\u5151\u6362\u4f18\u60e0\u5238:{}", new Object[]{body, goodsNum.startsWith(this.gangZhongLvConfig.getVirtualPre()), e});
            duibaDoc.put("status", "fail");
            duibaDoc.put("errorMessage", "\u79ef\u5206\u5151\u6362\u54cd\u5e94\u89e3\u6790\u9519\u8bef");
            return JSON.toJSONString(duibaDoc);
        }
        return body;
    }

    private String getCreditsOrId(String cardNum, Boolean isCredits) {
        String creditsOrId = null;
        try {
            HttpRequest post = HttpUtil.createPost((String)this.gangZhongLvConfig.getCreditsSelectUrl());
            HashMap<String, String> header = new HashMap<String, String>();
            header.put("SOAPAction", "\"document/http://siebel.com/CustomUI:MPHMemberPointsQueryServiceQueryPoints\"");
            header.put("Content-Type", "text/xml; charset=UTF-8");
            post.addHeaders(header);
            post.body(this.getSelectParam(cardNum));
            post.timeout(5000);
            String result = post.execute().body();
            Map out = (Map)((Map)XmlUtil.xmlToMap((String)result).get("SOAP-ENV:Body")).get("ns:MPHMemberPointsQueryServiceQueryPoints_Output");
            if ("10".equals(out.get("ns:Message_spcCode"))) {
                creditsOrId = isCredits.booleanValue() ? (String)out.get("ns:MPH_spcHKCTS_spcPoints") : (String)out.get("ns:Member_spcNumber");
            } else {
                LOGGER.error("\u6e2f\u4e2d\u65c5\u5b9a\u5236\u79ef\u5206\u67e5\u8be2\u63a5\u53e3\u8c03\u7528\u5f02\u5e38 params={},error={}", (Object)cardNum, out.get("ns:Message"));
            }
            return creditsOrId;
        }
        catch (Exception e) {
            LOGGER.error("\u6e2f\u4e2d\u65c5\u5b9a\u5236\u79ef\u5206\u67e5\u8be2\u63a5\u53e3\u8c03\u7528\u5f02\u5e38 params={},error={}", (Object)cardNum, (Object)e.getMessage());
            return null;
        }
    }

    private String getSelectParam(String cardNum) {
        return "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:web=\"http://siebel.com/webservices\" xmlns:cus=\"http://siebel.com/CustomUI\">   <soapenv:Header>      <web:SessionToken/>      <web:SessionType>NONE</web:SessionType>      <web:PasswordText>" + this.gangZhongLvConfig.getPassword() + "</web:PasswordText>      <web:UsernameToken>" + this.gangZhongLvConfig.getUsername() + "</web:UsernameToken>   </soapenv:Header>   <soapenv:Body>      <cus:MPHMemberPointsQueryServiceQueryPoints_Input>      <cus:Currency>CNY</cus:Currency>      <cus:MPH_spcCard_spcNumber>" + cardNum + "</cus:MPH_spcCard_spcNumber>      </cus:MPHMemberPointsQueryServiceQueryPoints_Input>   </soapenv:Body></soapenv:Envelope>";
    }
}

