/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.constant.livat.LivatConfig;
import cn.com.duiba.constant.livat.LivatConstant;
import cn.com.duiba.dao.custom.LivatRollbackRecordDAO;
import cn.com.duiba.domain.LivatRollbackRecordDO;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.enums.livat.LivatRollbackRecordStatusEnum;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.HttpUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LivatApi {
    private static final Integer SCORE_EVENT = 2000;
    private static final Logger log = LoggerFactory.getLogger(LivatApi.class);
    private static final Integer SUCCESS_CODE = 1;
    private static final String VIRTUAL_CREDITS_PRE = "HJJF-";
    @Resource
    private LivatConstant livatConstant;
    @Resource(name="httpClient")
    private CloseableHttpClient httpClient;
    @Resource
    private LivatRollbackRecordDAO livatRollbackRecordDAO;
    @Resource(name="httpCallbackExecutorService")
    private ExecutorService httpCallbackExecutorService;

    public boolean isLivat(Long appId) {
        return this.livatConstant.getAppId().contains(appId);
    }

    public HttpRequestBase getSubCreditsHttpRequest(CreditsMessage message, Long appId) {
        String url = message.getHttpUrl();
        String newUrl = url.substring(0, url.indexOf(63));
        String paramsStr = url.substring(url.indexOf(63) + 1);
        Map<String, String> authParams = AssembleTool.getUrlParams(paramsStr);
        LivatConfig livatConfig = this.livatConstant.getConfigParamsMap().get(appId);
        Map<String, String> body = this.getCreditsHttpBody(authParams);
        Map<String, String> headers = this.getHttpRequestHeaders(JSON.toJSONString(body), Long.parseLong(authParams.get("timestamp")), livatConfig);
        HashMap newAuthParams = Maps.newHashMap();
        newAuthParams.putAll(body);
        newAuthParams.putAll(headers);
        message.setHttpType("post");
        message.setHttpUrl(newUrl);
        message.setAuthParams((Map)newAuthParams);
        return this.getHttpPost(message.getHttpUrl(), JSON.toJSONString(body), headers);
    }

    public HttpRequestBase getMqSubCreditsHttpRequest(SubCreditsMsgWrapper message, Long appId) {
        String url = message.getHttpUrl();
        String newUrl = url.substring(0, url.indexOf(63));
        String paramsStr = url.substring(url.indexOf(63) + 1);
        Map<String, String> authParams = AssembleTool.getUrlParams(paramsStr);
        LivatConfig livatConfig = this.livatConstant.getConfigParamsMap().get(appId);
        Map<String, String> body = this.getCreditsHttpBody(authParams);
        Map<String, String> headers = this.getHttpRequestHeaders(JSON.toJSONString(body), Long.parseLong(authParams.get("timestamp")), livatConfig);
        HashMap newAuthParams = Maps.newHashMap();
        newAuthParams.putAll(body);
        newAuthParams.putAll(headers);
        message.getSubCreditsMsg().setHttpType(2);
        message.setHttpUrl(newUrl);
        message.getSubCreditsMsg().setAuthParams((Map)newAuthParams);
        return this.getHttpPost(message.getHttpUrl(), JSON.toJSONString(body), headers);
    }

    public HttpRequestBase getAddCreditsHttpRequest(CreditsMessageDto message, Long appId) {
        String url = message.getHttpUrl();
        String newUrl = url.substring(0, url.indexOf(63));
        String paramsStr = url.substring(url.indexOf(63) + 1);
        Map<String, String> authParams = AssembleTool.getUrlParams(paramsStr);
        LivatConfig livatConfig = this.livatConstant.getConfigParamsMap().get(appId);
        Map<String, String> body = this.getCreditsHttpBody(authParams);
        Map<String, String> headers = this.getHttpRequestHeaders(JSON.toJSONString(body), Long.parseLong(authParams.get("timestamp")), livatConfig);
        HashMap newAuthParams = Maps.newHashMap();
        newAuthParams.putAll(body);
        newAuthParams.putAll(headers);
        message.setHttpType("post");
        message.setHttpUrl(newUrl);
        message.setAuthParams((Map)newAuthParams);
        return this.getHttpPost(message.getHttpUrl(), JSON.toJSONString(body), headers);
    }

    public String parseCreditsResponse(String body, Boolean addCredits, Map<String, String> authParams, Long appId) {
        log.info("livat\u52a0\u51cf\u79ef\u5206response, add={}, body={}", (Object)addCredits, (Object)body);
        JSONObject jsonBody = JSON.parseObject((String)body);
        JSONObject result = new JSONObject();
        if (SUCCESS_CODE.equals(jsonBody.getInteger("Code"))) {
            result.put("status", (Object)"ok");
            result.put("bizId", (Object)(System.currentTimeMillis() + RandomStringUtils.randomNumeric((int)6)));
            result.put("credits", (Object)String.valueOf(this.getCredits(authParams.get("Mobile"), appId)));
            if (!addCredits.booleanValue()) {
                LivatRollbackRecordDO rollbackRecord = new LivatRollbackRecordDO();
                rollbackRecord.setPartnerUserId(authParams.get("Mobile"));
                rollbackRecord.setOrderNum(authParams.get("TransID"));
                rollbackRecord.setRecordStatus(LivatRollbackRecordStatusEnum.NEED_ROLLBACK.getCode());
                rollbackRecord.setCredits(Long.valueOf(authParams.get("Score")));
                rollbackRecord.setAppId(appId);
                this.livatRollbackRecordDAO.insert(rollbackRecord);
            }
        } else {
            result.put("status", (Object)"fail");
            result.put("errorMessage", (Object)jsonBody.getString("Message"));
        }
        return result.toString();
    }

    public void rollbackCredits(NotifyQueueDO notify) {
        this.httpCallbackExecutorService.execute(() -> this.doRollbackCredits(notify));
    }

    private void doRollbackCredits(NotifyQueueDO notify) {
        LivatRollbackRecordDO rollbackRecord = this.livatRollbackRecordDAO.selectByOrderNum(notify.getDuibaOrderNum());
        if (rollbackRecord == null) {
            log.error("livat\u79ef\u5206\u56de\u6eda\u8bb0\u5f55\u4e0d\u5b58\u5728{}", (Object)notify.getDuibaOrderNum());
            return;
        }
        if (LivatRollbackRecordStatusEnum.NEED_NOT_ROLLBACK.getCode().equals(rollbackRecord.getRecordStatus())) {
            log.error("livat\u8be5\u72b6\u6001\u4e0d\u5141\u8bb8\u56de\u6eda\u79ef\u5206{}", (Object)notify.getDuibaOrderNum());
            return;
        }
        try {
            LivatRollbackRecordDO update = new LivatRollbackRecordDO();
            update.setId(rollbackRecord.getId());
            update.setRollbackMessage(notify.getError4developer());
            update.setRecordStatus(LivatRollbackRecordStatusEnum.NEED_ROLLBACK.getCode());
            this.livatRollbackRecordDAO.updateById(update);
            this.addCredits(notify.getPartnerUserId(), rollbackRecord.getCredits(), notify.getDuibaOrderNum() + "-rollback", notify.getAppId());
            update.setRecordStatus(LivatRollbackRecordStatusEnum.ALREADY_ROLLBACK.getCode());
            this.livatRollbackRecordDAO.updateById(update);
        }
        catch (Exception e) {
            log.error("livat\u79ef\u5206\u56de\u6eda\u5931\u8d25{}, detail={}", new Object[]{notify.getDuibaOrderNum(), JSON.toJSONString((Object)notify), e});
            LivatRollbackRecordDO update = new LivatRollbackRecordDO();
            update.setId(rollbackRecord.getId());
            update.setRollbackMessage(notify.getError4developer());
            update.setRecordStatus(LivatRollbackRecordStatusEnum.ROLLBACK_FAIL.getCode());
            this.livatRollbackRecordDAO.updateById(update);
            return;
        }
        log.info("livat\u79ef\u5206\u56de\u6eda\u6210\u529f{}, detail={}", (Object)notify.getDuibaOrderNum(), (Object)JSON.toJSONString((Object)notify));
    }

    public HttpRequestBase getVirtualRequest(SupplierRequest request, Long appId) {
        String url = request.getHttpUrl();
        String newUrl = url.substring(0, url.indexOf(63));
        String paramsStr = url.substring(url.indexOf(63) + 1);
        Map<String, String> authParams = AssembleTool.getUrlParams(paramsStr);
        LivatConfig livatConfig = this.livatConstant.getConfigParamsMap().get(appId);
        String goodsNum = authParams.get("params");
        if (StringUtils.isNotBlank((CharSequence)goodsNum) && goodsNum.startsWith(VIRTUAL_CREDITS_PRE)) {
            if (request.getAuthParams() == null) {
                request.setAuthParams(authParams);
            } else {
                request.getAuthParams().putAll(authParams);
            }
            authParams.put("credits", goodsNum.replace(VIRTUAL_CREDITS_PRE, ""));
            return this.getAddCreditsVirtualRequest(authParams, livatConfig);
        }
        HashMap item = Maps.newHashMap();
        item.put("BussinessID", authParams.get("orderNum"));
        item.put("TraceID", authParams.get("orderNum") + System.currentTimeMillis() + livatConfig.getDeveloperAppId());
        item.put("PICMID", authParams.get("params"));
        item.put("Mobile", authParams.get("uid"));
        JSONArray items = new JSONArray();
        items.add((Object)JSON.parseObject((String)JSON.toJSONString((Object)item)));
        JSONObject body = new JSONObject();
        body.put("UserList", (Object)items);
        Map<String, String> headers = this.getHttpRequestHeaders(body.toJSONString(), Long.parseLong(authParams.get("timestamp")), livatConfig);
        HashMap newAuthParams = Maps.newHashMap();
        newAuthParams.putAll(item);
        newAuthParams.putAll(headers);
        request.setHttpUrl(newUrl);
        request.setAuthParams(newAuthParams);
        return this.getHttpPost(newUrl, body.toJSONString(), headers);
    }

    private HttpRequestBase getAddCreditsVirtualRequest(Map<String, String> authParams, LivatConfig livatConfig) {
        HashMap body = Maps.newHashMap();
        body.put("Mobile", authParams.get("uid"));
        body.put("ScoreEvent", SCORE_EVENT + "");
        body.put("Score", authParams.get("credits"));
        body.put("TransID", authParams.get("orderNum") + System.currentTimeMillis() + livatConfig.getDeveloperAppId());
        HttpRequestBase request = this.getHttpPost(this.livatConstant.getCreditsAddUrl(), JSON.toJSONString((Object)body), this.getHttpRequestHeaders(JSON.toJSONString((Object)body), System.currentTimeMillis(), livatConfig));
        return request;
    }

    public String getVirtualResponse(SupplierRequest request, String body) {
        log.info("livat\u865a\u62df\u5546\u54c1\u5145\u503c\u54cd\u5e94\u7ed3\u679cresponse, body={}", (Object)body);
        Map<String, String> params = request.getAuthParams();
        String goodsNum = "";
        if (params != null) {
            goodsNum = params.get("params");
        }
        if (StringUtils.isNotBlank((CharSequence)goodsNum) && goodsNum.startsWith(VIRTUAL_CREDITS_PRE)) {
            return this.getAddCreditsVirtualResponse(body);
        }
        JSONObject jsonBody = JSON.parseObject((String)body);
        JSONObject result = new JSONObject();
        if (!SUCCESS_CODE.equals(jsonBody.getInteger("Code"))) {
            result.put("status", (Object)"fail");
            result.put("errorMessage", (Object)jsonBody.getString("Message"));
            return result.toString();
        }
        JSONObject jsonData = jsonBody.getJSONArray("Data").getJSONObject(0);
        if (Boolean.FALSE.equals(jsonData.getBoolean("IsSuccess")) || !SUCCESS_CODE.equals(jsonData.getInteger("Code"))) {
            result.put("status", (Object)"fail");
            result.put("errorMessage", (Object)jsonData.getString("FailReason"));
            return result.toString();
        }
        result.put("status", (Object)"success");
        return result.toString();
    }

    private String getAddCreditsVirtualResponse(String body) {
        JSONObject jsonBody = JSON.parseObject((String)body);
        JSONObject duibaDoc = new JSONObject();
        if (!SUCCESS_CODE.equals(jsonBody.getInteger("Code"))) {
            duibaDoc.put("status", (Object)"fail");
            duibaDoc.put("errorMessage", (Object)jsonBody.getString("Message"));
            return duibaDoc.toString();
        }
        duibaDoc.put("status", (Object)"success");
        return duibaDoc.toJSONString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Long getCredits(String uid, Long appId) {
        String datetime = DateTime.now().toString("yyyyMMddHHmmss");
        HashMap body = Maps.newHashMap();
        body.put("Mobile", uid);
        HttpPost request = new HttpPost(this.livatConstant.getVipInfoApiUrl());
        request.setEntity((HttpEntity)new StringEntity(JSON.toJSONString((Object)body), ContentType.APPLICATION_JSON));
        LivatConfig livatConfig = this.livatConstant.getConfigParamsMap().get(appId);
        request.setHeader("AppID", livatConfig.getDeveloperAppId());
        request.setHeader("PublicKey", livatConfig.getDeveloperPublicKey());
        request.setHeader("TimeStamp", datetime);
        request.setHeader("Sign", this.getSign(JSON.toJSONString((Object)body), datetime, livatConfig));
        String response = null;
        HttpUtils.resetTimeOut((HttpRequestBase)request);
        try (CloseableHttpResponse resp = this.httpClient.execute((HttpUriRequest)request);){
            response = EntityUtils.toString((HttpEntity)resp.getEntity());
            JSONObject jsonResult = JSON.parseObject((String)response);
            Integer code = jsonResult.getInteger("Code");
            if (!SUCCESS_CODE.equals(code)) {
                String error = jsonResult.getString("Message");
                log.error("livat\u83b7\u53d6\u4f1a\u5458\u4fe1\u606f\u63a5\u53e3\u8c03\u7528\u5931\u8d25, request={}, params={}, response={}, code={}, msg={}", new Object[]{request, body, response, code, error});
                Long l2 = null;
                return l2;
            }
            Long l = jsonResult.getJSONObject("Data").getLong("Score");
            return l;
        }
        catch (Exception e) {
            log.error("livat\u83b7\u53d6\u4f1a\u5458\u4fe1\u606f\u63a5\u53e3\u8c03\u7528\u5931\u8d25, request={}, params={}, response={}", new Object[]{request, body, response, e});
            return null;
        }
    }

    private void addCredits(String uid, Long credits, String orderNum, Long appId) {
        HashMap body = Maps.newHashMap();
        body.put("Mobile", uid);
        body.put("ScoreEvent", SCORE_EVENT + "");
        body.put("Score", String.valueOf(credits));
        body.put("TransID", orderNum);
        LivatConfig livatConfig = this.livatConstant.getConfigParamsMap().get(appId);
        HttpRequestBase request = this.getHttpPost(this.livatConstant.getCreditsAddUrl(), JSON.toJSONString((Object)body), this.getHttpRequestHeaders(JSON.toJSONString((Object)body), System.currentTimeMillis(), livatConfig));
        String response = null;
        HttpUtils.resetTimeOut(request);
        try (CloseableHttpResponse resp = this.httpClient.execute((HttpUriRequest)request);){
            response = EntityUtils.toString((HttpEntity)resp.getEntity());
            JSONObject jsonResult = JSON.parseObject((String)response);
            Integer code = jsonResult.getInteger("Code");
            if (!SUCCESS_CODE.equals(code)) {
                String error = jsonResult.getString("Message");
                log.error("livat\u52a0\u79ef\u5206\u63a5\u53e3\u8c03\u7528\u5931\u8d25, request={}, response={}, code={}, msg={}", new Object[]{request, response, code, error});
            }
        }
        catch (Exception e) {
            log.error("livat\u52a0\u79ef\u5206\u63a5\u53e3\u8c03\u7528\u5931\u8d25, request={}, response={}", new Object[]{request, response, e});
        }
    }

    private HttpRequestBase getHttpPost(String httpUrl, String jsonBody, Map<String, String> headers) {
        HttpPost request = new HttpPost(httpUrl);
        request.setEntity((HttpEntity)new StringEntity(jsonBody, ContentType.APPLICATION_JSON));
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            request.setHeader(entry.getKey(), entry.getValue());
        }
        return request;
    }

    private Map<String, String> getHttpRequestHeaders(String jsonBody, long timestamp, LivatConfig livatConfig) {
        String datetime = new DateTime(timestamp).toString("yyyyMMddHHmmss");
        HashMap headers = Maps.newHashMap();
        headers.put("AppID", livatConfig.getDeveloperAppId());
        headers.put("PublicKey", livatConfig.getDeveloperPublicKey());
        headers.put("TimeStamp", datetime);
        headers.put("Sign", this.getSign(jsonBody, datetime, livatConfig));
        return headers;
    }

    private Map<String, String> getCreditsHttpBody(Map<String, String> authParams) {
        HashMap map = Maps.newHashMap();
        map.put("Mobile", authParams.get("uid"));
        map.put("ScoreEvent", SCORE_EVENT + "");
        map.put("Score", authParams.get("credits"));
        try {
            map.put("Reason", URLEncoder.encode(authParams.get("description"), StandardCharsets.UTF_8.name()));
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        map.put("TransID", authParams.get("orderNum"));
        return map;
    }

    private String getSign(String jsonParams, String datetime, LivatConfig livatConfig) {
        String encryptString = "{publicKey:" + livatConfig.getDeveloperPublicKey() + ",timeStamp:" + datetime + ",data:" + jsonParams + ",privateKey:" + livatConfig.getDeveloperPrivateKey() + "}";
        return DigestUtils.md5Hex((String)encryptString).substring(8, 24).toUpperCase();
    }
}

