/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.api.enums.subcredits.SubCreditsType;
import cn.com.duiba.constant.MingYuJiuDianConfig;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.wolf.utils.UUIDUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.greencloud.guardian.sdk.Client;
import com.greencloud.guardian.sdk.Request;
import com.greencloud.guardian.sdk.Response;
import com.greencloud.guardian.sdk.enums.Method;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MingYuJiuDianApi {
    private static final Logger logger = LoggerFactory.getLogger(MingYuJiuDianApi.class);
    private static final String PROMOTIONTAG = "DUIBA";
    private static final String REMARK = "\u5151\u5427\u79ef\u5206\u8bb0\u5f55DUIBA_POINT";
    private static final String CARD_POINT_USE_DTO = "cardPointUse";
    private static final List<String> CUSTOM_HEADERS_TO_SIGN_PREFIX = new ArrayList<String>();
    @Autowired
    private MingYuJiuDianConfig mingYuJiuDianConfig;
    @Resource(name="httpClient")
    private CloseableHttpClient httpClient;

    public boolean isAppId(Long appId) {
        return this.mingYuJiuDianConfig.getAppIds().contains(appId);
    }

    public HttpRequestBase getMqSubCreditsHttpRequest(SubCreditsMsgWrapper message) {
        String orderNum = message.getSubCreditsMsg().getCreditConsumeParams().getOrderNum();
        HashMap<String, String> newParams = new HashMap<String, String>(8);
        String sessionId = this.mingYuJiuDianConfig.getSessionId(this.httpClient);
        Long credits = message.getSubCreditsMsg().getCreditConsumeParams().getCredits();
        String memberId = (String)message.getSubCreditsMsg().getAuthParams().get("uid");
        String crsNo = message.getSubCreditsMsg().getRelationId();
        SubCreditsType relationType = message.getSubCreditsMsg().getRelationType();
        newParams.put("sessionId", sessionId);
        newParams.put("point", credits.toString());
        newParams.put("memberId", memberId);
        newParams.put("promotionTag", PROMOTIONTAG);
        newParams.put("crsNo", relationType == SubCreditsType.MALL ? orderNum : crsNo);
        newParams.put("remark", REMARK);
        HttpPost httpPost = new HttpPost(this.mingYuJiuDianConfig.getSubCreditsUrl());
        httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");
        httpPost.setHeader("User-Agent", "Apache-HttpClient/4.1.1(java 1.5)");
        httpPost.setHeader("Connection", "Keep-Alive");
        ArrayList<BasicNameValuePair> pairList = new ArrayList<BasicNameValuePair>();
        BasicNameValuePair sessionIdPair = new BasicNameValuePair("sessionId", sessionId);
        BasicNameValuePair pointPair = new BasicNameValuePair("point", credits.toString());
        BasicNameValuePair cardIdPair = new BasicNameValuePair("memberId", memberId);
        BasicNameValuePair promotionTagPair = new BasicNameValuePair("promotionTag", PROMOTIONTAG);
        BasicNameValuePair remarkPair = new BasicNameValuePair("remark", REMARK);
        BasicNameValuePair crsNoPair = new BasicNameValuePair("crsNo", relationType == SubCreditsType.MALL ? orderNum : crsNo);
        BasicNameValuePair signPair = new BasicNameValuePair("sign", this.mingYuJiuDianConfig.getSign(newParams));
        BasicNameValuePair hotelGroupIdPair = new BasicNameValuePair("hotelGroupId", this.mingYuJiuDianConfig.getHotelGroupId());
        BasicNameValuePair appKeyPair = new BasicNameValuePair("appKey", this.mingYuJiuDianConfig.getLvYunAppKey());
        pairList.add(sessionIdPair);
        pairList.add(pointPair);
        pairList.add(cardIdPair);
        pairList.add(promotionTagPair);
        pairList.add(remarkPair);
        pairList.add(crsNoPair);
        pairList.add(signPair);
        pairList.add(hotelGroupIdPair);
        pairList.add(appKeyPair);
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairList, Charset.forName("UTF-8")));
        return httpPost;
    }

    public String getResponseCredits(String body, Long appId, Boolean addCredits, Map<String, String> authParams) {
        String orderNum = authParams.get("orderNum");
        logger.info("MingYuJiuDian getResponseCredits,body:{},orderNum={}", (Object)body, (Object)orderNum);
        JSONObject jsonObject = JSONObject.parseObject((String)body);
        if (jsonObject == null || jsonObject.getInteger("resultCode") != 0) {
            logger.warn("MingYuJiuDian sub credits error,body:{},orderNum={}", (Object)body, (Object)orderNum);
            return body;
        }
        HashMap<String, String> param = new HashMap<String, String>();
        if (addCredits.booleanValue()) {
            Long pointPayId = jsonObject.getLong("pointPayId");
            if (pointPayId == null) {
                logger.warn("MingYuJiuDian add credits error,pointPayId is null,body:{},orderNum={}", (Object)body, (Object)orderNum);
                return body;
            }
            param.put("bizId", pointPayId.toString());
        } else {
            JSONArray resultJSONArray = jsonObject.getJSONArray("result");
            if (resultJSONArray == null || resultJSONArray.size() == 0) {
                logger.warn("MingYuJiuDian sub credits error,pointApplyId is null,body:{},orderNum={}", (Object)body, (Object)orderNum);
                return body;
            }
            logger.info("MingYuJiuDian,cardPointUse,body:{},orderNum={}", (Object)resultJSONArray.toJSONString(), (Object)orderNum);
            JSONObject result = resultJSONArray.getJSONObject(0);
            if (result == null) {
                logger.warn("MingYuJiuDian sub credits error,pointApplyId is null,body:{},orderNum={}", (Object)body, (Object)orderNum);
                return body;
            }
            Integer pointId = result.getInteger("pointId");
            if (pointId == null) {
                logger.warn("MingYuJiuDian sub credits error,pointApplyId is null,body:{},orderNum={}", (Object)body, (Object)orderNum);
                return body;
            }
            param.put("bizId", String.valueOf(pointId));
            JSONObject object = new JSONObject();
            object.put(CARD_POINT_USE_DTO, (Object)resultJSONArray.toJSONString());
            logger.info("MingYuJiuDian,cardPointUse,save,body:{},orderNum={}", (Object)resultJSONArray.toJSONString(), (Object)orderNum);
            param.put("extraInfo", object.toJSONString());
        }
        param.put("status", "ok");
        try {
            String uid = authParams.get("uid");
            String credits = this.mingYuJiuDianConfig.getCredits(uid, this.httpClient);
            if (!"0".equals(credits)) {
                param.put("credits", String.valueOf(new BigDecimal(credits).longValue()));
            }
        }
        catch (Exception e) {
            logger.warn("get Credits error");
        }
        return JSONObject.toJSONString(param);
    }

    public HttpRequestBase getAddCreditsHttpRequest(CreditsMessageDto message) {
        HashMap<String, String> newParams = new HashMap<String, String>();
        String httpUrl = message.getHttpUrl();
        String paramsStr = httpUrl.substring(httpUrl.indexOf(63) + 1);
        Map<String, String> authParams = AssembleTool.getUrlParams(paramsStr);
        String sessionId = this.mingYuJiuDianConfig.getSessionId(this.httpClient);
        String credits = authParams.get("credits");
        String cardId = (String)message.getParams().get("cardId");
        newParams.put("sessionId", sessionId);
        newParams.put("point", credits);
        newParams.put("cardId", cardId);
        newParams.put("promotionTag", PROMOTIONTAG);
        newParams.put("remark", REMARK);
        HttpPost httpPost = new HttpPost(this.mingYuJiuDianConfig.getAddCreditsUrl());
        httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");
        httpPost.setHeader("User-Agent", "Apache-HttpClient/4.1.1(java 1.5)");
        httpPost.setHeader("Connection", "Keep-Alive");
        ArrayList<BasicNameValuePair> pairList = new ArrayList<BasicNameValuePair>();
        BasicNameValuePair sessionIdPair = new BasicNameValuePair("sessionId", sessionId);
        BasicNameValuePair pointPair = new BasicNameValuePair("point", credits);
        BasicNameValuePair cardIdPair = new BasicNameValuePair("cardId", cardId);
        BasicNameValuePair promotionTagPair = new BasicNameValuePair("promotionTag", PROMOTIONTAG);
        BasicNameValuePair signPair = new BasicNameValuePair("sign", this.mingYuJiuDianConfig.getSign(newParams));
        BasicNameValuePair hotelGroupIdPair = new BasicNameValuePair("hotelGroupId", this.mingYuJiuDianConfig.getHotelGroupId());
        BasicNameValuePair appKeyPair = new BasicNameValuePair("appKey", this.mingYuJiuDianConfig.getLvYunAppKey());
        BasicNameValuePair remarkPair = new BasicNameValuePair("remark", REMARK);
        pairList.add(sessionIdPair);
        pairList.add(pointPair);
        pairList.add(cardIdPair);
        pairList.add(promotionTagPair);
        pairList.add(signPair);
        pairList.add(hotelGroupIdPair);
        pairList.add(appKeyPair);
        pairList.add(remarkPair);
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairList, Charset.forName("UTF-8")));
        return httpPost;
    }

    public HttpRequestBase getVirtualRequest(SupplierRequest message) {
        String url = message.getHttpUrl();
        String authParams = url.substring(url.indexOf(63) + 1);
        Map<String, String> authParamMap = AssembleTool.getUrlParams(authParams);
        String goodsNum = authParamMap.get("params");
        if (StringUtils.isNotBlank((CharSequence)goodsNum)) {
            if (goodsNum.startsWith(this.mingYuJiuDianConfig.getCoupons1())) {
                return this.getCoupons1VirtualRequest(message, authParamMap);
            }
            if (goodsNum.startsWith(this.mingYuJiuDianConfig.getCoupons2())) {
                return this.getCoupons2VirtualRequest(message, authParamMap);
            }
            if (goodsNum.startsWith(this.mingYuJiuDianConfig.getCredits())) {
                return this.getCreditsVirtualRequest(message, authParamMap);
            }
        }
        return new HttpGet(url);
    }

    private HttpRequestBase getCreditsVirtualRequest(SupplierRequest message, Map<String, String> authParamMap) {
        String url = message.getHttpUrl();
        String newUrl = url.substring(0, url.indexOf(63));
        String paramsStr = url.substring(url.indexOf(63) + 1);
        String goodsNum = authParamMap.get("params");
        String creditsStr = goodsNum.replaceFirst(this.mingYuJiuDianConfig.getCredits(), "");
        long credits = Long.parseLong(creditsStr);
        logger.info("\u660e\u5b87\u9152\u5e97,\u865a\u62df\u5546\u54c1\u5145\u503c,\u52a0\u79ef\u5206,orderId-={},goodsNum={}", (Object)message.getOrderId(), (Object)goodsNum);
        CreditsMessageDto creditsMessageDto = new CreditsMessageDto();
        HashMap<String, String> authParams = new HashMap<String, String>();
        authParams.put("credits", String.valueOf(credits));
        creditsMessageDto.setHttpUrl(AssembleTool.assembleUrl(newUrl, authParams));
        creditsMessageDto.setParams(message.getParams());
        return this.getAddCreditsHttpRequest(creditsMessageDto);
    }

    private HttpRequestBase getCoupons1VirtualRequest(SupplierRequest message, Map<String, String> authParamMap) {
        String goodsNum = authParamMap.get("params").replace(this.mingYuJiuDianConfig.getCoupons1(), "");
        String sessionId = this.mingYuJiuDianConfig.getSessionId(this.httpClient);
        String cardId = message.getParams().get("cardId");
        String cardNo = message.getParams().get("cardNo");
        HashMap<String, String> newParams = new HashMap<String, String>();
        newParams.put("sessionId", sessionId);
        newParams.put("cardId", cardId);
        newParams.put("couponPackCode", goodsNum);
        newParams.put("remark", REMARK);
        newParams.put("cardNo", cardNo);
        HttpPost httpPost = new HttpPost(this.mingYuJiuDianConfig.getCoupons1Url());
        httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");
        httpPost.setHeader("User-Agent", "Apache-HttpClient/4.1.1(java 1.5)");
        httpPost.setHeader("Connection", "Keep-Alive");
        ArrayList<BasicNameValuePair> pairList = new ArrayList<BasicNameValuePair>();
        BasicNameValuePair sessionIdPair = new BasicNameValuePair("sessionId", sessionId);
        BasicNameValuePair cardIdPair = new BasicNameValuePair("cardId", cardId);
        BasicNameValuePair couponPackCodePair = new BasicNameValuePair("couponPackCode", goodsNum);
        BasicNameValuePair signPair = new BasicNameValuePair("sign", this.mingYuJiuDianConfig.getSign(newParams));
        BasicNameValuePair hotelGroupIdPair = new BasicNameValuePair("hotelGroupId", this.mingYuJiuDianConfig.getHotelGroupId());
        BasicNameValuePair appKeyPair = new BasicNameValuePair("appKey", this.mingYuJiuDianConfig.getLvYunAppKey());
        BasicNameValuePair remarkPair = new BasicNameValuePair("remark", REMARK);
        BasicNameValuePair cardNoPair = new BasicNameValuePair("cardNo", cardNo);
        pairList.add(sessionIdPair);
        pairList.add(cardIdPair);
        pairList.add(couponPackCodePair);
        pairList.add(signPair);
        pairList.add(hotelGroupIdPair);
        pairList.add(appKeyPair);
        pairList.add(remarkPair);
        pairList.add(cardNoPair);
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairList, Charset.forName("UTF-8")));
        return httpPost;
    }

    private HttpRequestBase getCoupons2VirtualRequest(SupplierRequest message, Map<String, String> authParamMap) {
        HashMap<String, String> newParams = new HashMap<String, String>();
        String goodsNum = authParamMap.get("params").replace(this.mingYuJiuDianConfig.getCoupons2(), "");
        String sessionId = this.mingYuJiuDianConfig.getSessionId(this.httpClient);
        String memberId = authParamMap.get("uid");
        newParams.put("sessionId", sessionId);
        newParams.put("couponCode", goodsNum);
        newParams.put("remark", REMARK);
        newParams.put("number", "1");
        newParams.put("memberId", memberId);
        HttpPost httpPost = new HttpPost(this.mingYuJiuDianConfig.getCoupons2Url());
        httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");
        httpPost.setHeader("User-Agent", "Apache-HttpClient/4.1.1(java 1.5)");
        httpPost.setHeader("Connection", "Keep-Alive");
        ArrayList<BasicNameValuePair> pairList = new ArrayList<BasicNameValuePair>();
        BasicNameValuePair sessionIdPair = new BasicNameValuePair("sessionId", sessionId);
        BasicNameValuePair couponPackCodePair = new BasicNameValuePair("couponCode", goodsNum);
        BasicNameValuePair signPair = new BasicNameValuePair("sign", this.mingYuJiuDianConfig.getSign(newParams));
        BasicNameValuePair hotelGroupIdPair = new BasicNameValuePair("hotelGroupId", this.mingYuJiuDianConfig.getHotelGroupId());
        BasicNameValuePair appKeyPair = new BasicNameValuePair("appKey", this.mingYuJiuDianConfig.getLvYunAppKey());
        BasicNameValuePair remarkPair = new BasicNameValuePair("remark", REMARK);
        BasicNameValuePair numberPair = new BasicNameValuePair("number", "1");
        BasicNameValuePair memberIdPair = new BasicNameValuePair("memberId", memberId);
        pairList.add(sessionIdPair);
        pairList.add(couponPackCodePair);
        pairList.add(signPair);
        pairList.add(hotelGroupIdPair);
        pairList.add(appKeyPair);
        pairList.add(remarkPair);
        pairList.add(numberPair);
        pairList.add(memberIdPair);
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairList, Charset.forName("UTF-8")));
        return httpPost;
    }

    public String getVirtualResponse(SupplierRequest message, String body) {
        JSONObject jsonObject = JSONObject.parseObject((String)body);
        Integer resultCode = jsonObject.getInteger("resultCode");
        HashMap<String, String> param = new HashMap<String, String>();
        if (resultCode != null && 0 == resultCode) {
            String url = message.getHttpUrl();
            String authParams = url.substring(url.indexOf(63) + 1);
            Map<String, String> authParamMap = AssembleTool.getUrlParams(authParams);
            String uid = authParamMap.get("uid");
            String credits = this.mingYuJiuDianConfig.getCredits(uid, this.httpClient);
            if (!"0".equals(credits)) {
                param.put("credits", String.valueOf(new BigDecimal(credits).longValue()));
            }
            param.put("status", "success");
        } else {
            param.put("status", "fail");
            param.put("errorMessage", jsonObject.getString("resultMsg"));
        }
        param.put("supplierBizId", UUIDUtils.createUUID());
        return JSON.toJSONString(param);
    }

    public String getUserInfo(String token) {
        JSONObject ret;
        String msg2;
        Response response;
        HashMap headers = new HashMap();
        CUSTOM_HEADERS_TO_SIGN_PREFIX.clear();
        Request request = new Request(Method.GET, "https://" + this.mingYuJiuDianConfig.getMingyuHost(), this.mingYuJiuDianConfig.getMingyuApiAddress() + this.mingYuJiuDianConfig.getQueryUserInfoPath(), this.mingYuJiuDianConfig.getAppKey(), this.mingYuJiuDianConfig.getAppSecret(), 3000);
        request.setHeaders(headers);
        request.setSignHeaderPrefixList(CUSTOM_HEADERS_TO_SIGN_PREFIX);
        HashMap<String, String> querys = new HashMap<String, String>();
        querys.put("token", token);
        querys.put("appid", this.mingYuJiuDianConfig.getMingyuWxAppId());
        request.setQuerys(querys);
        try {
            response = Client.execute((Request)request);
        }
        catch (Exception e) {
            logger.warn("\u660e\u5b87\u9152\u5e97\u63a5\u53e3\u8bf7\u6c42\u5f02\u5e38,token={}", (Object)token, (Object)e);
            return null;
        }
        logger.info("\u660e\u5b87\u9152\u5e97\u63a5\u53e3\u8fd4\u56de,msg:{}", (Object)JSON.toJSONString((Object)response));
        if (response.getStatusCode() == 200 && StringUtils.isBlank((CharSequence)(msg2 = (ret = JSON.parseObject((String)response.getBody())).getString("msg")))) {
            return ret.getString("retVal");
        }
        return null;
    }
}

