/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.constant.RenrenTvConfig;
import cn.com.duiba.credits.sdk.CreditNotifyParams;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.JsonTool;
import cn.com.duiba.vo.RenrenTvResultVO;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RenrenTvApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(RenrenTvApi.class);
    @Autowired
    private RenrenTvConfig renrenTvConfig;
    private static final String SUCCESS_CODE = "0000";
    private static final String HAS_CONFIRMED_CODE = "8644";
    private static final String VIRTUAL_ORDER_NUM_PREFIX = "virtual_";

    public boolean isRenrenTv(Long appId) {
        return appId != null && appId.equals(this.renrenTvConfig.getAppId());
    }

    public CreditsMessage getSubCreditsMessage(CreditsMessage request) {
        request.setHttpType("post");
        String httpUrl = request.getHttpUrl();
        int index = httpUrl.indexOf(63);
        if (index <= 0) {
            throw new IllegalArgumentException("httpUrl:" + httpUrl);
        }
        String postUrl = httpUrl.substring(0, index);
        request.setHttpUrl(postUrl);
        String paramStr = httpUrl.substring(index + 1, httpUrl.length());
        Map<String, String> urlParams = AssembleTool.getUrlParams(paramStr);
        Map<String, String> authParams = this.buildAddOrSubCreditsAuthParams(urlParams, false);
        request.setAuthParams(authParams);
        return request;
    }

    public SubCreditsMsgWrapper getRequestCredits(SubCreditsMsgWrapper request) {
        request.getSubCreditsMsg().setHttpType(2);
        String httpUrl = request.getHttpUrl();
        int index = httpUrl.indexOf(63);
        if (index <= 0) {
            throw new IllegalArgumentException("httpUrl:" + httpUrl);
        }
        String postUrl = httpUrl.substring(0, index);
        request.setHttpUrl(postUrl);
        Map<String, String> authParams = this.buildAddOrSubCreditsAuthParams(request.getSubCreditsMsg().getAuthParams(), false);
        request.getSubCreditsMsg().setAuthParams(authParams);
        return request;
    }

    public CreditsMessageDto getAddCreditsMessage(CreditsMessageDto request) {
        request.setHttpType("post");
        String httpUrl = request.getHttpUrl();
        int index = httpUrl.indexOf(63);
        if (index <= 0) {
            throw new IllegalArgumentException("httpUrl:" + httpUrl);
        }
        String postUrl = httpUrl.substring(0, index);
        request.setHttpUrl(postUrl);
        String paramStr = httpUrl.substring(index + 1, httpUrl.length());
        Map<String, String> urlParams = AssembleTool.getUrlParams(paramStr);
        Map<String, String> authParams = this.buildAddOrSubCreditsAuthParams(urlParams, true);
        request.setAuthParams(authParams);
        return request;
    }

    private Map<String, String> buildAddOrSubCreditsAuthParams(Map<String, String> urlParams, boolean addFlag) {
        HashMap authParams = Maps.newHashMap();
        authParams.put("token", urlParams.get("transfer"));
        authParams.put("orderCode", urlParams.get("orderNum"));
        authParams.put("time", String.valueOf(System.currentTimeMillis()));
        authParams.put("amounts", (addFlag ? "" : "-") + urlParams.get("credits"));
        authParams.put("description", urlParams.get("description"));
        authParams.put("orderNum", urlParams.get("orderNum"));
        authParams.put("credits", urlParams.get("credits"));
        authParams.put("type", urlParams.get("type"));
        return authParams;
    }

    public String parseCreditsRsp(String body) {
        try {
            RenrenTvResultVO resultVO = (RenrenTvResultVO)JSONObject.parseObject((String)body, (TypeReference)new TypeReference<RenrenTvResultVO<Long>>(){}, (Feature[])new Feature[0]);
            HashMap duibaDoc = Maps.newHashMap();
            duibaDoc.put("status", "fail");
            duibaDoc.put("errorMessage", null);
            duibaDoc.put("bizId", null);
            duibaDoc.put("credits", null);
            if (resultVO != null) {
                if (SUCCESS_CODE.equals(resultVO.getCode())) {
                    duibaDoc.put("status", "ok");
                }
                duibaDoc.put("errorMessage", resultVO.getMsg());
                duibaDoc.put("bizId", resultVO.getRequestId());
                duibaDoc.put("credits", resultVO.getData());
            }
            return JsonTool.objectToJson(duibaDoc);
        }
        catch (Exception e) {
            LOGGER.warn("", (Throwable)e);
            return body;
        }
    }

    public HttpRequestBase getRequestNotify(String notifyUrl, CreditNotifyParams params) {
        HashMap authParams = Maps.newHashMap();
        authParams.put("orderCode", params.getOrderNum());
        authParams.put("status", String.valueOf(params.isSuccess()));
        authParams.put("description", params.getErrorMessage());
        HttpPost httpPost = AssembleTool.assembleRequest(notifyUrl, authParams);
        this.setHttpHeader(authParams, (HttpRequestBase)httpPost);
        return httpPost;
    }

    public String getResponseNotify(String body) {
        try {
            RenrenTvResultVO resultVO = (RenrenTvResultVO)JSONObject.parseObject((String)body, (TypeReference)new TypeReference<RenrenTvResultVO<String>>(){}, (Feature[])new Feature[0]);
            if (resultVO != null && (SUCCESS_CODE.equals(resultVO.getCode()) || HAS_CONFIRMED_CODE.equals(resultVO.getCode()))) {
                return "ok";
            }
        }
        catch (Exception e) {
            LOGGER.warn("", (Throwable)e);
        }
        return body;
    }

    public SupplierRequest getVirtualRequest(SupplierRequest request) {
        String httpUrl = request.getHttpUrl();
        int index = httpUrl.indexOf(63);
        if (index <= 0) {
            throw new IllegalArgumentException("httpUrl:" + httpUrl);
        }
        String postUrl = httpUrl.substring(0, index);
        request.setHttpUrl(postUrl);
        String paramStr = httpUrl.substring(index + 1, httpUrl.length());
        Map<String, String> urlParams = AssembleTool.getUrlParams(paramStr);
        Map<String, String> authParams = this.buildVirtualCreditsAuthParams(urlParams);
        request.setAuthParams(authParams);
        return request;
    }

    private Map<String, String> buildVirtualCreditsAuthParams(Map<String, String> urlParams) {
        HashMap authParams = Maps.newHashMap();
        authParams.put("token", urlParams.get("transfer"));
        authParams.put("orderCode", VIRTUAL_ORDER_NUM_PREFIX + urlParams.get("orderNum"));
        authParams.put("time", String.valueOf(System.currentTimeMillis()));
        String credits = this.parseCredits(urlParams.get("params"));
        if (credits == null) {
            throw new IllegalArgumentException("params: " + urlParams.get("params"));
        }
        authParams.put("amounts", credits);
        authParams.put("description", urlParams.get("description"));
        return authParams;
    }

    private String parseCredits(String params) {
        if (StringUtils.isBlank((CharSequence)params) || !params.startsWith(this.renrenTvConfig.getVirtualCreditsPrefix())) {
            return null;
        }
        try {
            return String.valueOf(Long.parseUnsignedLong(params.trim().substring(this.renrenTvConfig.getVirtualCreditsPrefix().length())));
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getVirtualRespone(String body) {
        try {
            RenrenTvResultVO resultVO = (RenrenTvResultVO)JSONObject.parseObject((String)body, (TypeReference)new TypeReference<RenrenTvResultVO<Long>>(){}, (Feature[])new Feature[0]);
            HashMap duibaDoc = Maps.newHashMap();
            duibaDoc.put("status", "fail");
            duibaDoc.put("errorMessage", null);
            duibaDoc.put("supplierBizId", null);
            duibaDoc.put("credits", null);
            if (resultVO != null) {
                if (SUCCESS_CODE.equals(resultVO.getCode())) {
                    duibaDoc.put("status", "success");
                }
                duibaDoc.put("errorMessage", resultVO.getMsg());
                duibaDoc.put("supplierBizId", resultVO.getRequestId());
                duibaDoc.put("credits", resultVO.getData());
            }
            return JsonTool.objectToJson(duibaDoc);
        }
        catch (Exception e) {
            LOGGER.warn("", (Throwable)e);
            return body;
        }
    }

    public HttpRequestBase setVirtualHttpHeader(SupplierRequest message) {
        HttpPost httpPost = AssembleTool.assembleRequest(message.getHttpUrl(), message.getAuthParams());
        this.setHttpHeader(message.getAuthParams(), (HttpRequestBase)httpPost);
        return httpPost;
    }

    public void setHttpHeader(Map<String, String> authParams, HttpRequestBase http) {
        http.setHeader("ak", this.renrenTvConfig.getAk());
        http.setHeader("sign", this.generateSign(new TreeMap<String, String>(authParams)));
    }

    private String generateSign(TreeMap<String, String> params) {
        StringBuilder sb = new StringBuilder();
        if (params != null && params.size() > 0) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                sb.append(entry.getKey()).append("=").append(entry.getValue()).append("&");
            }
        }
        String signTemp = sb.append("sk=").append(this.renrenTvConfig.getSk()).toString();
        return DigestUtils.md5Hex((String)signTemp).toUpperCase();
    }
}

