/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.biz.Exception.ThirdpatyException;
import cn.com.duiba.constant.SpdBankConfig;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.kunshanRCB.Util;
import com.alibaba.fastjson.JSONObject;
import com.spdbccc.SM2Signature;
import com.spdbccc.SM3Digest;
import com.spdbccc.SM4Crypto;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SpdBankApi {
    private static final Logger log = LoggerFactory.getLogger(SpdBankApi.class);
    private static final String LOG_PREFIX = "spdBank:";
    @Autowired
    private SpdBankConfig spdBankConfig;

    public boolean isPdCardApp(Long appId) {
        return null != appId && appId.equals(this.spdBankConfig.getPdCardAppId());
    }

    public HttpRequestBase getPdCardVirtualRequest(SupplierRequest request) {
        String url = request.getHttpUrl();
        log.info("spdBank:url:{}", (Object)url);
        String paramsStr = url.substring(url.indexOf(63) + 1);
        Map<String, String> params = AssembleTool.getUrlParams(paramsStr);
        String orderNum = params.get("orderNum");
        String uid = params.get("uid");
        String prizeNum = params.get("params");
        JSONObject requestParam = new JSONObject();
        requestParam.put("transId", (Object)params.get("orderNum"));
        requestParam.put("channel", (Object)this.spdBankConfig.getChannel());
        requestParam.put("userId", (Object)params.get("uid"));
        requestParam.put("sendCouponChannel", (Object)"YB");
        requestParam.put("ruleCheckFlag", (Object)"0");
        requestParam.put("prizeNum", (Object)prizeNum);
        HttpPost post = new HttpPost(this.spdBankConfig.getApiUrl());
        String reqBody = requestParam.toJSONString();
        log.info("spdBank:uid:{},orderNum:{},prizeNum:{},reqBody:{}", new Object[]{uid, orderNum, prizeNum, reqBody});
        byte[] encrypted = SM4Crypto.encrypt((byte[])reqBody.getBytes(), (String)this.spdBankConfig.getSm4Secret());
        String encryptBody = DatatypeConverter.printBase64Binary((byte[])encrypted);
        log.info("spdBank:uid:{},orderNum:{},prizeNum:{},encryptBody:{}", new Object[]{uid, orderNum, prizeNum, encryptBody});
        String timestamp = SpdBankApi.dateGMT();
        String signStr = timestamp + this.spdBankConfig.getClientId() + encryptBody;
        String digest = SM3Digest.digest((byte[])signStr.getBytes());
        byte[] signByte = SM2Signature.createSign((String)this.spdBankConfig.getHzfPrivateKey(), (String)this.spdBankConfig.getClientId(), (byte[])digest.getBytes());
        String sign = Hex.toHexString((byte[])signByte).toUpperCase();
        post.setHeader("X-SPDBCCC-CLIENTID", this.spdBankConfig.getClientId());
        post.setHeader("X-SPDBCCC-TIMESTAMP", timestamp);
        post.setHeader("X-SPDBCCC-SIGNATURE", sign);
        post.setHeader("Content-Type", "application/json;charset=utf-8");
        post.setHeader("Accept-Type", "json");
        post.setEntity((HttpEntity)new StringEntity(encryptBody, StandardCharsets.UTF_8));
        return post;
    }

    public String getPdCardVirtualResponse(SupplierRequest message, String body, HttpResponse response) {
        String url = message.getHttpUrl();
        log.info("spdBank:url:{}", (Object)url);
        String paramsStr = url.substring(url.indexOf(63) + 1);
        Map<String, String> params = AssembleTool.getUrlParams(paramsStr);
        String orderNum = params.get("orderNum");
        String uid = params.get("uid");
        log.info("spdBank:uid:{},orderNum:{},encrypt body:{}", new Object[]{uid, orderNum, body});
        if (StringUtils.isBlank((CharSequence)body)) {
            throw new ThirdpatyException("spdBank pdCard sendCouponNotice result is blank");
        }
        Header header = response.getFirstHeader("X-SPDBCCC-SIGNATURE");
        if (null == header) {
            throw new ThirdpatyException("spdBank pdCard sendCouponNotice header is null");
        }
        String sign = header.getValue();
        String digest = SM3Digest.digest((byte[])(this.spdBankConfig.getClientId() + body).getBytes());
        boolean verify = SM2Signature.verifySign((String)this.spdBankConfig.getKzxPublicKey(), (String)this.spdBankConfig.getClientId(), (byte[])Util.hexStringToBytes(sign), (byte[])digest.getBytes());
        if (!verify) {
            throw new ThirdpatyException("spdBank pdCard sendCouponNotice verify fail");
        }
        byte[] array = DatatypeConverter.parseBase64Binary((String)body);
        byte[] decrypt = SM4Crypto.decrypt((byte[])array, (String)this.spdBankConfig.getSm4Secret());
        body = new String(decrypt);
        log.info("spdBank:uid:{},orderNum:{},decrypt body:{}", new Object[]{uid, orderNum, body});
        JSONObject result = new JSONObject();
        result.put("supplierBizId", (Object)"");
        try {
            JSONObject resp = JSONObject.parseObject((String)body);
            if ("000000".equals(resp.getString("code"))) {
                JSONObject data = resp.getJSONObject("data");
                if ("1".equals(data.getString("sendStatus"))) {
                    result.put("status", (Object)"success");
                    result.put("credits", (Object)"0");
                } else if ("4".equals(data.getString("sendStatus"))) {
                    result.put("status", (Object)"process");
                    result.put("credits", (Object)"0");
                } else {
                    result.put("status", (Object)"fail");
                    result.put("errorMessage", (Object)SpdBankConfig.ResultMessageEnum.getMessageByCode(data.getString("sendStatus")));
                }
            } else {
                result.put("status", (Object)"fail");
                result.put("errorMessage", (Object)resp.getString("msg"));
            }
        }
        catch (Exception e) {
            log.error("spdBank pdCard result analysis error,body:{}", (Object)body, (Object)e);
            result.put("status", (Object)"fail");
            result.put("errorMessage", (Object)"\u4e09\u65b9\u53d1\u5238\u63a5\u53e3\u54cd\u5e94\u4fe1\u606f\u89e3\u6790\u5f02\u5e38");
        }
        return result.toJSONString();
    }

    public static String dateGMT() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        Date date = new Date();
        return dateFormat.format(date);
    }
}

