/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.biz.Exception.ThirdpatyException;
import cn.com.duiba.biz.credits.UnionCommonApi;
import cn.com.duiba.constant.UnionJiDianConstant;
import cn.com.duiba.constant.UnionPayConstants;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.tool.DES3Tool;
import cn.com.duiba.tool.UnionPayBankUtil;
import cn.com.duiba.vo.union.UnionJiDianConfig;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Pair;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UnionJiDianApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnionJiDianApi.class);
    public static final String LOG_NAME = "\u94f6\u8054\u79ef\u70b9\u865a\u62df\u5546\u54c1";
    @Autowired
    private UnionJiDianConstant unionJiDianConstant;
    @Autowired
    private UnionPayConstants unionPayConstants;
    @Autowired
    private UnionCommonApi unionCommonApi;

    public HttpRequestBase buildUnionJiDianRequest(Map<String, String> authParams, SupplierRequest request, UnionJiDianConfig unionJiDianConfig) {
        String duibaAppId = request.getAppId();
        String unionAppId = unionJiDianConfig.getMiniAppId();
        Pair<String, String> userOpenIdAndMobile = this.unionCommonApi.getUserOpenIdAndMobile(Long.valueOf(request.getConsumerId()), unionAppId);
        String openId = (String)userOpenIdAndMobile.getKey();
        String mobile = (String)userOpenIdAndMobile.getValue();
        if (StringUtils.isBlank((CharSequence)openId) && StringUtils.isBlank((CharSequence)mobile)) {
            LOGGER.error("{}, appId={}, consumerId={}, \u7528\u6237\u53c2\u6570\u7f3a\u5931", new Object[]{LOG_NAME, duibaAppId, request.getConsumerId()});
            throw new RuntimeException("\u7528\u6237\u4fe1\u606f\u53c2\u6570\u7f3a\u5931");
        }
        Pair<String, String> params1 = this.getBusinessTypeAndPoint(authParams.get("params"));
        String jidianNum = (String)params1.getValue();
        boolean sendByOpenId = StringUtils.isBlank((CharSequence)unionJiDianConfig.getSendUserIdType()) || "openId".equals(unionJiDianConfig.getSendUserIdType());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("appId", unionAppId);
        params.put("sysId", unionJiDianConfig.getSysId());
        if (sendByOpenId) {
            params.put("openId", openId);
        } else {
            params.put("mobile", mobile);
        }
        params.put("getSource", unionJiDianConfig.getGetSource());
        params.put("transSeqId", authParams.get("orderNum"));
        params.put("transTs", DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmss"));
        params.put("pointAt", jidianNum);
        params.put("transDigest", unionJiDianConfig.getTransDigest());
        params.put("descCode", unionJiDianConfig.getDescCode());
        params.put("inMode", unionJiDianConfig.getInMode());
        params.put("timestamp", Long.toString(System.currentTimeMillis() / 1000L));
        params.put("nonceStr", UnionPayBankUtil.createNonceStr());
        params.put("signature", UnionPayBankUtil.sign(params, this.unionPayConstants.getSignPrivateKey(unionAppId)));
        LOGGER.info("{},\u8bf7\u6c42\u53c2\u6570, orderId={}, params={}", new Object[]{LOG_NAME, request.getOrderId(), JSON.toJSONString(params)});
        try {
            String symmetricKey = this.unionPayConstants.getSymmetricKey(unionAppId);
            params.put("pointAt", DES3Tool.getEncryptedValue(jidianNum, symmetricKey));
            if (!sendByOpenId) {
                params.put("mobile", DES3Tool.getEncryptedValue(mobile, symmetricKey));
            }
        }
        catch (Exception e) {
            LOGGER.warn("{}, \u94f6\u8054\u79ef\u70b9\u865a\u62df\u5546\u54c1\u52a0\u5bc6\u5931\u8d25, orderId={}", new Object[]{LOG_NAME, request.getOrderId(), e});
            throw new ThirdpatyException("\u94f6\u8054\u79ef\u70b9\u865a\u62df\u5546\u54c1, \u52a0\u5bc6\u5931\u8d25");
        }
        HttpPost post = new HttpPost(this.unionJiDianConstant.getJiDianSendUrl());
        post.setEntity((HttpEntity)new StringEntity(JSON.toJSONString(params), ContentType.APPLICATION_JSON));
        return post;
    }

    public String buildUnionJiDianResponse(SupplierRequest request, String body) {
        if (StringUtils.isBlank((CharSequence)body)) {
            throw new ThirdpatyException("\u94f6\u8054\u79ef\u70b9,\u865a\u62df\u5546\u54c1\u5b9a\u5236,\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
        }
        LOGGER.info("{}, \u94f6\u8054\u79ef\u70b9\u54cd\u5e94\u53c2\u6570, orderId={}, body={}", new Object[]{LOG_NAME, request.getOrderId(), body});
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            JSONObject jsonObject = JSON.parseObject((String)body);
            map.put("status", Objects.equals("00", jsonObject.getString("resp")) ? "success" : "fail");
            map.put("errorMessage", StringEscapeUtils.unescapeHtml4((String)jsonObject.getString("msg")));
        }
        catch (Exception e) {
            LOGGER.error("{}\uff0c\u865a\u62df\u5546\u54c1\u5b9a\u5236\uff0c\u7ed3\u679c\u89e3\u6790\u9519\u8bef:{}", new Object[]{LOG_NAME, body, e});
            map.put("status", "fail");
            map.put("errorMessage", "\u865a\u62df\u5546\u54c1\u5145\u503c\u63a5\u53e3\u54cd\u5e94\u89e3\u6790\u9519\u8bef");
        }
        return JSON.toJSONString(map);
    }

    private Pair<String, String> getBusinessTypeAndPoint(String params) {
        String[] goodsNum = params.split("_");
        if (goodsNum.length < 3) {
            throw new ThirdpatyException("\u94f6\u8054\u79ef\u70b9\u5546\u54c1\u7f16\u7801\u9519\u8bef");
        }
        return Pair.of((Object)goodsNum[1], (Object)goodsNum[2]);
    }

    public UnionJiDianConfig getUnionJiDianGoodsConfig(String goodsParams, String duibaAppId) {
        List unionJiDianConfigs = JSON.parseArray((String)this.unionJiDianConstant.getMiniAppConfigs(), UnionJiDianConfig.class);
        List unionJiDianConfig = unionJiDianConfigs.stream().filter(item -> duibaAppId.equals(item.getAppId())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(unionJiDianConfig)) {
            return null;
        }
        Pair<String, String> businessTypeAndPoint = this.getBusinessTypeAndPoint(goodsParams);
        String businessType = (String)businessTypeAndPoint.getKey();
        UnionJiDianConfig unionBusConfig = unionJiDianConfig.stream().filter(item -> businessType.equals(item.getBusinessType())).findFirst().orElse(null);
        if (unionBusConfig == null) {
            return null;
        }
        return unionBusConfig;
    }
}

