/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.biz.Exception.ThirdpatyException;
import cn.com.duiba.biz.credits.UnionCommonApi;
import cn.com.duiba.constant.UnionPayConstants;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.enums.union.UnionGoodsUserSendType;
import cn.com.duiba.tool.DES3Tool;
import cn.com.duiba.tool.UnionPayBankUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Pair;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UnionLotteryApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnionLotteryApi.class);
    public static final String LOG_NAME = "\u94f6\u8054\u901a\u7528\u76f4\u63a5\u62bd\u5956\u865a\u62df\u5546\u54c1";
    @Autowired
    private UnionPayConstants unionPayConstants;
    @Autowired
    private UnionCommonApi unionCommonApi;

    public Boolean boolUnionLotteryVirtual(String goodsNum) {
        if (goodsNum.startsWith(UnionGoodsUserSendType.LOTTERY_MOBILE.getGoodsPrefix()) || goodsNum.startsWith(UnionGoodsUserSendType.LOTTERY_OPEN_ID.getGoodsPrefix())) {
            return true;
        }
        return false;
    }

    public HttpRequestBase buildLotterySendRequest(String goodsNum, Map<String, String> authParamMap, SupplierRequest request) {
        String[] s = goodsNum.split("_");
        String goodsPrefix = s[0];
        String unionAppId = s[1];
        String activityNo = s[2];
        Pair<String, String> userOpenIdAndMobile = this.unionCommonApi.getUserOpenIdAndMobile(Long.valueOf(request.getConsumerId()), unionAppId);
        String openId = (String)userOpenIdAndMobile.getKey();
        String mobile = (String)userOpenIdAndMobile.getValue();
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put("appId", unionAppId);
        requestParams.put("transSeqId", authParamMap.get("orderNum"));
        requestParams.put("transTs", DateUtil.format((Date)new Date(), (String)"yyyyMMdd"));
        requestParams.put("nonceStr", UnionPayBankUtil.createNonceStr());
        requestParams.put("activityNo", activityNo);
        if (UnionGoodsUserSendType.LOTTERY_OPEN_ID.getGoodsPrefix().equals(goodsPrefix)) {
            requestParams.put("openId", openId);
            requestParams.put("acctEntityTp", UnionGoodsUserSendType.LOTTERY_OPEN_ID.getAcctEntityTp());
        } else if (UnionGoodsUserSendType.LOTTERY_MOBILE.getGoodsPrefix().equals(goodsPrefix)) {
            requestParams.put("mobile", mobile);
            requestParams.put("acctEntityTp", UnionGoodsUserSendType.LOTTERY_MOBILE.getAcctEntityTp());
        }
        requestParams.put("timestamp", Long.toString(System.currentTimeMillis() / 1000L));
        requestParams.put("signature", UnionPayBankUtil.sign(requestParams, this.unionPayConstants.getSignPrivateKey(unionAppId)));
        LOGGER.info("{}, orderId={}, \u8bf7\u6c42\u53c2\u6570={}", new Object[]{LOG_NAME, request.getOrderId(), JSON.toJSONString(requestParams)});
        if (goodsPrefix.equals(UnionGoodsUserSendType.LOTTERY_MOBILE.getGoodsPrefix())) {
            try {
                requestParams.put("mobile", DES3Tool.getEncryptedValue(mobile, this.unionPayConstants.getSymmetricKey(unionAppId)));
            }
            catch (Exception e) {
                LOGGER.warn("{}, \u865a\u62df\u5546\u54c1\u53c2\u6570\u52a0\u5bc6\u5931\u8d25, orderId={}", new Object[]{LOG_NAME, request.getOrderId(), e});
                throw new ThirdpatyException("\u94f6\u8054\u901a\u7528\u76f4\u63a5\u62bd\u5956\u865a\u62df\u5546\u54c1, \u52a0\u5bc6\u5931\u8d25");
            }
        }
        HttpPost post = new HttpPost(this.unionPayConstants.getLotteryVirtualUrl());
        post.setEntity((HttpEntity)new StringEntity(JSON.toJSONString(requestParams), ContentType.APPLICATION_JSON));
        return post;
    }

    public String buildUnionLotteryResponse(SupplierRequest request, String body) {
        if (StringUtils.isBlank((CharSequence)body)) {
            throw new ThirdpatyException("\u94f6\u8054\u76f4\u63a5\u62bd\u5956,\u865a\u62df\u5546\u54c1\u5b9a\u5236,\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
        }
        LOGGER.info("{},\u54cd\u5e94\u53c2\u6570, orderId={}, body={}", new Object[]{LOG_NAME, request.getOrderId(), body});
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            JSONObject jsonObject = JSON.parseObject((String)body);
            map.put("status", Objects.equals("00", jsonObject.getString("resp")) ? "success" : "fail");
            map.put("errorMessage", StringEscapeUtils.unescapeHtml4((String)jsonObject.getString("msg")));
        }
        catch (Exception e) {
            LOGGER.error("{},\u54cd\u5e94\u53c2\u6570\uff0c\u7ed3\u679c\u89e3\u6790\u9519\u8bef:{}", new Object[]{LOG_NAME, body, e});
            map.put("status", "fail");
            map.put("errorMessage", "\u865a\u62df\u5546\u54c1\u5145\u503c\u63a5\u53e3\u54cd\u5e94\u89e3\u6790\u9519\u8bef");
        }
        return JSON.toJSONString(map);
    }
}

