/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits.strategy.Impl;

import cn.com.duiba.biz.credits.strategy.ApiStrategy;
import cn.com.duiba.constant.DisuConfig;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.wolf.cache.AdvancedCacheClient;
import cn.com.duiba.wolf.redis.RedisAtomicClient;
import cn.com.duiba.wolf.redis.RedisLock;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DisuApiStrategy
implements ApiStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(DisuApiStrategy.class);
    private Long appId = null;
    @Autowired
    private DisuConfig disuConfig;
    @Resource(name="redisTemplate")
    private AdvancedCacheClient advancedCacheClient;
    @Resource(name="redisTemplate")
    private RedisAtomicClient redisAtomicClient;
    private static RequestConfig config = RequestConfig.custom().setConnectionRequestTimeout(2000).setConnectTimeout(2000).setSocketTimeout(2000).build();

    @Override
    public HttpRequestBase getMqSubCreditsHttpRequest(SubCreditsMsgWrapper message) {
        Map authParams = message.getSubCreditsMsg().getAuthParams();
        this.appId = message.getSubCreditsMsg().getAppId();
        HttpPost httpPost = new HttpPost(this.disuConfig.getDomain().concat(this.disuConfig.getIntegralChangeUrl()));
        List<NameValuePair> params = this.buildCommonCreditsParams(authParams, this.disuConfig.getSubCreditsType(), this.disuConfig.getSubCreditsChangeType(), this.appId);
        UrlEncodedFormEntity formEntity = null;
        try {
            formEntity = new UrlEncodedFormEntity(params, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            LOG.error("\u5730\u7d20 \u6263\u51cf\u79ef\u5206\u8bf7\u6c42\u9519\u8bef:" + e.getMessage(), (Throwable)e);
            return null;
        }
        formEntity.setContentType("application/x-www-form-urlencoded");
        httpPost.setEntity((HttpEntity)formEntity);
        LOG.info("\u5730\u7d20\u51cf\u79ef\u5206\uff0creq={}", (Object)JSON.toJSONString(params));
        return httpPost;
    }

    private List<NameValuePair> buildCommonCreditsParams(Map<String, String> params, Integer type, Integer changeType, Long appId) {
        ArrayList<NameValuePair> result = new ArrayList<NameValuePair>();
        String token = this.getToken(appId);
        result.add((NameValuePair)new BasicNameValuePair("token", token));
        result.add((NameValuePair)new BasicNameValuePair("entMicroSignal", this.disuConfig.getEntMicroSignal()));
        result.add((NameValuePair)new BasicNameValuePair("unionid", params.get("uid")));
        result.add((NameValuePair)new BasicNameValuePair("factoryCode", this.disuConfig.getFactoryCode()));
        Integer credits = Integer.valueOf(params.get("credits"));
        result.add((NameValuePair)new BasicNameValuePair("integral", credits.toString()));
        result.add((NameValuePair)new BasicNameValuePair("type", type.toString()));
        result.add((NameValuePair)new BasicNameValuePair("changeType", changeType.toString()));
        result.add((NameValuePair)new BasicNameValuePair("remark", "\u62c6\u76f2\u76d2" + appId));
        result.add((NameValuePair)new BasicNameValuePair("integralFlow", params.get("orderNum")));
        return result;
    }

    @Override
    public String parseCreditsRsp(String body, Boolean addCredits, Map<String, String> authParams) {
        if (addCredits.booleanValue()) {
            LOG.info("\u5730\u7d20\u52a0\u79ef\u5206\uff0cresp={}", (Object)body);
        } else {
            LOG.info("\u5730\u7d20\u51cf\u79ef\u5206\uff0cresp={}", (Object)body);
        }
        HashMap map = Maps.newHashMap();
        if (StringUtils.isBlank((CharSequence)body)) {
            map.put("status", "fail");
            map.put("errorMessage", "\u5730\u7d20\u65b0\u589e/\u6263\u51cf\u79ef\u5206\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            return JSON.toJSONString((Object)map);
        }
        try {
            JSONObject jsonObject = JSONObject.parseObject((String)body);
            LOG.info("\u5730\u7d20 \u89e3\u6790\u52a0\u79ef\u5206/\u6263\u79ef\u5206\u7ed3\u679c\uff0cjson={}", (Object)JSON.toJSONString((Object)jsonObject));
            JSONObject integralChange_response = jsonObject.getJSONObject("integralChange_response");
            String result = integralChange_response.getString("result");
            if (StringUtils.equals((CharSequence)result, (CharSequence)"1")) {
                map.put("status", "ok");
                map.put("bizId", authParams.get("orderNum"));
                String credits = integralChange_response.getString("balanceAmount");
                if (StringUtils.isBlank((CharSequence)credits)) {
                    credits = this.getIntegralBalance(authParams.get("uid"));
                }
                LOG.info("\u5730\u7d20 \u7528\u6237\u6700\u65b0\u79ef\u5206 credits={}", (Object)credits);
                map.put("credits", credits);
            } else {
                map.put("status", "fail");
                String errorMsg = integralChange_response.getString("cause");
                if (StringUtils.isBlank((CharSequence)errorMsg)) {
                    errorMsg = "\u79ef\u5206\u4e0d\u8db3";
                }
                map.put("errorMessage", errorMsg);
                LOG.info("\u5730\u7d20 \u65b0\u589e/\u6263\u51cf\u79ef\u5206\u5931\u8d25\uff0cresult={},errorMsg={}", (Object)result, (Object)errorMsg);
            }
        }
        catch (Exception e) {
            LOG.error("\u5730\u7d20 \u65b0\u589e/\u6263\u51cf\u79ef\u5206\u63a5\u53e3\u89e3\u6790\u9519\u8bef:{}--\u662f\u5426\u65b0\u589e:{}", new Object[]{body, addCredits, e});
            map.put("status", "fail");
            map.put("errorMessage", "\u5730\u7d20\u65b0\u589e/\u6263\u51cf\u79ef\u5206\u89e3\u6790\u7ed3\u679c\u9519\u8bef");
        }
        LOG.info("\u5730\u7d20\u52a0\u51cf\u79ef\u5206\u5b9a\u5236\u8fd4\u56de\uff0cmap={}", (Object)JSON.toJSONString((Object)map));
        return JSONObject.toJSONString((Object)map);
    }

    @Override
    public HttpRequestBase getAddCreditsMessageRequest(CreditsMessageDto message) {
        Map authParams = message.getAuthParams();
        this.appId = Long.valueOf(message.getAppId());
        HttpPost httpPost = new HttpPost(this.disuConfig.getDomain().concat(this.disuConfig.getIntegralChangeUrl()));
        List<NameValuePair> params = this.buildCommonCreditsParams(authParams, this.disuConfig.getAddCreditsType(), this.disuConfig.getAddCreditsChangeType(), this.appId);
        UrlEncodedFormEntity formEntity = null;
        try {
            formEntity = new UrlEncodedFormEntity(params, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            LOG.error("\u5730\u7d20 \u52a0\u79ef\u5206\u8bf7\u6c42\u9519\u8bef:" + e.getMessage(), (Throwable)e);
            return null;
        }
        formEntity.setContentType("application/x-www-form-urlencoded");
        httpPost.setEntity((HttpEntity)formEntity);
        LOG.info("\u5730\u7d20 \u52a0\u79ef\u5206\uff0creq={}", (Object)JSON.toJSONString(params));
        return httpPost;
    }

    public String getIntegralBalance(String unionid) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("token", this.getToken(this.appId)));
        params.add((NameValuePair)new BasicNameValuePair("entMicroSignal", this.disuConfig.getEntMicroSignal()));
        params.add((NameValuePair)new BasicNameValuePair("unionid", unionid));
        String url = this.disuConfig.getDomain().concat(this.disuConfig.getIntegralBalanceUrl());
        LOG.info("\u5730\u7d20\uff0c\u67e5\u8be2\u4f1a\u5458\u79ef\u5206\u4f59\u989d,\u8bf7\u6c42url={},\u53c2\u6570params={}\uff0cappId={}", new Object[]{url, JSON.toJSONString(params), this.appId});
        String resp = DisuApiStrategy.doPost(url, params);
        LOG.info("\u5730\u7d20\uff0c\u67e5\u8be2\u4f1a\u5458\u79ef\u5206\u4f59\u989d,\u8fd4\u56de\u7ed3\u679c\uff1a" + resp);
        JSONObject repResponse = JSONObject.parseObject((String)resp);
        JSONObject integralBalance_response = repResponse.getJSONObject("integralBalance_response");
        String result = integralBalance_response.getString("result");
        if (!StringUtils.equals((CharSequence)"14008", (CharSequence)result)) {
            LOG.info("\u5730\u7d20\uff0c\u67e5\u8be2\u4f1a\u5458\u79ef\u5206\u4f59\u989d\u9519\u8bef\uff0cunionId={},result={},cause={}", new Object[]{unionid, result, integralBalance_response.getString("cause")});
            return null;
        }
        JSONObject integralBalance = integralBalance_response.getJSONObject("integralBalance");
        String accumulatPoints = integralBalance.getString("accumulatPoints");
        return accumulatPoints;
    }

    public static String doPost(String url, List<NameValuePair> params) {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpPost httppost = new HttpPost(url);
        try {
            UrlEncodedFormEntity formEntity = new UrlEncodedFormEntity(params, "UTF-8");
            formEntity.setContentType("application/x-www-form-urlencoded");
            httppost.setEntity((HttpEntity)formEntity);
            HttpResponse response = httpClient.execute((HttpUriRequest)httppost);
            return EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (Exception e) {
            LOG.error("\u5730\u7d20 \u8bf7\u6c42\u5931\u8d25:" + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String getToken(Long appId) {
        String token = (String)this.advancedCacheClient.get(DisuApiStrategy.getTokenKey(appId));
        LOG.info("\u5730\u7d20 \u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6token={}", (Object)token);
        if (StringUtils.isBlank((CharSequence)token)) {
            return this.refreshToken(appId);
        }
        return token;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String refreshToken(Long appId) {
        String token = null;
        try (RedisLock lock = this.redisAtomicClient.getLock(DisuApiStrategy.getTokenLock(appId), 5L);){
            if (lock == null) {
                LOG.info("\u5730\u7d20 \u5237\u65b0token\u672a\u83b7\u53d6\u5230\u9501\uff0c\u7b49\u5f85\u4e00\u4f1a\u513f\u518d\u83b7\u53d6token");
                TimeUnit.SECONDS.sleep(5L);
                String string = token = this.getToken(appId);
                return string;
            }
            token = (String)this.advancedCacheClient.get(DisuApiStrategy.getTokenKey(appId));
            if (StringUtils.isNotBlank((CharSequence)token)) {
                String string = token;
                return string;
            }
            JSONObject getToken_response = this.getGetTokenResponse();
            token = getToken_response.getString("token");
            if (!StringUtils.isNotBlank((CharSequence)token)) return token;
            this.advancedCacheClient.set(DisuApiStrategy.getTokenKey(appId), (Object)token, 50, TimeUnit.MINUTES);
            return token;
        }
        catch (Exception e) {
            LOG.warn("\u5730\u7d20 \u5237\u65b0\u7f13\u5b58\u5931\u8d25", (Throwable)e);
        }
        return token;
    }

    private JSONObject getGetTokenResponse() throws Exception {
        String tokenUrl = this.disuConfig.getDomain().concat(this.disuConfig.getTokenUrl()).concat("?appKey=").concat(this.disuConfig.getAppKey()).concat("&appSecret=").concat(this.disuConfig.getAppSecret());
        LOG.info("\u5730\u7d20 tokenUrl:{}", (Object)tokenUrl);
        JSONObject response = JSONObject.parseObject((String)DisuApiStrategy.doGet(tokenUrl));
        LOG.info("\u5730\u7d20 tokenResponse:{}", (Object)JSON.toJSONString((Object)response));
        JSONObject getToken_response = response.getJSONObject("getToken_response");
        return getToken_response;
    }

    public static String doGet(String url) throws Exception {
        CloseableHttpClient httpclient = HttpClients.custom().setDefaultRequestConfig(config).build();
        CloseableHttpResponse response = null;
        try {
            HttpGet httpget = new HttpGet(url);
            response = httpclient.execute((HttpUriRequest)httpget);
            if (response.getStatusLine().getStatusCode() == 200) {
                String string = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                return string;
            }
        }
        catch (Exception e) {
            LOG.error("\u5730\u7d20 httpclient.doGet:{}" + e.getMessage(), (Object)url);
            throw e;
        }
        finally {
            try {
                if (null != response) {
                    response.close();
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    private static String getTokenKey(Long appId) {
        return "disu_token_" + appId;
    }

    private static String getTokenLock(Long appId) {
        return "disu_token_lock_" + appId;
    }
}

