/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits.strategy.Impl;

import cn.com.duiba.biz.Exception.ThirdpatyException;
import cn.com.duiba.biz.credits.strategy.ApiStrategy;
import cn.com.duiba.constant.HzUniteBankConfig;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.hzunitebank.RSAUtils;
import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HzUniteBankApiStrategy
implements ApiStrategy {
    private static final Logger log = LoggerFactory.getLogger(HzUniteBankApiStrategy.class);
    @Autowired
    private HzUniteBankConfig hzUniteBankConfig;

    @Override
    public HttpRequestBase getAddCreditsMessageRequest(CreditsMessageDto message) {
        Map authParams = message.getAuthParams();
        String orderNo = (String)authParams.get("orderNum");
        String time = DateUtils.getSecondStr((Date)new Date());
        String remarks = (String)authParams.get("description");
        String amount = (String)authParams.get("credits");
        String extJson = (String)message.getParams().get("extJson");
        if (StringUtils.isBlank((CharSequence)extJson) || JSON.parseObject((String)extJson).get((Object)"mobileNo") == null) {
            log.warn("\u676d\u5dde\u8054\u5408\u94f6\u884c\u624b\u673a\u53f7\u83b7\u53d6\u5f02\u5e38orderId:{}", (Object)orderNo);
            throw new ThirdpatyException("\u676d\u5dde\u8054\u5408\u94f6\u884c\u624b\u673a\u53f7\u83b7\u53d6\u5f02\u5e38");
        }
        String mobileNo = JSON.parseObject((String)extJson).getString("mobileNo");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("orderNo", orderNo);
        params.put("merchant", this.hzUniteBankConfig.getMerchant());
        params.put("mobileNo", mobileNo);
        params.put("time", time);
        params.put("amount", amount);
        params.put("remarks", remarks);
        StringBuffer b = new StringBuffer();
        b.append("orderNo=").append(orderNo).append("&").append("merchant=").append(this.hzUniteBankConfig.getMerchant()).append("&").append("mobileNo=").append(mobileNo).append("&").append("time=").append(time).append("&").append("amount=").append(amount).append("&").append("remarks=").append(remarks);
        params.put("sign", RSAUtils.sign(this.hzUniteBankConfig.getPrivateKey(), b.toString()));
        log.info("\u676d\u5dde\u8054\u5408\u94f6\u884c\u53c2\u6570:{},", (Object)JSON.toJSONString(params));
        StringEntity stringEntity = new StringEntity(JSON.toJSONString(params), "UTF-8");
        HttpPost post = new HttpPost(message.getHttpUrl());
        post.addHeader("Content-Type", "application/json; charset=UTF-8");
        post.setEntity((HttpEntity)stringEntity);
        return post;
    }

    @Override
    public String parseCreditsRsp(String body, Boolean addCredits, Map<String, String> authParams) {
        if (addCredits.booleanValue()) {
            HashMap<String, String> map = new HashMap<String, String>();
            JSONObject bodyJson = JSONObject.parseObject((String)body);
            String code = bodyJson.getString("code");
            if ("PY0000".equals(code)) {
                map.put("status", "ok");
            } else {
                map.put("status", "fail");
                map.put("errorMessage", bodyJson.getString("msg"));
            }
            return JSONObject.toJSONString(map);
        }
        return body;
    }
}

