/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits.strategy.Impl;

import cn.com.duiba.biz.Exception.ThirdpatyException;
import cn.com.duiba.biz.credits.strategy.ApiStrategy;
import cn.com.duiba.constant.LenovoConfig;
import cn.com.duiba.constant.LenovoMultiConfig;
import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.dao.AppDAO;
import cn.com.duiba.domain.AppDO;
import cn.com.duiba.thirdparty.dto.HttpRequestMessageDto;
import com.alibaba.fastjson.JSON;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LenovoApiStrategy
implements ApiStrategy {
    private static Logger logger = LoggerFactory.getLogger(LenovoApiStrategy.class);
    @Autowired
    private AppDAO appDAO;
    @Autowired
    private LenovoConfig lenovoConfig;
    @Autowired
    private LenovoMultiConfig lenovoMultiConfig;

    @Override
    public boolean isCustomCrecord(HttpRequestMessageDto dto) {
        String orderNum = (String)dto.getHttpParams().get("orderNum");
        return StringUtils.isNotBlank((CharSequence)orderNum);
    }

    @Override
    public HttpRequestBase getCrecordNotify(HttpRequestMessageDto msg2, AppDO app) {
        logger.info("\u8054\u60f3\u5151\u6362\u8bb0\u5f55\u5f00\u59cb appId:{}", (Object)app.getId());
        Map params = msg2.getHttpParams();
        params.put("appKey", app.getAppKey());
        params.put("appSecret", this.appDAO.getAppSecret(app));
        String sign = SignTool.sign((Map)params);
        params.put("sign", sign);
        params.remove("appSecret");
        String url = this.lenovoMultiConfig.getConfigMap().get(app.getId());
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new ThirdpatyException("\u8054\u60f3\u5151\u6362\u8bb0\u5f55\u540c\u6b65url is not config");
        }
        logger.info("\u8054\u60f3\u5151\u6362\u8bb0\u5f55\u8bf7\u6c42\u53c2\u6570 appId:{},url:{},params:{}", new Object[]{app.getId(), url, JSON.toJSONString((Object)params)});
        ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>(params.size());
        for (Map.Entry entry : params.entrySet()) {
            String value = (String)entry.getValue();
            if (value == null) continue;
            pairs.add(new BasicNameValuePair((String)entry.getKey(), value));
        }
        HttpPost post = new HttpPost(url);
        post.setEntity((HttpEntity)new UrlEncodedFormEntity(pairs, StandardCharsets.UTF_8));
        post.addHeader("Content-Type", "application/x-www-form-urlencoded; text/html; charset=utf-8");
        return post;
    }

    @Override
    public String getCrecordResponse(String body) {
        logger.info("\u8054\u60f3\u5b9a\u5236\u540c\u6b65\u5151\u6362\u8bb0\u5f55\u54cd\u5e94, request={}", (Object)body);
        return this.getResponseNotify(body);
    }
}

