/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits.strategy.Impl;

import cn.com.duiba.biz.credits.strategy.ApiStrategy;
import cn.com.duiba.biz.tool.duiba.util.SHA256Util;
import cn.com.duiba.constant.PingAnLifeInsuranceConfig;
import cn.com.duiba.dao.AppDAO;
import cn.com.duiba.domain.AppDO;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.tool.AssembleTool;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PingAnLifeInsuranceStrategy
implements ApiStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(PingAnLifeInsuranceStrategy.class);
    private static final String LOG_PRE = "\u5e73\u5b89\u4eba\u5bff";
    @Autowired
    private PingAnLifeInsuranceConfig pingAnLifeInsuranceConfig;
    @Autowired
    private AppDAO appDAO;

    @Override
    public HttpRequestBase getMqSubCreditsHttpRequest(SubCreditsMsgWrapper message) {
        LOGGER.info("\u5e73\u5b89\u4eba\u5bff\u6263\u79ef\u5206\u9ed8\u8ba4\u8bf7\u6c42message={}", (Object)JSONObject.toJSONString((Object)message));
        String url = message.getHttpUrl();
        String paramsStr = url.substring(url.indexOf(63) + 1);
        Map<String, String> params = AssembleTool.getUrlParams(paramsStr);
        Map authParams = message.getSubCreditsMsg().getAuthParams();
        if (MapUtils.isEmpty((Map)authParams)) {
            authParams = Maps.newHashMap();
        }
        authParams.remove("sign");
        String sign = SHA256Util.sha256Sign((Map)authParams);
        LOGGER.info("\u5e73\u5b89\u4eba\u5bff\u6263\u79ef\u5206\u8bf7\u6c42sha256\u52a0\u5bc6sign={},authParams={}", (Object)sign, (Object)JSONObject.toJSONString((Object)authParams));
        authParams.put("sign", sign);
        params.remove("sign");
        params.put("appSecret", message.getSubCreditsMsg().getAppSecret());
        String newSign = SHA256Util.sha256Sign(params);
        LOGGER.info("\u5e73\u5b89\u4eba\u5bff\u6263\u79ef\u5206\u8bf7\u6c42sha256\u52a0\u5bc6newSign={}\uff0cparams={}", (Object)newSign, (Object)JSONObject.toJSONString(params));
        params.put("sign", newSign);
        params.remove("appSecret");
        String httpUrl = AssembleTool.assembleUrl(message.getSubCreditsMsg().getCreditsConsumeRequestUrl(), params);
        message.setHttpUrl(httpUrl);
        message.getSubCreditsMsg().setAuthParams(authParams);
        return null;
    }

    @Override
    public String parseCreditsRsp(String body, Boolean addCredits, Map<String, String> authParams) {
        LOGGER.info("\u5e73\u5b89\u4eba\u5bff\u6263\u79ef\u5206\u54cd\u5e94body=" + body);
        if (addCredits.booleanValue()) {
            LOGGER.info("{}-\u52a0\u79ef\u5206\u54cd\u5e94\uff0cresp={}", (Object)LOG_PRE, (Object)body);
        } else {
            LOGGER.info("{}-\u51cf\u79ef\u5206\u54cd\u5e94\uff0cresp={}", (Object)LOG_PRE, (Object)body);
        }
        HashMap map = Maps.newHashMap();
        if (StringUtils.isBlank((CharSequence)body)) {
            map.put("status", "fail");
            map.put("errorMessage", "\u5e73\u5b89\u4eba\u5bff\u65b0\u589e/\u6263\u51cf\u79ef\u5206\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            return JSON.toJSONString((Object)map);
        }
        return body;
    }

    @Override
    public HttpRequestBase getRequestNotify(String notifyUrl, NotifyQueueDO record) {
        LOGGER.info("\u5e73\u5b89\u4eba\u5bff\u83b7\u53d6\u5151\u6362\u7ed3\u679c\u901a\u77e5 :{}\uff0curl:{}", (Object)JSON.toJSONString((Object)record), (Object)notifyUrl);
        Map<String, String> map = this.getRequestMap(record);
        HttpGet request = new HttpGet(AssembleTool.assembleUrl(notifyUrl, map));
        return request;
    }

    public Map<String, String> getRequestMap(NotifyQueueDO record) {
        AppDO app = this.appDAO.getAppByCache(record.getAppId());
        if (null == app) {
            throw new IllegalStateException("app info\u4e3a\u7a7a");
        }
        HashMap<String, String> map = new HashMap<String, String>(10);
        map.put("success", record.getResult() + "");
        map.put("errorMessage", record.getError4developer());
        map.put("bizId", record.getDeveloperBizId());
        map.put("appKey", app.getAppKey());
        map.put("timestamp", System.currentTimeMillis() + "");
        map.put("uid", record.getPartnerUserId());
        map.put("orderNum", record.getDuibaOrderNum());
        map.put("appSecret", this.appDAO.getAppSecret(app));
        String sign = SHA256Util.sha256Sign(map);
        LOGGER.info("\u5e73\u5b89\u4eba\u5bff\u901a\u77e5\u8bf7\u6c42sha256\u52a0\u5bc6sign={}\uff0cparams={}", (Object)sign, (Object)JSONObject.toJSONString(map));
        map.remove("appSecret");
        map.put("sign", sign);
        return map;
    }
}

