/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits.strategy.Impl;

import cn.com.duiba.biz.credits.strategy.ApiStrategy;
import cn.com.duiba.config.ZhongYiConfig;
import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.order.center.api.dto.OrdersDto;
import cn.com.duiba.order.center.api.remoteservice.RemoteConsumerOrderSimpleService;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.CreditSignUtil;
import cn.com.duiba.tool.JsonTool;
import cn.com.duiba.vo.zhongyi.ZhongyiDescDetailVO;
import cn.com.duiba.vo.zhongyi.ZhongyiDescriptionVO;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ZhongYiApiStrategy
implements ApiStrategy {
    private static final Logger log = LoggerFactory.getLogger(ZhongYiApiStrategy.class);
    @Resource
    private ZhongYiConfig zhongYiConfig;
    @Autowired
    private RemoteConsumerOrderSimpleService remoteConsumerOrderSimpleService;

    @Override
    public HttpRequestBase getMqSubCreditsHttpRequest(SubCreditsMsgWrapper message) {
        try {
            log.info("\u638c\u4e0a\u4e2d\u610f\u6263\u79ef\u5206\u8bf7\u6c42 :{}", (Object)JSON.toJSONString((Object)message));
            String finalUrl = this.handleDescription(message.getHttpUrl(), message.getSubCreditsMsg().getAppSecret());
            log.info("\u638c\u4e0a\u4e2d\u610f\u6263\u79ef\u5206\u8bf7\u6c42,\u6700\u7ec8url :{}", (Object)finalUrl);
            URIBuilder uriBuilder = new URIBuilder(finalUrl);
            HttpGet httpGet = new HttpGet(uriBuilder.build());
            long timeMillis = System.currentTimeMillis() / 1000L;
            String signature = CreditSignUtil.generateSignature(this.zhongYiConfig.getAccessId(), this.zhongYiConfig.getAccessKey(), timeMillis);
            httpGet.addHeader("x-access-id", this.zhongYiConfig.getAccessId());
            httpGet.addHeader("x-signature", signature);
            httpGet.addHeader("x-request-send-timestamp", String.valueOf(timeMillis));
            httpGet.addHeader("Content-Type", "application/x-www-form-urlencoded");
            log.info("\u638c\u4e0a\u4e2d\u610f AllHeaders: {}", (Object)JSON.toJSONString((Object)httpGet.getAllHeaders()));
            return httpGet;
        }
        catch (Exception e) {
            log.warn("\u638c\u4e0a\u4e2d\u610f getMqSubCreditsHttpRequest", (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    @Override
    public HttpRequestBase getAddCreditsMessageRequest(CreditsMessageDto message) {
        try {
            log.info("\u638c\u4e0a\u4e2d\u610f\u52a0\u79ef\u5206\u8bf7\u6c42 :{}", (Object)JSON.toJSONString((Object)message));
            String httpUrl = message.getHttpUrl();
            URIBuilder uriBuilder = new URIBuilder(httpUrl);
            HttpGet httpGet = new HttpGet(uriBuilder.build());
            long timeMillis = System.currentTimeMillis() / 1000L;
            String signature = CreditSignUtil.generateSignature(this.zhongYiConfig.getAccessId(), this.zhongYiConfig.getAccessKey(), timeMillis);
            httpGet.addHeader("x-access-id", this.zhongYiConfig.getAccessId());
            httpGet.addHeader("x-signature", signature);
            httpGet.addHeader("x-request-send-timestamp", String.valueOf(timeMillis));
            httpGet.addHeader("Content-Type", "application/x-www-form-urlencoded");
            log.info("\u638c\u4e0a\u4e2d\u610f AllHeaders: {}", (Object)JSON.toJSONString((Object)httpGet.getAllHeaders()));
            return httpGet;
        }
        catch (Exception e) {
            log.warn("\u638c\u4e0a\u4e2d\u610f \u6784\u5efa\u52a0\u79ef\u5206\u8bf7\u6c42\u5931\u8d25", (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    @Override
    public HttpRequestBase getVirtualRequest(SupplierRequest request) {
        try {
            log.info("\u638c\u4e0a\u4e2d\u610f\u865a\u62df\u5546\u54c1\u5145\u503c\u8bf7\u6c42 :{}", (Object)JSON.toJSONString((Object)request));
            String httpUrl = request.getHttpUrl();
            URIBuilder uriBuilder = new URIBuilder(httpUrl);
            HttpGet httpGet = new HttpGet(uriBuilder.build());
            long timeMillis = System.currentTimeMillis() / 1000L;
            String signature = CreditSignUtil.generateSignature(this.zhongYiConfig.getAccessId(), this.zhongYiConfig.getAccessKey(), timeMillis);
            httpGet.addHeader("x-access-id", this.zhongYiConfig.getAccessId());
            httpGet.addHeader("x-signature", signature);
            httpGet.addHeader("x-request-send-timestamp", String.valueOf(timeMillis));
            httpGet.addHeader("Content-Type", "application/x-www-form-urlencoded");
            log.info("\u638c\u4e0a\u4e2d\u610f AllHeaders: {}", (Object)JSON.toJSONString((Object)httpGet.getAllHeaders()));
            return httpGet;
        }
        catch (Exception e) {
            log.warn("\u638c\u4e0a\u4e2d\u610f \u6784\u5efa\u865a\u62df\u5546\u54c1\u5145\u503c\u8bf7\u6c42", (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    private String handleDescription(String url, String appSecret) {
        log.info("\u3010\u4e2d\u610f\u3011\uff0cappsecret:{}", (Object)appSecret);
        Map<String, String> urlParams = AssembleTool.getUrlParams(url.substring(url.indexOf("?") + 1));
        String uid = urlParams.get("uid");
        String description = urlParams.get("description");
        Long credits = Long.valueOf(urlParams.get("credits"));
        String orderNum = urlParams.get("orderNum");
        ZhongyiDescDetailVO zhongyiDescDetailVO = new ZhongyiDescDetailVO();
        zhongyiDescDetailVO.setName(description);
        DubboResult ordersDtoResult = this.remoteConsumerOrderSimpleService.findByOrderNum(orderNum);
        OrdersDto ordersDto = null;
        if (ordersDtoResult.isSuccess() && Objects.nonNull(ordersDto = (OrdersDto)ordersDtoResult.getResult())) {
            zhongyiDescDetailVO.setName(ordersDto.getBrief());
        }
        zhongyiDescDetailVO.setAmount(1L);
        zhongyiDescDetailVO.setPrice(credits);
        zhongyiDescDetailVO.setOriginPrice(credits);
        ZhongyiDescriptionVO zhongyiDescriptionVO = new ZhongyiDescriptionVO();
        zhongyiDescriptionVO.setCount(credits);
        zhongyiDescriptionVO.setUserId(uid);
        zhongyiDescriptionVO.setSn(orderNum);
        zhongyiDescriptionVO.setDetail(Lists.newArrayList((Object[])new ZhongyiDescDetailVO[]{zhongyiDescDetailVO}));
        urlParams.put("description", JSON.toJSONString((Object)zhongyiDescriptionVO));
        urlParams.put("appSecret", appSecret);
        urlParams.remove("sign");
        log.info("\u3010\u4e2d\u610f\u3011\uff0c\u9700\u8981\u7b7e\u540d\u7684\u53c2\u6570\u5217\u8868:{}", (Object)urlParams.toString());
        String sign = SignTool.sign(urlParams);
        urlParams.remove("appSecret");
        urlParams.put("sign", sign);
        log.info("\u5904\u7406\u5b8c\u4e4b\u540e\u7684url\u53c2\u6570:{}", (Object)urlParams.toString());
        String finalUrl = AssembleTool.assembleUrl(url.substring(0, url.indexOf("?")), urlParams);
        return finalUrl;
    }

    @Override
    public String parseCreditsRsp(String body, Boolean addCredits, Map<String, String> authParams) {
        HashMap<String, String> duibaDoc = new HashMap<String, String>();
        JSONObject ret = null;
        try {
            ret = JSONObject.parseObject((String)body);
        }
        catch (Exception e) {
            log.warn("\u3010\u4e2d\u610f\u3011\uff0cparseCreditsRsp body \u89e3\u6790\u5931\u8d25:{}", (Object)body);
            duibaDoc.put("status", "fail");
            duibaDoc.put("errorMessage", "json\u89e3\u6790\u5931\u8d25");
            return JsonTool.objectToJson(duibaDoc);
        }
        if (ret != null && ("success".equalsIgnoreCase(ret.getString("status")) || "ok".equalsIgnoreCase(ret.getString("status")))) {
            duibaDoc.put("status", "ok");
            duibaDoc.put("bizId", ret.getString("bizId"));
            duibaDoc.put("credits", ret.getString("credits"));
        } else {
            duibaDoc.put("status", "fail");
            duibaDoc.put("bizId", ret.getString("bizId"));
            duibaDoc.put("errorMessage", ret.getString("errorMessage"));
        }
        return JsonTool.objectToJson(duibaDoc);
    }

    public static void main(String[] args) {
        String url = "www.baidu.com?uid=1&description=aaaaa";
        System.out.println(url.substring(url.indexOf("?") + 1));
        System.out.println(url.substring(0, url.indexOf("?")));
    }
}

