/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.remoteimpl.boc;

import cn.com.duiba.constant.BocConfig;
import cn.com.duiba.credits.sdk.AssembleTool;
import cn.com.duiba.thirdparty.api.boc.RemoteBocService;
import cn.com.duiba.thirdparty.dto.boc.BocTaskDto;
import cn.com.duiba.thirdparty.dto.boc.BocTaskInfoDto;
import cn.com.duiba.thirdparty.dto.boc.BocTaskRequestDto;
import cn.com.duiba.thirdparty.dto.boc.GetWxCardDto;
import cn.com.duiba.thirdparty.dto.boc.UseWxCardDto;
import cn.com.duiba.tool.HttpUtils;
import cn.com.duiba.tool.boc.ConverTool;
import cn.com.duiba.tool.boc.SM3;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.CanAccessInsideNetwork;
import cn.hutool.core.util.HexUtil;
import cn.hutool.crypto.BCUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.asymmetric.KeyType;
import cn.hutool.crypto.asymmetric.SM2;
import cn.hutool.crypto.digest.DigestAlgorithm;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RemoteBocServiceImpl
implements RemoteBocService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteBocServiceImpl.class);
    private static final String LOGGER_PREFIX = "\u798f\u5efa\u4e2d\u884c\u8bf7\u6c42\u63a5\u53e3";
    private static final String CHARACTER_ENCODE = "UTF-8";
    private static final Long SUCCESS_CODE = 200L;
    private static final String TASK_SUCCESS_CODE = "0000";
    @Autowired
    private BocConfig bocConfig;
    @Resource(name="httpClient")
    private CloseableHttpClient httpClient;
    @CanAccessInsideNetwork
    @Resource(name="httpClient")
    private CloseableHttpClient insideNetWorkHttpClient;

    public Boolean queryConsumerRank(String partnerUserId, String month, Long appId) {
        HashMap params = Maps.newHashMap();
        params.put("partnerUserId", partnerUserId);
        params.put("month", month);
        params.put("appId", appId.toString());
        LOGGER.info("\u798f\u5efa\u4e2d\u884c\u8bf7\u6c42\u63a5\u53e3\u6e38\u620f\u5165\u699c,\u5165\u53c2\uff1aURL\uff1a{},params:{}", (Object)this.bocConfig.getQueryRankUrl(), (Object)JSON.toJSONString((Object)params));
        String resp = this.sendGet(this.bocConfig.getQueryRankUrl(), params, true);
        LOGGER.info("\u798f\u5efa\u4e2d\u884c\u8bf7\u6c42\u63a5\u53e3\u6e38\u620f\u5165\u699c,\u8fd4\u56de\u7ed3\u679c\uff1a" + resp);
        JSONObject repResponse = JSONObject.parseObject((String)resp);
        if (Objects.nonNull(repResponse) && repResponse.getBoolean("success").booleanValue()) {
            Integer data = repResponse.getInteger("data");
            return data != null && data >= 1;
        }
        return false;
    }

    public GetWxCardDto getWxCard(String merOrderNo, String userNo, String cardId, String activityId, String activityName) {
        long preTime = System.currentTimeMillis();
        HashMap params = Maps.newHashMap();
        params.put("appkey", this.bocConfig.getWxAppkey());
        params.put("merOrderNo", merOrderNo);
        params.put("cardId", cardId);
        params.put("userNo", userNo);
        params.put("timestamp", String.valueOf(preTime));
        params.put("appsecret", this.bocConfig.getWxAppsecret());
        params.put("activityId", activityId);
        params.put("activityName", activityName);
        String sign = RemoteBocServiceImpl.doSign(params);
        params.put("sign", sign);
        params.remove("appsecret");
        LOGGER.info("{}-\u9886\u53d6\u7acb\u51cf\u91d1\u8bf7\u6c42\uff0c\u53c2\u6570\uff1a{}", (Object)LOGGER_PREFIX, (Object)JSON.toJSONString((Object)params));
        try {
            String res = this.sendGet(this.bocConfig.getGetwxcard(), params, false);
            LOGGER.info("{}-\u9886\u53d6\u7acb\u51cf\u91d1\u6210\u529f,res:{},time:{}", new Object[]{LOGGER_PREFIX, res, System.currentTimeMillis() - preTime});
            GetWxCardDto wxCardDto = (GetWxCardDto)JSON.parseObject((String)res, GetWxCardDto.class);
            if (Objects.nonNull(wxCardDto) && SUCCESS_CODE.equals(wxCardDto.getCode()) && wxCardDto.getSuccess().booleanValue()) {
                return wxCardDto;
            }
            LOGGER.warn("{}-\u9886\u53d6\u7acb\u51cf\u91d1\u5931\u8d25,res:{},time:{}", new Object[]{LOGGER_PREFIX, res, System.currentTimeMillis() - preTime});
        }
        catch (Exception e) {
            LOGGER.warn("{}-\u9886\u53d6\u7acb\u51cf\u91d1\u5f02\u5e38", (Object)LOGGER_PREFIX, (Object)e);
        }
        return null;
    }

    public UseWxCardDto useWxCard(String cardNo, String userNo, String merOrderNo) {
        long preTime = System.currentTimeMillis();
        HashMap params = Maps.newHashMap();
        params.put("appkey", this.bocConfig.getWxAppkey());
        params.put("merOrderNo", merOrderNo);
        params.put("cardNo", cardNo);
        params.put("userNo", userNo);
        params.put("timestamp", String.valueOf(preTime));
        params.put("appsecret", this.bocConfig.getWxAppsecret());
        String sign = RemoteBocServiceImpl.doSign(params);
        params.put("sign", sign);
        params.remove("appsecret");
        LOGGER.info("{}-\u4f7f\u7528\u7acb\u51cf\u91d1\u8bf7\u6c42,\u53c2\u6570\uff1a{}", (Object)LOGGER_PREFIX, (Object)JSON.toJSONString((Object)params));
        try {
            String res = this.sendGet(this.bocConfig.getUsewxcard(), params, false);
            LOGGER.info("{}-\u4f7f\u7528\u7acb\u51cf\u91d1\u6210\u529f,res:{},time:{}", new Object[]{LOGGER_PREFIX, res, System.currentTimeMillis() - preTime});
            UseWxCardDto useWxCardDto = (UseWxCardDto)JSON.parseObject((String)res, UseWxCardDto.class);
            if (Objects.nonNull(useWxCardDto) && SUCCESS_CODE.equals(useWxCardDto.getCode()) && useWxCardDto.getSuccess().booleanValue()) {
                return useWxCardDto;
            }
            LOGGER.warn("{}-\u4f7f\u7528\u7acb\u51cf\u91d1\u5931\u8d25,res:{},time:{}", new Object[]{LOGGER_PREFIX, res, System.currentTimeMillis() - preTime});
        }
        catch (Exception e) {
            LOGGER.warn("{}-\u4f7f\u7528\u7acb\u51cf\u91d1\u5f02\u5e38", (Object)LOGGER_PREFIX, (Object)e);
        }
        return null;
    }

    public List<BocTaskDto> queryTaskInfo(String unionNo, List<BocTaskRequestDto> taskList) {
        long preTime = System.currentTimeMillis();
        HashMap params = Maps.newHashMap();
        params.put("appid", this.bocConfig.getAppId());
        params.put("appsecret", this.bocConfig.getAppSecret());
        params.put("union_no", unionNo);
        params.put("tasklist", taskList);
        params.put("timestamp", String.valueOf(preTime));
        try {
            String decodeBody;
            String jsonStr = JSON.toJSONString((Object)params);
            LOGGER.info("{}-\u4efb\u52a1\u67e5\u8be2\u63a5\u53e3,\u660e\u6587\u53c2\u6570\uff1a{}, union_no:{}", new Object[]{LOGGER_PREFIX, jsonStr, unionNo});
            byte[] dataBytes = jsonStr.getBytes(CHARACTER_ENCODE);
            String encResultData = this.getEncResultData(dataBytes);
            String signatureSign = this.getSignatureSign(dataBytes);
            JSONObject json = new JSONObject();
            json.put("encresult", (Object)encResultData);
            json.put("signdata", (Object)signatureSign);
            LOGGER.info("{}-\u4efb\u52a1\u67e5\u8be2\u63a5\u53e3,\u53c2\u6570\uff1a{}", (Object)LOGGER_PREFIX, (Object)json.toJSONString());
            String res = this.sendPost(this.bocConfig.getUrl() + this.bocConfig.getQueryTaskInfo(), json.toJSONString());
            LOGGER.info("{}-\u4efb\u52a1\u67e5\u8be2\u63a5\u53e3\u6210\u529f,res:{},time:{}", new Object[]{LOGGER_PREFIX, res, System.currentTimeMillis() - preTime});
            JSONObject jsonObject = JSONObject.parseObject((String)res);
            if (jsonObject == null || !TASK_SUCCESS_CODE.equals(jsonObject.getString("msgcde"))) {
                LOGGER.warn("{}-\u4efb\u52a1\u67e5\u8be2\u63a5\u53e3\u5931\u8d25,res:{},time:{}", new Object[]{LOGGER_PREFIX, res, System.currentTimeMillis() - preTime});
                return null;
            }
            String signdata = jsonObject.getString("signdata");
            String encresult = jsonObject.getString("encresult");
            String string = decodeBody = StringUtils.isNotBlank((CharSequence)encresult) ? this.decodeResult(encresult) : null;
            if (StringUtils.isNotBlank((CharSequence)decodeBody) && this.verifyResult(decodeBody, signdata)) {
                LOGGER.info("{}-\u4efb\u52a1\u67e5\u8be2\u63a5\u53e3\u6210\u529f,\u660e\u6587res:{}", (Object)LOGGER_PREFIX, (Object)decodeBody);
                return ((BocTaskInfoDto)JSON.parseObject((String)decodeBody, BocTaskInfoDto.class)).getTaskdata();
            }
            LOGGER.warn("{}-\u4efb\u52a1\u67e5\u8be2\u63a5\u53e3\u5f02\u5e38,\u9a8c\u7b7e\u5931\u8d25,signdata:{},res:{},time:{}", new Object[]{LOGGER_PREFIX, jsonObject.getString("signdata"), res, System.currentTimeMillis() - preTime});
            return null;
        }
        catch (Exception e) {
            LOGGER.warn("{}-\u4efb\u52a1\u67e5\u8be2\u63a5\u53e3\u5f02\u5e38", (Object)LOGGER_PREFIX, (Object)e);
            return null;
        }
    }

    private boolean verifyResult(String decodeBody, String signatureSign) throws IOException {
        String shPublicKey = this.bocConfig.getSHPublicKey();
        if (shPublicKey.length() == 130) {
            shPublicKey = shPublicKey.substring(2);
        }
        String xhex = shPublicKey.substring(0, 64);
        String yhex = shPublicKey.substring(64, 128);
        ECPublicKeyParameters params = BCUtil.toSm2Params((String)xhex, (String)yhex);
        SM2 sm2b = new SM2(null, params);
        sm2b.usePlainEncoding();
        sm2b.setMode(SM2Engine.Mode.C1C2C3);
        String sm2signtext = SM3.byteArrayToHexString(SM3.hash(decodeBody.getBytes(CHARACTER_ENCODE))) + this.bocConfig.getSignInfo();
        byte[] sm2signdataBytes = sm2signtext.getBytes(CHARACTER_ENCODE);
        return sm2b.verify(sm2signdataBytes, HexUtil.decodeHex((String)signatureSign));
    }

    private String decodeResult(String encResultData) throws UnsupportedEncodingException {
        ECPrivateKeyParameters ecPrivateKeyParameters = BCUtil.toSm2Params((String)this.bocConfig.getPTPrivateKeyHex());
        SM2 sm2pri = new SM2(ecPrivateKeyParameters, null);
        sm2pri.usePlainEncoding();
        sm2pri.setMode(SM2Engine.Mode.C1C2C3);
        byte[] decdata = sm2pri.decrypt(ConverTool.parseHexStr2Byte(encResultData), KeyType.PrivateKey);
        return new String(decdata, CHARACTER_ENCODE);
    }

    private String getEncResultData(byte[] dataBytes) {
        String shPublicKey = this.bocConfig.getSHPublicKey();
        if (shPublicKey.length() == 130) {
            shPublicKey = shPublicKey.substring(2);
        }
        String shxHex = shPublicKey.substring(0, 64);
        String shhyHex = shPublicKey.substring(64, 128);
        ECPublicKeyParameters ecPublicKeyParameters = BCUtil.toSm2Params((String)shxHex, (String)shhyHex);
        SM2 sm2 = new SM2(null, ecPublicKeyParameters);
        sm2.usePlainEncoding();
        sm2.setMode(SM2Engine.Mode.C1C2C3);
        byte[] encData = sm2.encrypt(dataBytes, KeyType.PublicKey);
        return ConverTool.parseByte2HexStr(encData);
    }

    private String getSignatureSign(byte[] dataBytes) throws IOException {
        String sm2SignTextData = SM3.byteArrayToHexString(SM3.hash(dataBytes)) + this.bocConfig.getAppId();
        byte[] sm2SignDataBytesData = sm2SignTextData.getBytes(CHARACTER_ENCODE);
        ECPrivateKeyParameters privateKeyParameters = BCUtil.toSm2Params((String)this.bocConfig.getPTPrivateKeyHex());
        SM2 sm22 = new SM2(privateKeyParameters, null);
        sm22.usePlainEncoding();
        sm22.setMode(SM2Engine.Mode.C1C2C3);
        byte[] sign = sm22.sign(sm2SignDataBytesData, null);
        return HexUtil.encodeHexStr((byte[])sign);
    }

    public static String doSign(Map<String, String> params) {
        return SecureUtil.signParams((DigestAlgorithm)DigestAlgorithm.MD5, params, (String)"&", (String)"=", (boolean)true, (String[])new String[0]);
    }

    public String sendGet(String url, Map<String, String> params, boolean insideNetWork) {
        String requestUrl = AssembleTool.assembleUrl((String)url, params);
        requestUrl = requestUrl.substring(0, requestUrl.length() - 1);
        return this.sendGet(requestUrl, insideNetWork);
    }

    public String sendGet(String url, boolean insideNetWork) {
        HttpGet httpGet = new HttpGet(url);
        String httpStr = insideNetWork ? this.getResponse(this.insideNetWorkHttpClient, (HttpRequestBase)httpGet) : this.getResponse(this.httpClient, (HttpRequestBase)httpGet);
        return httpStr;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getResponse(CloseableHttpClient httpClient, HttpRequestBase requestBase) {
        HttpUtils.resetTimeOut(requestBase);
        String resp = "";
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)requestBase);){
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                String string = null;
                return string;
            }
            int statusCode = response.getStatusLine().getStatusCode();
            resp = EntityUtils.toString((HttpEntity)entity, (String)CHARACTER_ENCODE);
            if (statusCode == 200) return resp;
            LOGGER.warn("request={},resp={}", (Object)requestBase, (Object)resp);
            String string = null;
            return string;
        }
        catch (IOException e) {
            LOGGER.warn("\u53d1\u9001\u8bf7\u6c42\u5931\u8d25", (Throwable)e);
        }
        return resp;
    }

    public String sendPost(String url, String json) {
        HttpPost httpPost = new HttpPost(url);
        HttpUtils.resetTimeOut((HttpRequestBase)httpPost);
        StringEntity stringEntity = new StringEntity(json, CHARACTER_ENCODE);
        stringEntity.setContentEncoding(CHARACTER_ENCODE);
        stringEntity.setContentType(ContentType.APPLICATION_JSON.getMimeType());
        httpPost.setEntity((HttpEntity)stringEntity);
        return this.sendPost(httpPost);
    }

    private String sendPost(HttpPost post) {
        String resp = "";
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)post);){
            HttpEntity entity = response.getEntity();
            resp = EntityUtils.toString((HttpEntity)entity, (String)CHARACTER_ENCODE);
        }
        catch (IOException e) {
            LOGGER.warn("\u53d1\u9001post\u8bf7\u6c42\u5931\u8d25", (Throwable)e);
        }
        LOGGER.info("post\u8bf7\u6c42\u7ed3\u679c\u4e3a:{}.", (Object)resp);
        return resp;
    }
}

