/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.remoteimpl.ceb;

import cn.com.duiba.biz.credits.CebBankApi;
import cn.com.duiba.constant.CebBankConfig;
import cn.com.duiba.credits.sdk.AssembleTool;
import cn.com.duiba.service.HttpAsyncClientPool;
import cn.com.duiba.thirdparty.api.ceb.RemoteCebBankService;
import cn.com.duiba.thirdparty.dto.cebbank.CebBankObjectNotifyDto;
import com.alibaba.fastjson.JSON;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RemoteCebBankServiceImpl
implements RemoteCebBankService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteCebBankServiceImpl.class);
    @Autowired
    private CebBankConfig cebBankConfig;
    @Autowired
    private HttpAsyncClientPool httpAsyncClientPool;
    @Autowired
    private CebBankApi cebBankApi;

    public void objectExchangeNotify(CebBankObjectNotifyDto cebBankObjectNotifyDto) {
        LOGGER.info("\u5149\u5927\u94f6\u884c-\u5b9e\u7269\u53d1\u5956\u901a\u77e5\uff0ccebBankObjectNotifyDto:{}", JSON.toJSON((Object)cebBankObjectNotifyDto));
        if (!this.cebBankApi.isCebBank(cebBankObjectNotifyDto.getAppId())) {
            return;
        }
        String httpUrl = null;
        try {
            String url = this.cebBankConfig.getObjectNotifyUrl();
            Map<String, String> requestParams = this.cebBankApi.buildRequestPrams(cebBankObjectNotifyDto);
            httpUrl = AssembleTool.assembleUrl((String)url, requestParams);
            LOGGER.info("\u5149\u5927\u94f6\u884c-\u5b9e\u7269\u53d1\u5956\u901a\u77e5, httpUrl:{}", (Object)httpUrl);
            HttpGet http = new HttpGet(httpUrl);
            this.httpAsyncClientPool.submit(String.valueOf(cebBankObjectNotifyDto.getAppId()), (HttpUriRequest)http, new FutureCallback<HttpResponse>(){

                public void completed(HttpResponse response) {
                    LOGGER.info("\u5149\u5927\u94f6\u884c-\u5b9e\u7269\u53d1\u5956\u901a\u77e5-\u901a\u77e5\u6210\u529f");
                }

                public void failed(Exception ex) {
                    LOGGER.info("\u5149\u5927\u94f6\u884c-\u5b9e\u7269\u53d1\u5956\u901a\u77e5-\u901a\u77e5\u5931\u8d25", (Throwable)ex);
                }

                public void cancelled() {
                    LOGGER.info("\u5149\u5927\u94f6\u884c-\u5b9e\u7269\u53d1\u5956\u901a\u77e5-\u901a\u77e5\u53d6\u6d88");
                }
            }, null);
        }
        catch (Exception e) {
            LOGGER.info("\u5149\u5927\u94f6\u884c-\u5b9e\u7269\u53d1\u5956\u901a\u77e5\u5f02\u5e38, httpUrl:{}, \u5165\u53c2CebBankObjectNotifyDto:{}", new Object[]{httpUrl, JSON.toJSON((Object)cebBankObjectNotifyDto), e});
        }
    }
}

