/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.remoteimpl.hsbc;

import cn.com.duiba.biz.credits.strategy.Impl.HsbcApiStrategy;
import cn.com.duiba.thirdparty.api.hsbc.RemoteHsbcBankServcie;
import cn.com.duiba.thirdparty.dto.hsbc.HsbcPointTask;
import cn.com.duiba.thirdparty.dto.hsbc.TaskStatusQuery;
import cn.com.duiba.thirdparty.dto.hsbc.TaskStatusRespData;
import cn.com.duiba.thirdparty.dto.hsbc.UserInfoDto;
import com.alibaba.fastjson.JSON;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RemoteHsbcBankServcieImpl
implements RemoteHsbcBankServcie {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteHsbcBankServcieImpl.class);
    @Autowired
    private HsbcApiStrategy hsbcApiStrategy;

    public UserInfoDto getUserInfo(String hsbcOpenId, String hsbcAppId, Long duibaAppId) {
        if (StringUtils.isBlank((String)hsbcOpenId) || StringUtils.isBlank((String)hsbcAppId)) {
            LOGGER.warn("\u83b7\u53d6\u6c47\u4e30\u7528\u6237\u4fe1\u606f\uff0c\u53c2\u6570\u6709\u8bef\uff0chsbcOpenId={} hsbcAppId={}", (Object)hsbcOpenId, (Object)hsbcAppId);
            return null;
        }
        UserInfoDto userInfoDto = this.hsbcApiStrategy.getUserInfo(hsbcOpenId, hsbcAppId, duibaAppId);
        return userInfoDto;
    }

    public List<HsbcPointTask> queryTaskList(Long duibaAppId) {
        if (Objects.isNull(duibaAppId)) {
            return Collections.emptyList();
        }
        return this.hsbcApiStrategy.queryPointTaskList(duibaAppId);
    }

    public TaskStatusRespData doTaskStatusQuery(TaskStatusQuery queryParams) {
        if (StringUtils.isBlank((String)queryParams.getPartnerUserId()) || Objects.isNull(queryParams.getDuibaAppId())) {
            throw new IllegalArgumentException(String.format("[hsbc]\u53c2\u6570\u5f02\u5e38 queryParams = %s", JSON.toJSONString((Object)queryParams)));
        }
        return this.hsbcApiStrategy.doTaskStatusQuery(queryParams);
    }
}

