/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.remoteimpl.yangshipin;

import cn.com.duiba.constant.YangShiPinConfig;
import cn.com.duiba.thirdparty.api.yangshipin.RemoteYangShiPinService;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.MD5;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RemoteYangShiPinServiceImpl
implements RemoteYangShiPinService {
    private static final Logger log = LoggerFactory.getLogger(RemoteYangShiPinServiceImpl.class);
    private static final RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(5000).setSocketTimeout(10000).setConnectionRequestTimeout(500).build();
    private static final int FIVE_SECONDS = 5000;
    private static final int TEN_SECONDS = 10000;
    @Resource(name="shotKeepAliveHttpClient")
    private CloseableHttpClient httpClient;
    @Resource
    private YangShiPinConfig yangShiPinConfig;

    public Boolean checkIsIceCardUser(String phone) {
        boolean result = false;
        try {
            JSONObject data;
            HashMap<String, String> urlParams = new HashMap<String, String>();
            urlParams.put("appId", this.yangShiPinConfig.getCustomerSupplyAppId());
            urlParams.put("timestamp", String.valueOf(System.currentTimeMillis()));
            urlParams.put("randStr", this.yangShiPinConfig.getRandStr());
            urlParams.put("phone", MD5.md5(phone));
            urlParams.put("appSecret", this.yangShiPinConfig.getCustomerSupplyAppSecret());
            ArrayList list = new ArrayList(urlParams.keySet());
            List keys = list.stream().sorted(Comparator.comparing(Function.identity())).collect(Collectors.toList());
            StringBuilder signResource = new StringBuilder();
            for (String key : keys) {
                String value = (String)urlParams.get(key);
                signResource.append(value);
            }
            String sign = MD5.md5(signResource.toString());
            urlParams.put("sign", sign);
            urlParams.remove("appSecret");
            urlParams.put("vappid", this.yangShiPinConfig.getvAppId());
            urlParams.put("vsecret", this.yangShiPinConfig.getvSecret());
            urlParams.put("raw", this.yangShiPinConfig.getRaw());
            String assembleUrl = AssembleTool.assembleUrl(this.yangShiPinConfig.getIsIceCardUrl(), urlParams);
            log.info("\u592e\u89c6\u9891\u5224\u65ad\u7528\u6237\u662f\u5426\u51b0\u96ea\u5361\u7528\u6237\u8bf7\u6c42url={}", (Object)assembleUrl);
            HttpGet httpGet = new HttpGet(assembleUrl);
            httpGet.setConfig(requestConfig);
            String s = this.yangShiPinRequest((HttpUriRequest)httpGet);
            JSONObject jsonObject = JSONObject.parseObject((String)s);
            if (null == jsonObject) {
                return false;
            }
            if (jsonObject.containsKey((Object)"ret") && 0 == jsonObject.getInteger("ret") && (data = jsonObject.getJSONObject("data")) != null) {
                result = data.getBoolean("isIceCard");
            }
        }
        catch (Exception e) {
            log.warn("\u592e\u89c6\u9891\u5224\u65ad\u7528\u6237\u662f\u5426\u51b0\u96ea\u5361\u7528\u6237\u5f02\u5e38,phone={}", (Object)phone, (Object)e);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String yangShiPinRequest(HttpUriRequest httpRequest) {
        try (CloseableHttpResponse response = this.httpClient.execute(httpRequest);){
            String responseStr = EntityUtils.toString((HttpEntity)response.getEntity());
            log.info("\u592e\u89c6\u9891\u5224\u65ad\u7528\u6237\u662f\u5426\u51b0\u96ea\u5361\u7528\u6237\u54cd\u5e94\u53c2\u6570\uff0cparam:{}", (Object)responseStr);
            String string = responseStr;
            return string;
        }
        catch (Exception e) {
            log.warn("\u592e\u89c6\u9891\u5224\u65ad\u7528\u6237\u662f\u5426\u51b0\u96ea\u5361\u7528\u6237\u54cd\u5e94\u5f02\u5e38\uff0curl:{},param:{}", new Object[]{httpRequest.getURI().getPath(), JSON.toJSONString((Object)httpRequest), e});
            return "";
        }
    }
}

