/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service;

import cn.com.duiba.service.DuibaVirtualSupplier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DuibaVirtualManager
implements InitializingBean {
    private static final Map<String, DuibaVirtualSupplier> MAP = new HashMap<String, DuibaVirtualSupplier>();
    @Autowired
    private List<DuibaVirtualSupplier> supplierList;

    public DuibaVirtualSupplier getSupplier(String virtualTypeCode) {
        if (StringUtils.isBlank((CharSequence)virtualTypeCode)) {
            return null;
        }
        return MAP.get(virtualTypeCode);
    }

    public void afterPropertiesSet() throws Exception {
        for (DuibaVirtualSupplier supplier : this.supplierList) {
            MAP.put(supplier.getVirtualTypeCode(), supplier);
        }
    }
}

