/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.impl;

import cn.com.duiba.api.bo.credits.CreditsRequest;
import cn.com.duiba.api.bo.credits.CreditsResponse;
import cn.com.duiba.service.impl.CreditsLogExtractor;
import cn.com.duiba.thirdparty.dto.ConsumerCreditsLogSaveDto;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class CompositeCreditsLogExtractor
implements CreditsLogExtractor {
    @Resource
    private List<CreditsLogExtractor> extractors;

    @Override
    public boolean supports(CreditsRequest request, CreditsResponse response) {
        return this.getExtractor(request, response) != null;
    }

    @Override
    public ConsumerCreditsLogSaveDto extract(CreditsRequest request, CreditsResponse response) {
        CreditsLogExtractor handler = this.getExtractor(request, response);
        if (handler != null) {
            return handler.extract(request, response);
        }
        return null;
    }

    private CreditsLogExtractor getExtractor(CreditsRequest request, CreditsResponse response) {
        for (CreditsLogExtractor extractor : this.extractors) {
            if (!extractor.supports(request, response)) continue;
            return extractor;
        }
        return null;
    }
}

