/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.virtual.impl;

import cn.com.duiba.biz.Exception.ThirdpatyException;
import cn.com.duiba.constant.BiliBiliConfig;
import cn.com.duiba.service.impl.AbstractDuibaVirtualSupplier;
import cn.com.duiba.service.virtual.impl.dto.BiliBiliResponse;
import cn.com.duiba.thirdparty.dto.SupplierRequestDto;
import cn.com.duiba.thirdparty.enums.virtual.VirtualItemChannelEnum;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.security.Key;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BiliBiliApiStrategy
extends AbstractDuibaVirtualSupplier {
    private static final Logger log = LoggerFactory.getLogger(BiliBiliApiStrategy.class);
    private static final String LOGGER_PREFIX = "bilibili\u865a\u62df\u5546\u54c1\u5bf9\u63a5";
    private static final String SUCCESS = "0000";
    private static final String FAIL = "0001";
    @Autowired
    private BiliBiliConfig biliBiliConfig;
    private static final String Error4ConsumerMessage = "\u51fa\u4e86\u70b9\u5c0f\u95ee\u9898\uff0c\u8bf7\u91cd\u65b0\u4e0b\u5355";

    @Override
    public HttpRequestBase getVirtualRequest(SupplierRequestDto request) {
        Map originData = request.getParams();
        String dataDes = this.createParam(originData);
        if (StringUtils.isEmpty((Object)dataDes)) {
            throw new ThirdpatyException("bilibili\u865a\u62df\u5546\u54c1\u5bf9\u63a5\u52a0\u5bc6\u5bc6\u6587\u5931\u8d25");
        }
        HashMap params = Maps.newHashMap();
        params.put("mid", this.biliBiliConfig.getMid());
        params.put("data", dataDes);
        HttpPost httpPost = new HttpPost(this.biliBiliConfig.getSubmitOrderUrl() + "?mid=" + this.biliBiliConfig.getMid() + "&data=" + dataDes);
        httpPost.setEntity((HttpEntity)new StringEntity(JSON.toJSONString((Object)params), ContentType.APPLICATION_FORM_URLENCODED));
        return httpPost;
    }

    @Override
    public String getVirtualResponse(SupplierRequestDto request, String body) {
        HashMap duibaDoc = Maps.newHashMap();
        if (StringUtils.isEmpty((Object)body)) {
            log.error("bilibili\u865a\u62df\u5546\u54c1\u5bf9\u63a5\u8bf7\u6c42\u4e0b\u5355\u5931\u8d25\uff01\u8bf7\u6c42\u8ba2\u5355Id:{},\u8fd4\u56de\u7684response\u89e3\u6790\u4e3a\u7a7a", (Object)request.getOrderId());
            duibaDoc.put("status", "fail");
            return JSONObject.toJSONString((Object)duibaDoc);
        }
        BiliBiliResponse biliBiliResponse = (BiliBiliResponse)JSON.parseObject((String)body, BiliBiliResponse.class);
        if (SUCCESS.equals(biliBiliResponse.getResult())) {
            log.info("bilibili\u865a\u62df\u5546\u54c1\u5bf9\u63a5\u8bf7\u6c42\u4e0b\u5355\u6210\u529f\uff01\u8bf7\u6c42\u8ba2\u5355Id:{},response={}", (Object)request.getOrderId(), (Object)JSONObject.toJSONString((Object)biliBiliResponse));
            duibaDoc.put("status", "process");
            return JSONObject.toJSONString((Object)duibaDoc);
        }
        if (FAIL.equals(biliBiliResponse.getResult())) {
            log.error("bilibili\u865a\u62df\u5546\u54c1\u5bf9\u63a5\u8bf7\u6c42\u4e0b\u5355\u5931\u8d25\uff01\u8bf7\u6c42\u8ba2\u5355Id:{},\u5931\u8d25\u539f\u56e0\u662f:{}", (Object)request.getOrderId(), (Object)biliBiliResponse.getMsg());
            duibaDoc.put("status", "fail");
            return JSONObject.toJSONString((Object)duibaDoc);
        }
        log.error("bilibili\u865a\u62df\u5546\u54c1\u5bf9\u63a5\u8bf7\u6c42\u4e0b\u5355\u5931\u8d25\uff01\u51fa\u73b0\u672a\u77e5\u56de\u590d,\u8bf7\u6c42\u8ba2\u5355Id:{},response={}", (Object)request.getOrderId(), (Object)JSONObject.toJSONString((Object)biliBiliResponse));
        duibaDoc.put("status", "fail");
        return JSONObject.toJSONString((Object)duibaDoc);
    }

    private String createParam(Map<String, String> originData) {
        String dataDes = null;
        JSONObject js = new JSONObject();
        String secretKey = this.biliBiliConfig.getSecretKey();
        String mid = this.biliBiliConfig.getMid();
        String notifyUrl = this.biliBiliConfig.getNotifyUrl();
        try {
            this.checkParam(originData);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            String date = sdf.format(new Date());
            String phone = originData.get("account");
            String size = originData.get("bizParams");
            String snum = originData.get("orderNum");
            js.put("mid", (Object)mid);
            js.put("date", (Object)date);
            js.put("phone", (Object)phone);
            js.put("size", (Object)size);
            js.put("snum", (Object)snum);
            js.put("notifyUrl", (Object)notifyUrl);
            log.info(LOGGER_PREFIX + js.toJSONString());
            dataDes = BiliBiliUtils.encrypt(js.toJSONString(), secretKey);
        }
        catch (Exception e) {
            log.error("bilibili\u865a\u62df\u5546\u54c1\u5bf9\u63a5\u52a0\u5bc6\u5931\u8d25\uff01\u79d8\u94a5:{},\u52a0\u5bc6\u5185\u5bb9:{}", (Object)secretKey, (Object)js.toJSONString());
            return null;
        }
        return dataDes;
    }

    @Override
    public String getVirtualTypeCode() {
        return VirtualItemChannelEnum.BILIBILI.getCode();
    }

    private void checkParam(Map<String, String> originData) {
        String phone = originData.get("account");
        if (StringUtils.isEmpty((Object)phone)) {
            log.error("bilibili\u865a\u62df\u5546\u54c1\u5bf9\u63a5\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            throw new ThirdpatyException("bilibili\u865a\u62df\u5546\u54c1\u5bf9\u63a5\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String size = originData.get("bizParams");
        if (StringUtils.isEmpty((Object)size)) {
            log.error("bilibili\u865a\u62df\u5546\u54c1\u5bf9\u63a5\u4e0b\u5355\u7684\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            throw new ThirdpatyException("bilibili\u865a\u62df\u5546\u54c1\u5bf9\u63a5\u4e0b\u5355\u7684\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String snum = originData.get("orderNum");
        if (StringUtils.isEmpty((Object)snum)) {
            log.error("bilibili\u865a\u62df\u5546\u54c1\u5bf9\u63a5\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            throw new ThirdpatyException("bilibili\u865a\u62df\u5546\u54c1\u5bf9\u63a5\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Override
    public String getDefaultError4ConsumerMessage() {
        return Error4ConsumerMessage;
    }

    static class BiliBiliUtils {
        public static final String ALGORITHM = "DES";

        BiliBiliUtils() {
        }

        public static String encrypt(String data, String pwd) throws Exception {
            return BiliBiliUtils.byte2hex(BiliBiliUtils.encrypt(data.getBytes(), pwd.getBytes()));
        }

        private static byte[] encrypt(byte[] data, byte[] key) throws Exception {
            SecureRandom sr = new SecureRandom();
            DESKeySpec dks = new DESKeySpec(key);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(ALGORITHM);
            SecretKey secureKey = keyFactory.generateSecret(dks);
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(1, (Key)secureKey, sr);
            return cipher.doFinal(data);
        }

        public static String byte2hex(byte[] b) {
            String hs = "";
            String stmp = "";
            for (int n = 0; n < b.length; ++n) {
                stmp = Integer.toHexString(b[n] & 0xFF);
                hs = stmp.length() == 1 ? hs + "0" + stmp : hs + stmp;
            }
            return hs.toUpperCase();
        }
    }
}

