/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.virtual.impl;

import cn.com.duiba.biz.Exception.ThirdpatyException;
import cn.com.duiba.constant.HuazhuConfig;
import cn.com.duiba.dao.AppDAO;
import cn.com.duiba.domain.AppDO;
import cn.com.duiba.enums.redis.RedisKeyEnum;
import cn.com.duiba.service.impl.AbstractDuibaVirtualSupplier;
import cn.com.duiba.thirdparty.dto.SupplierRequestDto;
import cn.com.duiba.thirdparty.enums.virtual.VirtualItemChannelEnum;
import cn.com.duiba.wolf.redis.RedisAtomicClient;
import cn.com.duiba.wolf.redis.RedisLock;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class HuaZhuApiStrategy
extends AbstractDuibaVirtualSupplier {
    private static final Logger LOGGER = LoggerFactory.getLogger(HuaZhuApiStrategy.class);
    private static final String LOGGER_PREFIX = "\u534e\u4f4f\u865a\u62df\u5546\u54c1\u63a5\u53e3";
    private static final String RESPONSE_CODE_KEY = "ResponseCode";
    private static final String RESPONSE_DATA_KEY = "BusinessCode";
    private static final String RESPONSE_DESC_KEY = "CustomerDesc";
    private static final Integer SUCCESS_CODE = 200;
    private static final String TOKEN_URL = "/api/BD/token";
    private static final String RECEIVE_CARD_URL = "/api/BD/receiveCardRegister";
    private static final String Error4ConsumerMessage = "\u51fa\u4e86\u70b9\u5c0f\u95ee\u9898\uff0c\u8bf7\u91cd\u65b0\u4e0b\u5355";
    private static final String PHONE_SIMPLE_REGULAR = "^1\\d{10}$";
    @Autowired
    private AppDAO appDAO;
    @Autowired
    private HuazhuConfig huazhuConfig;
    @Resource(name="stringRedisTemplate")
    private StringRedisTemplate redisTemplate;
    @Resource(name="httpClient")
    private CloseableHttpClient httpClient;
    @Resource(name="redisTemplate")
    private RedisAtomicClient redisAtomicClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAccessToken(String appId, String secret) {
        String tokenLockKey = RedisKeyEnum.K6001.toString() + appId;
        RedisLock lock = this.redisAtomicClient.getLock(tokenLockKey, 3L);
        if (lock == null) {
            throw new ThirdpatyException("\u7cfb\u7edf\u7e41\u5fd9");
        }
        String token = "";
        try {
            String queryTokenKey = RedisKeyEnum.K6002.toString() + appId;
            token = (String)this.redisTemplate.opsForValue().get((Object)queryTokenKey);
            if (StringUtils.isBlank((CharSequence)token)) {
                LOGGER.info("\u534e\u4f4f\u865a\u62df\u5546\u54c1\u63a5\u53e3,\u8bf7\u6c42\u63a5\u53e3\u83b7\u53d6token,appId:{}", (Object)appId);
                token = this.requestForToken(appId, secret);
                if (StringUtils.isNotBlank((CharSequence)token)) {
                    this.redisTemplate.opsForValue().set((Object)queryTokenKey, (Object)token, 50L, TimeUnit.MINUTES);
                }
            } else {
                LOGGER.info("\u534e\u4f4f\u865a\u62df\u5546\u54c1\u63a5\u53e3,\u83b7\u53d6\u7f13\u5b58\u4e2d\u7684token:{}", (Object)token);
            }
        }
        finally {
            lock.unlock();
        }
        return token;
    }

    private String requestForToken(String appId, String secret) {
        HashMap paramsMap = Maps.newHashMap();
        paramsMap.put("appId", appId);
        paramsMap.put("secret", secret);
        String url = this.huazhuConfig.getDomain() + TOKEN_URL;
        HttpPost httpPost = new HttpPost(url);
        httpPost.setEntity((HttpEntity)new StringEntity(JSON.toJSONString((Object)paramsMap), ContentType.APPLICATION_JSON));
        String response = "";
        try (CloseableHttpResponse closeableHttpResponse = this.httpClient.execute((HttpUriRequest)httpPost);){
            HttpEntity entity = closeableHttpResponse.getEntity();
            response = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (IOException e) {
            LOGGER.warn("\u534e\u4f4f\u865a\u62df\u5546\u54c1\u63a5\u53e3\u83b7\u53d6Token\u5931\u8d25", (Throwable)e);
        }
        LOGGER.info("\u534e\u4f4f\u865a\u62df\u5546\u54c1\u63a5\u53e3,\u83b7\u53d6token\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c:{}", (Object)response);
        if (StringUtils.isBlank((CharSequence)response)) {
            throw new ThirdpatyException("\u83b7\u53d6Token\u5931\u8d25");
        }
        JSONObject responseJson = JSONObject.parseObject((String)response);
        Integer responseCode = responseJson.getInteger(RESPONSE_CODE_KEY);
        String responseData = responseJson.getString("DomainObj");
        if (!responseCode.equals(SUCCESS_CODE) || StringUtils.isBlank((CharSequence)responseData)) {
            String responseDesc = responseJson.getString(RESPONSE_DESC_KEY);
            responseDesc = StringUtils.isNotBlank((CharSequence)responseDesc) ? responseDesc : "\u8bf7\u6c42\u63a5\u53e3\u5931\u8d25";
            throw new ThirdpatyException(responseDesc);
        }
        return responseData;
    }

    @Override
    public String getVirtualTypeCode() {
        return VirtualItemChannelEnum.HUAZHU.getCode();
    }

    @Override
    public HttpRequestBase getVirtualRequest(SupplierRequestDto supplierRequest) {
        LOGGER.info("\u534e\u4f4f\u865a\u62df\u5546\u54c1\u63a5\u53e3,request={}", (Object)JSON.toJSONString((Object)supplierRequest));
        Map params = supplierRequest.getParams();
        String uid = (String)params.get("uid");
        String orderNum = (String)params.get("orderNum");
        String account = (String)params.get("account");
        String goodsNum = (String)params.get("bizParams");
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{uid, orderNum, account, goodsNum})) {
            throw new ThirdpatyException("\u7f3a\u5c11\u5fc5\u8981\u53c2\u6570");
        }
        if (!account.matches(PHONE_SIMPLE_REGULAR)) {
            throw new ThirdpatyException("\u624b\u673a\u53f7\u683c\u5f0f\u9519\u8bef");
        }
        AppDO appDO = this.appDAO.getAppByCache(Long.valueOf(supplierRequest.getAppId()));
        Object appConfig = this.huazhuConfig.getAppConfigBySubjectMap().get(String.valueOf(appDO.getSubject()));
        if (Objects.isNull(appConfig)) {
            throw new ThirdpatyException("\u914d\u7f6e\u5f02\u5e38");
        }
        JSONObject appConfigJson = (JSONObject)appConfig;
        String appKey = appConfigJson.getString("appKey");
        String appSecret = appConfigJson.getString("appSecret");
        HashMap paramsMap = Maps.newHashMap();
        paramsMap.put("mobile", account);
        paramsMap.put("salesId", goodsNum);
        paramsMap.put("orderNo", orderNum);
        paramsMap.put("deviceNo", uid);
        HttpPost httpPost = new HttpPost(this.huazhuConfig.getDomain() + RECEIVE_CARD_URL);
        httpPost.setHeader("AccessToken", this.getAccessToken(appKey, appSecret));
        httpPost.setHeader("ActivityID", this.huazhuConfig.getActivityId());
        httpPost.setEntity((HttpEntity)new StringEntity(JSON.toJSONString((Object)paramsMap), ContentType.APPLICATION_JSON));
        return httpPost;
    }

    @Override
    public String getVirtualResponse(SupplierRequestDto request, String body) {
        JSONObject result = new JSONObject();
        try {
            JSONObject responseJson = JSONObject.parseObject((String)body);
            LOGGER.info("\u534e\u4f4f\u865a\u62df\u5546\u54c1\u63a5\u53e3,\u5151\u6362\u7ed3\u679c=[{}],\u8ba2\u5355ID:{}", (Object)body, (Object)request.getOrderId());
            Integer responseCode = responseJson.getInteger(RESPONSE_CODE_KEY);
            if (SUCCESS_CODE.equals(responseCode)) {
                result.put("status", (Object)"success");
            } else {
                result.put("status", (Object)"fail");
                result.put("errorMessage", (Object)responseJson.getString(RESPONSE_DESC_KEY));
            }
        }
        catch (Exception e) {
            result.put("status", (Object)"fail");
            result.put("errorMessage", (Object)e.getMessage());
            LOGGER.info("\u534e\u4f4f\u865a\u62df\u5546\u54c1\u63a5\u53e3,\u89e3\u6790\u865a\u62df\u5546\u54c1\u5151\u6362\u8bf7\u6c42\u7ed3\u679c\u5f02\u5e38,orderId=" + request.getOrderId(), (Throwable)e);
        }
        return result.toJSONString();
    }

    @Override
    public String getDefaultError4ConsumerMessage() {
        return Error4ConsumerMessage;
    }
}

