/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.virtual.impl;

import cn.com.duiba.constant.YuShangConfig;
import cn.com.duiba.service.impl.AbstractDuibaVirtualSupplier;
import cn.com.duiba.thirdparty.dto.SupplierRequestDto;
import cn.com.duiba.thirdparty.enums.virtual.VirtualItemChannelEnum;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class YuShangApiStrategy
extends AbstractDuibaVirtualSupplier {
    private static final Logger LOGGER = LoggerFactory.getLogger(YuShangApiStrategy.class);
    private static final String LOGGER_PREFIX = "\u5a31\u5c1a\u865a\u62df\u5546\u54c1\u63a5\u53e3";
    private static final Set<Integer> processSet = Sets.newHashSet((Object[])new Integer[]{9, 997, 999});
    @Autowired
    private YuShangConfig yuShangConfig;
    private static final String Error4ConsumerMessage = "\u51fa\u4e86\u70b9\u5c0f\u95ee\u9898\uff0c\u8bf7\u91cd\u65b0\u4e0b\u5355";

    @Override
    public String getVirtualTypeCode() {
        return VirtualItemChannelEnum.SHANG_YU.getCode();
    }

    @Override
    public HttpRequestBase getVirtualRequest(SupplierRequestDto supplierRequest) {
        LOGGER.info("\u5a31\u5c1a\u865a\u62df\u5546\u54c1\u63a5\u53e3,request={}", (Object)JSON.toJSONString((Object)supplierRequest));
        Map params = supplierRequest.getParams();
        String goodsNum = (String)params.get("bizParams");
        String orderNum = (String)params.get("orderNum");
        String account = (String)params.get("account");
        HttpPost httpPost = new HttpPost(this.yuShangConfig.getUrl());
        ArrayList pairs = Lists.newArrayList();
        pairs.add(new BasicNameValuePair("AppKey", this.yuShangConfig.getAppKey()));
        pairs.add(new BasicNameValuePair("TimesTamp", System.currentTimeMillis() + ""));
        pairs.add(new BasicNameValuePair("ProductCode", goodsNum));
        pairs.add(new BasicNameValuePair("MOrderID", orderNum));
        pairs.add(new BasicNameValuePair("ChargeAccount", account));
        pairs.add(new BasicNameValuePair("BuyCount", "1"));
        pairs.add(new BasicNameValuePair("CustomerIP", "114.55.126.253"));
        pairs.add(new BasicNameValuePair("CallBackUrl", this.yuShangConfig.getCallBackUrl()));
        pairs.add(new BasicNameValuePair("Sign", this.getSign(pairs)));
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity((Iterable)pairs, Charset.forName("UTF-8")));
        return httpPost;
    }

    @Override
    public String getVirtualResponse(SupplierRequestDto request, String body) {
        LOGGER.info("\u5a31\u5c1a\u865a\u62df\u5546\u54c1\u63a5\u53e3,\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c\u5904\u7406,request:{},body:{}", (Object)JSONObject.toJSONString((Object)request), (Object)body);
        JSONObject result = new JSONObject();
        try {
            JSONObject responseJson = JSONObject.parseObject((String)body);
            Integer responseCode = responseJson.getInteger("Code");
            if (processSet.contains(responseCode)) {
                result.put("status", (Object)"process");
            } else {
                result.put("status", (Object)"fail");
                result.put("errorMessage", (Object)responseJson.getString("Msg"));
            }
        }
        catch (Exception e) {
            result.put("status", (Object)"fail");
            result.put("errorMessage", (Object)e.getMessage());
            LOGGER.info("\u5a31\u5c1a\u865a\u62df\u5546\u54c1\u63a5\u53e3,\u89e3\u6790\u865a\u62df\u5546\u54c1\u5151\u6362\u8bf7\u6c42\u7ed3\u679c\u5f02\u5e38,orderId=" + request.getOrderId(), (Throwable)e);
        }
        return result.toJSONString();
    }

    @Override
    public String getDefaultError4ConsumerMessage() {
        return Error4ConsumerMessage;
    }

    private String getSign(List<NameValuePair> pairs) {
        List valueList = pairs.stream().sorted(Comparator.comparing(NameValuePair::getName)).map(NameValuePair::getValue).collect(Collectors.toList());
        String result = StringUtils.join(valueList, (String)"") + this.yuShangConfig.getAppSecret();
        return YuShangApiStrategy.toHexValue(YuShangApiStrategy.encryptMD5(result.getBytes()));
    }

    public static byte[] encryptMD5(byte[] data) {
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        md5.update(data);
        return md5.digest();
    }

    public static String toHexValue(byte[] messageDigest) {
        if (messageDigest == null) {
            return "";
        }
        StringBuilder hexValue = new StringBuilder();
        for (byte aMessageDigest : messageDigest) {
            int val = 0xFF & aMessageDigest;
            if (val < 16) {
                hexValue.append("0");
            }
            hexValue.append(Integer.toHexString(val));
        }
        return hexValue.toString().toUpperCase();
    }
}

