/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.virtualsupplierprocess.customHttpFactory;

import cn.com.duiba.boot.exception.BizException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.conn.NoopIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class XiangShangHttpClientFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(XiangShangHttpClientFactory.class);
    private static final int CONNECT_TIMEOUT = 10000;
    private static final int DEFAULT_REQUEST_TIMEOUT = 3000;
    private static final int KEEPALIVE_TIMEOUT = 5000;
    private static final int SOCKET_TIMEOUT = 10000;
    private static final int MAX_CONNECT = 100;
    private static final int MAX_ROUTE_CONNECT = 20;

    @Bean(initMethod="start", destroyMethod="close", name={"xiangShangHttpAsyncClient"})
    public CloseableHttpAsyncClient cgbHttpAsyncClient() {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(10000).setConnectionRequestTimeout(3000).setSocketTimeout(10000).build();
        CloseableHttpAsyncClient httpClient = HttpAsyncClients.custom().setConnectionManager((NHttpClientConnectionManager)this.getConnectionManager()).setDefaultRequestConfig(config).setMaxConnTotal(100).setMaxConnPerRoute(20).setKeepAliveStrategy((ConnectionKeepAliveStrategy)XiangShangHttpClientFactory.getKeepAliveStrategy()).build();
        return httpClient;
    }

    private PoolingNHttpClientConnectionManager getConnectionManager() {
        try {
            SSLContext sslContext = this.getSSLContext();
            if (sslContext == null) {
                throw new BizException("getConnectionManager failed, sslContext is null!!!");
            }
            return new PoolingNHttpClientConnectionManager((ConnectingIOReactor)new DefaultConnectingIOReactor(), RegistryBuilder.create().register("http", (Object)NoopIOSessionStrategy.INSTANCE).register("https", (Object)new SSLIOSessionStrategy(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE)).build());
        }
        catch (Exception e) {
            LOGGER.warn("", (Throwable)e);
            return null;
        }
    }

    private SSLContext getSSLContext() {
        SSLContext sslContext = null;
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustAllCerts, null);
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6SSLContext\u5f02\u5e38", (Throwable)e);
        }
        return sslContext;
    }

    private static DefaultConnectionKeepAliveStrategy getKeepAliveStrategy() {
        return new DefaultConnectionKeepAliveStrategy(){

            public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                long duration = super.getKeepAliveDuration(response, context);
                if (duration == -1L) {
                    return 5000L;
                }
                return duration;
            }
        };
    }
}

