/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tool;

import cn.com.duiba.biz.Exception.ThirdpatyException;
import com.google.common.collect.Maps;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.digest.DigestUtils;

public class GuMingSignTool {
    private static final String SIGN_ALGORITHM = "HmacSHA256";

    private GuMingSignTool() {
    }

    public static Map<String, String> getSignHeaders(String urlPath, String jsonBody, String appKey, String appSecret) {
        Date now = new Date();
        String uuid = UUID.randomUUID().toString();
        String contentMD5 = GuMingSignTool.getContentMD5(jsonBody);
        HashMap headers = Maps.newHashMap();
        headers.put("x-ca-key", appKey);
        headers.put("x-ca-signature", GuMingSignTool.getSign(now, urlPath, contentMD5, uuid, appKey, appSecret));
        headers.put("x-ca-timestamp", String.valueOf(now.getTime()));
        headers.put("x-ca-nonce", uuid);
        headers.put("content-md5", contentMD5);
        headers.put("x-ca-signature-headers", "x-ca-nonce,x-ca-timestamp,x-ca-key");
        headers.put("date", String.valueOf(now.getTime()));
        headers.put("accept", "application/json;charset=UTF-8");
        headers.put("content-type", "application/json;charset=UTF-8");
        return headers;
    }

    private static String getSign(Date date, String urlPath, String contentMD5, String uuid, String appKey, String appSecret) {
        String signHeaders = GuMingSignTool.getSignHeaders(appKey, date, uuid);
        StringBuilder builder = new StringBuilder();
        builder.append("POST").append("\n");
        builder.append("application/json;charset=UTF-8").append("\n");
        builder.append(contentMD5).append("\n");
        builder.append("application/json;charset=UTF-8").append("\n");
        builder.append(date.getTime()).append("\n");
        builder.append(signHeaders);
        builder.append(urlPath);
        String stringToSign = builder.toString();
        try {
            Mac mac = Mac.getInstance(SIGN_ALGORITHM);
            byte[] keyBytes = appSecret.getBytes(StandardCharsets.UTF_8);
            mac.init(new SecretKeySpec(keyBytes, 0, keyBytes.length, SIGN_ALGORITHM));
            byte[] value = mac.doFinal(stringToSign.getBytes(StandardCharsets.UTF_8));
            return Base64.getEncoder().encodeToString(value);
        }
        catch (Exception e) {
            throw new ThirdpatyException("\u53e4\u8317sign\u751f\u6210\u5931\u8d25");
        }
    }

    private static String getSignHeaders(String appKey, Date now, String uuid) {
        TreeMap map = Maps.newTreeMap();
        map.put("x-ca-key", appKey);
        map.put("x-ca-nonce", uuid);
        map.put("x-ca-timestamp", String.valueOf(now.getTime()));
        StringBuilder builder = new StringBuilder();
        for (String key : map.keySet()) {
            String value = map.getOrDefault(key, "");
            String header = String.format("%s:%s", key, value);
            builder.append(header).append("\n");
        }
        return builder.toString();
    }

    private static String getContentMD5(String body) {
        byte[] bytes = DigestUtils.md5((byte[])body.getBytes(StandardCharsets.UTF_8));
        return Base64.getEncoder().encodeToString(bytes);
    }
}

