/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tool.fude;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;

public class SignToolJSONObject {
    public static Map<String, String> getMapToString(String app_secret, JSONObject params) {
        TreeMap<String, String> req_params = new TreeMap<String, String>();
        for (String key : params.keySet()) {
            if (key.equals("sign")) continue;
            req_params.put(key, SignToolJSONObject.trimFirstAndLastChar(JSONObject.toJSONString((Object)params.get((Object)key), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), "\""));
        }
        req_params.put("app_secret", app_secret);
        return req_params;
    }

    public static Map<String, String> getMapToString(String app_secret, HashMap<String, String> params) {
        TreeMap<String, String> req_params = new TreeMap<String, String>();
        for (String key : params.keySet()) {
            if (key.equals("sign")) continue;
            req_params.put(key, SignToolJSONObject.trimFirstAndLastChar(JSONObject.toJSONString((Object)params.get(key), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), "\""));
        }
        req_params.put("app_secret", app_secret);
        return req_params;
    }

    public static String stringToSign(Map<String, String> all_params) {
        String to_sign_string = "";
        for (String key : all_params.keySet()) {
            to_sign_string = to_sign_string + all_params.get(key);
        }
        return to_sign_string;
    }

    public static String getMD5SignedString(String sourceStr) {
        try {
            MessageDigest mdInst = MessageDigest.getInstance("MD5");
            mdInst.update(sourceStr.getBytes("utf-8"));
            byte[] md = mdInst.digest();
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < md.length; ++i) {
                int tmp = md[i];
                if (tmp < 0) {
                    tmp += 256;
                }
                if (tmp < 16) {
                    buf.append("0");
                }
                buf.append(Integer.toHexString(tmp));
            }
            return buf.toString();
        }
        catch (Exception e) {
            throw new RuntimeException("\u6ca1\u6709md5\u8fd9\u4e2a\u7b97\u6cd5\uff01");
        }
    }

    public static Boolean verifySignedString(String app_secret, JSONObject req) throws Exception {
        Map<String, String> all_params = SignToolJSONObject.getMapToString(app_secret, req);
        String string_to_sign = SignToolJSONObject.stringToSign(all_params);
        String signed_str = SignToolJSONObject.getMD5SignedString(string_to_sign);
        String user_signed_string = req.get((Object)"sign").toString();
        if (signed_str == null) {
            throw new Exception("\u672c\u5730\u52a0\u7b7e\u5b57\u7b26\u4e32\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (user_signed_string == null) {
            throw new Exception("\u7528\u6237\u52a0\u7b7e\u5b57\u7b26\u4e32\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (!signed_str.equals(user_signed_string)) {
            return false;
        }
        return true;
    }

    public static String trimFirstAndLastChar(String str, String element) {
        if (str instanceof String && !SignToolJSONObject.isInteger(str)) {
            if (str.length() > 2) {
                boolean beginIndexFlag = true;
                boolean endIndexFlag = true;
                do {
                    int beginIndex = str.indexOf(element) == 0 ? 1 : 0;
                    int endIndex = str.lastIndexOf(element) + 1 == str.length() ? str.lastIndexOf(element) : str.length();
                    str = str.substring(beginIndex, endIndex);
                    beginIndexFlag = str.indexOf(element) == 0;
                    boolean bl = endIndexFlag = str.lastIndexOf(element) + 1 == str.length();
                } while (beginIndexFlag || endIndexFlag);
            } else {
                str = "";
            }
        }
        return str;
    }

    public static boolean isInteger(String str) {
        Pattern pattern = Pattern.compile("^[-\\+]?[\\d]*$");
        return pattern.matcher(str).matches();
    }
}

