/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tool.kunshanRCB;

import java.math.BigInteger;
import java.util.Stack;

public class RadixConvertUtils {
    private static final String TARGET_STR = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final char[] chs = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private static final BigInteger INTEGER0 = new BigInteger("0");

    public static String numToRadix(String number, int radix) {
        if (radix < 0 || radix > TARGET_STR.length()) {
            radix = TARGET_STR.length();
        }
        BigInteger bigNumber = new BigInteger(number);
        BigInteger bigRadix = new BigInteger(radix + "");
        Stack<Character> stack = new Stack<Character>();
        StringBuffer result = new StringBuffer(0);
        while (!bigNumber.equals(INTEGER0)) {
            stack.add(Character.valueOf(chs[bigNumber.remainder(bigRadix).intValue()]));
            bigNumber = bigNumber.divide(bigRadix);
        }
        while (!stack.isEmpty()) {
            result.append(stack.pop());
        }
        return result.length() == 0 ? "0" : result.toString();
    }

    public static String radixToNum(String number, int radix) {
        if (radix < 0 || radix > TARGET_STR.length()) {
            radix = TARGET_STR.length();
        }
        if (radix == 10) {
            return number;
        }
        char[] ch = number.toCharArray();
        int len = ch.length;
        BigInteger bigRadix = new BigInteger(radix + "");
        BigInteger result = new BigInteger("0");
        BigInteger base = new BigInteger("1");
        for (int i = len - 1; i >= 0; --i) {
            BigInteger index = new BigInteger(TARGET_STR.indexOf(ch[i]) + "");
            result = result.add(index.multiply(base));
            base = base.multiply(bigRadix);
        }
        return result.toString();
    }

    public static String transRadix(String num, int fromRadix, int toRadix) {
        return RadixConvertUtils.numToRadix(RadixConvertUtils.radixToNum(num, fromRadix), toRadix);
    }
}

