/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tool.sn;

import cn.com.duiba.dto.sn.PayLoadParam;
import cn.com.duiba.dto.sn.SnbRequestParam;
import cn.com.duiba.service.Encryptor;
import cn.com.duiba.service.KeyMetadata;
import cn.com.duiba.service.KeyRegistry;
import cn.com.duiba.service.impl.AESEncryptor;
import cn.com.duiba.service.impl.KeyRegistryImpl;
import cn.com.duiba.tool.sn.Hex;
import cn.com.duiba.tool.sn.InitData;
import cn.com.duiba.tool.sn.Permutation;
import cn.com.duiba.tool.sn.SMS4Util;
import cn.com.duiba.tool.sn.SignatureSigner;
import cn.com.duiba.tool.sn.SignatureVerifier;
import cn.com.duiba.tool.sn.SnbSignUtil;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapperImpl;

public class SnbUtil {
    private static final Logger log = LoggerFactory.getLogger(SnbUtil.class);
    public static Encryptor AESENCRYPTOR = new AESEncryptor();
    public static KeyRegistry KEYREGISTRY = new KeyRegistryImpl();
    public static SignatureSigner SIGNATURESIGNER = new SignatureSigner();
    public static SignatureVerifier SIGNATUREVERIFIER = new SignatureVerifier();
    public static PublicKey snbPublicKey = null;

    public static String encyptRandomNum(String randomNum) {
        byte[] secretKeyBytes = AESENCRYPTOR.encrypt("RSA", randomNum.getBytes(), snbPublicKey);
        return Hex.toHex(secretKeyBytes);
    }

    public static String genRandomNum() {
        SecureRandom random = new SecureRandom();
        StringBuffer randomKey = new StringBuffer();
        for (int i = 0; i < 18; ++i) {
            randomKey = randomKey.append(new Integer(random.nextInt(9)).toString());
        }
        return randomKey.toString();
    }

    public static Map<String, String> sendDataToSNB(Map<String, String> dataMap, PayLoadParam payLoad, String rand, KeyMetadata keyMetadata) throws JsonProcessingException, UnsupportedEncodingException {
        Map<String, Object> payloadMap = SnbUtil.bean2Map(payLoad);
        String payloadJson = InitData.OBJECTMAPPER.writeValueAsString(payloadMap);
        String payload = SnbUtil.encyptPayload(payloadJson, rand);
        HashMap<String, Object> plainMap = new HashMap<String, Object>();
        plainMap.putAll(dataMap);
        plainMap.putAll(payloadMap);
        String plain = Permutation.sort(plainMap, InitData.CHARSET_UTF8);
        String signature = SnbUtil.sign(plain, InitData.Algorithm, keyMetadata);
        dataMap.put("payload", payload);
        dataMap.put("signature", signature);
        return dataMap;
    }

    public static Map extendMap(Map respMap) throws JsonParseException, JsonMappingException, IOException {
        String respCode = (String)respMap.get("respCode");
        if ("00000000".equals(respCode)) {
            String respPayload = (String)respMap.get("payload");
            String respSecretKey = (String)respMap.get("secretKey");
            String respSignature = (String)respMap.get("signature");
            HashMap<String, Object> respPlainMap = new HashMap<String, Object>();
            respPlainMap.putAll(respMap);
            respPlainMap.remove("payload");
            respPlainMap.remove("signature");
            String respRandomNum = SnbUtil.decodeSecretKey(respSecretKey, (PrivateKey)KEYREGISTRY.getKey(SnbSignUtil.keyMetadata));
            Map respPayloadMap = SnbUtil.decyptPayload(respPayload, respRandomNum);
            respPlainMap.putAll(respPayloadMap);
            String respPlain = Permutation.sort(respPlainMap, InitData.CHARSET_UTF8);
            log.info("\u8fd4\u56de\u62a5\u6587\u7684\u7b7e\u540d\u539f\u6587\uff1a[" + respPlain + "]");
            boolean verifyRes = SnbUtil.verify(respPlain, respSignature, InitData.Algorithm, snbPublicKey);
            if (verifyRes) {
                respPlainMap.put("verifyRes", true);
            } else {
                respPlainMap.put("verifyRes", false);
            }
            respPlainMap.put("respPlain", respPlain);
            return respPlainMap;
        }
        log.info("respCode[" + respCode + "]");
        return respMap;
    }

    public static String encyptPayload(String payloadJson, String randomNum) {
        byte[] enOut = SMS4Util.encodeSMS4(payloadJson, randomNum.getBytes());
        String payloadEncrypt = Hex.toHex(enOut);
        return payloadEncrypt;
    }

    public static Map decyptPayload(String payload, String randomNum) throws IOException {
        String deOut = SMS4Util.decodeSMS4toString(Hex.toByte(payload), randomNum.getBytes());
        System.out.println("payload==json str===" + deOut);
        return (Map)InitData.OBJECTMAPPER.readValue(deOut, Map.class);
    }

    public static String sign(String plain, String algorithm, KeyMetadata keyMetadata) {
        Key privatekey = KEYREGISTRY.getKey(keyMetadata);
        return SIGNATURESIGNER.sign(plain, algorithm, (PrivateKey)privatekey);
    }

    public static String decodeSecretKey(String secretKey, PrivateKey privateKey) {
        byte[] decodedData = AESENCRYPTOR.decrypt("RSA", Hex.toByte(secretKey), privateKey);
        String decodedKey = new String(decodedData);
        return decodedKey;
    }

    public static boolean verify(String plain, String signature, String algorithm, PublicKey publicKey) {
        return SIGNATUREVERIFIER.verify(plain, signature, algorithm, publicKey);
    }

    public static String getTimestamp() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(new Date(System.currentTimeMillis()));
    }

    public static Map<String, String> send(SnbRequestParam snbRequestDto) throws Exception {
        String rand = SnbUtil.genRandomNum();
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("appCode", snbRequestDto.getAppCode());
        dataMap.put("channelSerialNo", snbRequestDto.getChannelSerialNo());
        dataMap.put("timestamp", SnbUtil.getTimestamp());
        dataMap.put("algorithm", InitData.Algorithm);
        dataMap.put("channelId", snbRequestDto.getChannelId());
        dataMap.put("secretKey", SnbUtil.encyptRandomNum(rand));
        dataMap.put("transCode", snbRequestDto.getTransCode());
        if (!SnbUtil.isEmpty(snbRequestDto.getDeviceId())) {
            dataMap.put("deviceId", snbRequestDto.getDeviceId());
        }
        if (!SnbUtil.isEmpty(snbRequestDto.getTerminal())) {
            dataMap.put("terminal", snbRequestDto.getTerminal());
        }
        if (!SnbUtil.isEmpty(snbRequestDto.getGps())) {
            dataMap.put("gps", snbRequestDto.getGps());
        }
        if (!SnbUtil.isEmpty(snbRequestDto.getIpAddress())) {
            dataMap.put("ipAddress", snbRequestDto.getIpAddress());
        }
        if (!SnbUtil.isEmpty(snbRequestDto.getMacAddress())) {
            dataMap.put("macAddress", snbRequestDto.getMacAddress());
        }
        if (!SnbUtil.isEmpty(snbRequestDto.getOsVersion())) {
            dataMap.put("osVersion", snbRequestDto.getOsVersion());
        }
        if (!SnbUtil.isEmpty(snbRequestDto.getOpenId())) {
            dataMap.put("openId", snbRequestDto.getOpenId());
        }
        return SnbUtil.sendDataToSNB(dataMap, snbRequestDto.getPayLoad(), rand, SnbSignUtil.keyMetadata);
    }

    public static Map<String, Object> bean2Map(Object beanObject) {
        BeanWrapperImpl bean = new BeanWrapperImpl(beanObject);
        PropertyDescriptor[] desc = bean.getPropertyDescriptors();
        HashMap<String, Object> dataMap = new HashMap<String, Object>(desc.length);
        for (int i = 0; i < desc.length; ++i) {
            Object object;
            String name = desc[i].getName();
            if (!bean.isWritableProperty(name) || !bean.isReadableProperty(name) || (object = bean.getPropertyValue(name)) == null) continue;
            dataMap.put(name, object);
        }
        return dataMap;
    }

    public static PublicKey loadSnbPublicKey() {
        if (snbPublicKey != null) {
            return snbPublicKey;
        }
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)cf.generateCertificate(SnbUtil.class.getResourceAsStream(SnbSignUtil.getSnbPublicKeyPath()));
            snbPublicKey = cert.getPublicKey();
            return cert.getPublicKey();
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return null;
        }
    }

    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }
}

