/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tool.suning;

import cn.com.duiba.tool.suning.HexUtil;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class EncryptUtil {
    private static final String ALGORITHM_AES = "AES";
    private static final String UTF8_CHARSET = "UTF-8";
    private static final String KEY_ALGORITHM = "RSA";

    private EncryptUtil() {
    }

    public static String encryptBase64DecorateAES(String content, String strKey) {
        byte[] encryptAesBytes = EncryptUtil.encrypt(content, strKey);
        return EncryptUtil.byte2hex(encryptAesBytes);
    }

    private static byte[] encrypt(String content, String strKey) {
        try {
            SecretKeySpec key = new SecretKeySpec(strKey.getBytes(), ALGORITHM_AES);
            Cipher cipher = Cipher.getInstance(ALGORITHM_AES);
            byte[] byteContent = content.getBytes(UTF8_CHARSET);
            cipher.init(1, key);
            return cipher.doFinal(byteContent);
        }
        catch (Exception e) {
            throw new RuntimeException("use AES algorithm encrypt error", e);
        }
    }

    public static String decryptBase64DecorateAES(String content, String secretSeed) {
        byte[] decryptResult = EncryptUtil.decrypt(EncryptUtil.hex2byte(content), secretSeed);
        return new String(decryptResult);
    }

    private static byte[] decrypt(byte[] content, String strKey) {
        try {
            SecretKeySpec key = new SecretKeySpec(strKey.getBytes(), ALGORITHM_AES);
            Cipher cipher = Cipher.getInstance(ALGORITHM_AES);
            cipher.init(2, key);
            return cipher.doFinal(content);
        }
        catch (Exception e) {
            throw new RuntimeException("use AES algorithm decrypt error", e);
        }
    }

    private static byte[] hex2byte(String str) {
        if (str == null) {
            return new byte[0];
        }
        String newStr = str.trim();
        int len = newStr.length();
        if (len <= 0 || len % 2 != 0) {
            return new byte[0];
        }
        byte[] b = new byte[len / 2];
        try {
            for (int i = 0; i < newStr.length(); i += 2) {
                b[i / 2] = (byte)Integer.decode("0x" + newStr.substring(i, i + 2)).intValue();
            }
            return b;
        }
        catch (Exception e) {
            return new byte[0];
        }
    }

    private static String byte2hex(byte[] b) {
        StringBuilder hs = new StringBuilder();
        for (byte bi : b) {
            String temp = Integer.toHexString(bi & 0xFF);
            if (temp.length() == 1) {
                hs.append("0");
            }
            hs.append(temp);
        }
        return hs.toString().toUpperCase();
    }

    public static String encryptByPublicKey(String data, String key) {
        try {
            byte[] keyBytes = EncryptUtil.decryptBASE64(key);
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            PublicKey publicKey = keyFactory.generatePublic(x509KeySpec);
            Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
            cipher.init(1, publicKey);
            return HexUtil.bytes2Hexstr(cipher.doFinal(data.getBytes()));
        }
        catch (Exception e) {
            throw new RuntimeException("rsa\u52a0\u5bc6\u5931\u8d25", e);
        }
    }

    private static byte[] decryptBASE64(String key) {
        return Base64.decodeBase64((String)key);
    }

    public static String getAesKey() {
        StringBuilder uid = new StringBuilder();
        SecureRandom rd = new SecureRandom();
        block5: for (int i = 0; i < 16; ++i) {
            int type = rd.nextInt(3);
            switch (type) {
                case 0: {
                    uid.append(rd.nextInt(10));
                    continue block5;
                }
                case 1: {
                    uid.append((char)(rd.nextInt(25) + 65));
                    continue block5;
                }
                case 2: {
                    uid.append((char)(rd.nextInt(25) + 97));
                    continue block5;
                }
            }
        }
        return uid.toString();
    }
}

