/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tool.zhiji;

import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import cn.com.duiba.constant.zhiji.ZhiJiConfig;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import sun.misc.BASE64Encoder;

@Component
public class ZhiJiParamTool {
    private static final Logger log = LoggerFactory.getLogger(ZhiJiParamTool.class);
    private static final String MAC_NAME = "HmacSHA256";
    private static final String ENCODING = "UTF-8";
    private static final String TEST_USERNAME = "duaibauat";
    private static final String PROD_USERNAME = "duibaprod";
    private static final String TEST_ENCRYPT_KEY = "myi6MBoU8PSIXnrkC6nogKKd1yM9x1Q8";
    private static final String PROD_ENCRYPT_KEY = "dF0Watf8GszMNpsJ4jC3YG4JBxK9A7Qu";
    private static final RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(5000).setSocketTimeout(10000).setConnectionRequestTimeout(500).build();
    private static final int FIVE_SECONDS = 5000;
    private static final int TEN_SECONDS = 10000;
    @Autowired
    private ZhiJiConfig zhiJiConfig;

    public HttpPost createHttpPost(Object dto, String url, String domainName) {
        if (dto == null || StringUtils.isBlank((String)url)) {
            return null;
        }
        log.info("\u667a\u5df1-post\u8bf7\u6c42\u53c2\u6570\uff0curl:{}, params:{}", (Object)url, (Object)JSON.toJSONString((Object)dto));
        HttpPost httpPost = new HttpPost(domainName + url);
        this.buildHttpHeader(dto, url, (HttpRequestBase)httpPost);
        httpPost.setEntity((HttpEntity)new StringEntity(JSON.toJSONString((Object)dto), ENCODING));
        httpPost.setConfig(requestConfig);
        log.info("\u667a\u5df1-post\u8bf7\u6c42\u53c2\u6570\uff0cparams:{},header:{}", (Object)JSON.toJSONString((Object)dto), (Object)JSON.toJSONString((Object)httpPost.getAllHeaders()));
        return httpPost;
    }

    public HttpGet createHttpGet(Map<String, String> params, String url, String domainName) {
        if (params == null || StringUtils.isBlank((String)url)) {
            return null;
        }
        log.info("\u667a\u5df1-get\u8bf7\u6c42\u53c2\u6570\uff0curl:{}, params:{}", (Object)url, (Object)JSON.toJSONString(params));
        StringBuilder param = new StringBuilder(domainName + url).append("?");
        ArrayList paramList = new ArrayList();
        params.entrySet().forEach(entry -> paramList.add((String)entry.getKey() + "=" + (String)entry.getValue()));
        param.append(StringUtils.join(paramList, (String)"&"));
        HttpGet httpGet = new HttpGet(param.toString());
        String signature = this.buildHttpHeader(params, url, (HttpRequestBase)httpGet);
        if (signature == null) {
            return null;
        }
        log.info("\u667a\u5df1-get\u8bf7\u6c42\u53c2\u6570\uff0curl:{},signature:{},header:{}", new Object[]{param.toString(), signature, JSON.toJSONString((Object)httpGet.getAllHeaders())});
        httpGet.setConfig(requestConfig);
        return httpGet;
    }

    @Nullable
    public String buildHttpHeader(Object params, String url, HttpRequestBase httpRequestBase) {
        String signature;
        Calendar cd = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        String datetime = sdf.format(cd.getTime());
        try {
            signature = ZhiJiParamTool.calcAuthorization(datetime, url, httpRequestBase.getMethod());
        }
        catch (Exception e) {
            log.warn("\u667a\u5df1-\u53d1\u9001\u8bf7\u6c42\uff0c\u53c2\u6570\u52a0\u5bc6\u5931\u8d25\uff0curl:{}, param:{}", (Object)url, (Object)JSON.toJSONString((Object)params));
            return null;
        }
        if (this.zhiJiConfig.getFirst() == 1) {
            httpRequestBase.setHeader(this.zhiJiConfig.getHmacDateKey(), datetime);
        }
        if (this.zhiJiConfig.getSecond() == 1) {
            httpRequestBase.setHeader(this.zhiJiConfig.getHmacKey(), signature);
        }
        httpRequestBase.setHeader("Content-Type", "application/json;charset=utf-8");
        return signature;
    }

    public static Map<String, String> dtoConvertParams(Object obj) throws IllegalAccessException {
        Field[] fields;
        if (obj == null) {
            return null;
        }
        HashMap params = Maps.newHashMap();
        Class<?> clazz = obj.getClass();
        for (Field field : fields = clazz.getDeclaredFields()) {
            field.setAccessible(true);
            if (field.get(obj) == null) continue;
            params.put(field.getName(), String.valueOf(field.get(obj)));
        }
        return params;
    }

    public static byte[] hmacEncrypt(String encryptText) {
        String encryptKey = TEST_ENCRYPT_KEY;
        if (SpringEnvironmentUtils.isProdEnv()) {
            encryptKey = PROD_ENCRYPT_KEY;
        }
        try {
            byte[] data = encryptKey.getBytes(ENCODING);
            SecretKeySpec secretKey = new SecretKeySpec(data, MAC_NAME);
            Mac mac = Mac.getInstance(MAC_NAME);
            mac.init(secretKey);
            byte[] text = encryptText.getBytes(ENCODING);
            return mac.doFinal(text);
        }
        catch (Exception e) {
            log.error("\u667a\u5df1-hmac\u52a0\u5bc6\u5931\u8d25\uff0cencryptText\uff1a{}", (Object)encryptText, (Object)e);
            return null;
        }
    }

    public static String calcAuthorization(String datetime, String requestLine, String requestMethod) throws NoSuchAlgorithmException, UnsupportedEncodingException, InvalidKeyException {
        String secretKey = TEST_ENCRYPT_KEY;
        String secretId = TEST_USERNAME;
        if (SpringEnvironmentUtils.isProdEnv()) {
            secretKey = PROD_ENCRYPT_KEY;
            secretId = PROD_USERNAME;
        }
        String signStr = "x-date: " + datetime + "\n" + requestMethod + " " + requestLine + " HTTP/1.1";
        Mac mac = Mac.getInstance(MAC_NAME);
        SecretKeySpec sKey = new SecretKeySpec(secretKey.getBytes(ENCODING), mac.getAlgorithm());
        mac.init(sKey);
        byte[] hash = mac.doFinal(signStr.getBytes(ENCODING));
        String sig = new BASE64Encoder().encode(hash);
        String auth = "hmac username=\"" + secretId + "\", algorithm=\"hmac-sha256\", headers=\"x-date request-line\", signature=\"" + sig + "\"";
        log.info("\u667a\u5df1hmac\u52a0\u5bc6\u540e\uff0cauth\uff1a{}", (Object)auth);
        return auth;
    }

    public String generateRandom() {
        return String.valueOf(RandomUtils.nextInt((int)100000, (int)999999));
    }
}

