package cn.com.duiba.biz.credits;

import cn.com.duiba.api.bo.subcredits.SubCreditsMsgDto;
import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.dao.AppDAO;
import cn.com.duiba.domain.AppDO;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.tool.AssembleTool;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by xutao on 2017/8/14.
 */
@Service
public class FengJinApi {
    private static Logger log = LoggerFactory.getLogger(FengJinApi.class);

    @Autowired
    private AppDAO appDAO;

    /**
     * 针对减积分的对象
     * @param creditsMessage
     * @return
     */
    public CreditsMessage getSubCreditsMessage(CreditsMessage creditsMessage) {
        String url = getFengJinGetUrl(creditsMessage.getHttpUrl());
        creditsMessage.setHttpUrl(url);
        creditsMessage.setHttpType(CreditsMessage.HTTP_GET);
        creditsMessage.setAuthParams(new HashMap<String, String>());
        return creditsMessage;
    }

    /**
     * 针对减积分的对象
     * @param creditsMessage
     * @return
     */
    public SubCreditsMsgWrapper getSubCreditsMessage(SubCreditsMsgWrapper creditsMessage) {
        String url = getFengJinGetUrl(creditsMessage.getHttpUrl());
        creditsMessage.setHttpUrl(url);
        creditsMessage.getSubCreditsMsg().setHttpType(SubCreditsMsgDto.HTTP_GET);
        creditsMessage.getSubCreditsMsg().setAuthParams(new HashMap<>());
        return creditsMessage;
    }

    /**
     * 凤金积分商城, 获取通知请求参数
     * @param notifyUrl
     * @param record
     * @return
     */
    public HttpRequestBase getRequestNotify(String notifyUrl, NotifyQueueDO record, AppDO appDO){
        Map<String, String> params = new HashMap();
        if(record.getResult() != null){
            params.put("success", String.valueOf(record.getResult()));
        }

        if(StringUtils.isNotEmpty(record.getError4developer())) {
            params.put("errorMessage", record.getError4developer());
        }
        if(StringUtils.isNotEmpty(record.getDeveloperBizId())){
            params.put("bizId",record.getDeveloperBizId());
        }
        params.put("appKey", appDO.getAppKey());
        params.put("appSecret", appDAO.getAppSecret(appDO));
        params.put("timestamp", String.valueOf(System.currentTimeMillis()));
        if(StringUtils.isNotEmpty(record.getPartnerUserId())){
            params.put("uid", record.getPartnerUserId());
        }

        params.put("orderNum", record.getDuibaOrderNum());
        String sign = SignTool.sign(params);
        params.remove("appSecret");
        params.put("sign", sign);

        if(StringUtils.isNotBlank(record.getPartnerUserId())){
            if(notifyUrl.endsWith("/")){
                notifyUrl = notifyUrl + record.getPartnerUserId();
            }else{
                notifyUrl = notifyUrl + "/" + record.getPartnerUserId();
            }
        }

        return new HttpGet(AssembleTool.assembleUrl(notifyUrl, params));
    }

    /**
     * 凤金积分商城 url handler
     * @param url
     * @return
     */
    private String getFengJinGetUrl(String url){
        try{
            String[] arr = url.split("[?]");
            String newUrl = arr[0];
            if(arr.length < 2){
                return newUrl;
            }

            List<String> paramList = Arrays.asList(arr[1].split("[&]"));
            for(String value : paramList){
                if(StringUtils.isNotBlank(value) && value.trim().startsWith("uid=")){
                    String uid = value.replace("uid=", "");
                    if(StringUtils.isBlank(uid)){
                        break;
                    }
                    if(newUrl.endsWith("/")){
                        newUrl = newUrl + URLDecoder.decode(uid, "utf-8");
                    }else{
                        newUrl = newUrl + "/" + URLDecoder.decode(uid, "utf-8");
                    }
                    break;
                }
            }

            newUrl = newUrl + "?" + arr[1];
            return newUrl;
        }catch (UnsupportedEncodingException e){
            log.error("[AssembleTool-getFengJinGetUrl] URL parsing error, url: " + url,e);
            throw new IllegalStateException("URL parsing error when using utf-8");
        }
    }
}
