package cn.com.duiba.biz.credits;

import cn.com.duiba.api.bo.subcredits.SubCreditsMsgDto;
import cn.com.duiba.constant.yumin.YmBankConfig;
import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.AssembleTool;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Map;

/**
 * @author chenzhenxing
 * @date 2022/2/24 7:12 下午
 */
@Service
public class YuMinBankApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(YuMinBankApi.class);
    @Resource
    private YmBankConfig ymBankConfig;

    public SubCreditsMsgWrapper getSubCreditsMessage(SubCreditsMsgWrapper subCreditsMsgWrapper) {
        try {
            SubCreditsMsgDto subCreditsMsg = subCreditsMsgWrapper.getSubCreditsMsg();
            Map<String, String> params = subCreditsMsg.getParams();
            //如果没有自定义的参数，不需要特殊处理，直接返回即可
            if (params == null || params.isEmpty()) {
                return subCreditsMsgWrapper;
            }
            Map<String, String> map = subCreditsMsg.getCreditConsumeParams().toRequestMap(subCreditsMsg.getAppSecret());
            Map<String, String> newAuth = addParamsAndReSign(subCreditsMsg.getAppSecret(), map, params);
            LOGGER.info("江西裕民银行扣积分请求参数={}",JSONObject.toJSONString(newAuth));
            subCreditsMsgWrapper.setHttpUrl(AssembleTool.assembleUrl(getPureUrl(subCreditsMsgWrapper.getHttpUrl()), newAuth));
            LOGGER.info("江西裕民银行扣积分请求url={}", subCreditsMsgWrapper.getHttpUrl());
            return subCreditsMsgWrapper;
        } catch (Exception e) {
            LOGGER.info("YuMinBankApi call getSubCreditsMessage error , subCreditsMsgWrapper = {}", JSONObject.toJSONString(subCreditsMsgWrapper), e);
            return subCreditsMsgWrapper;
        }
    }

    private Map<String, String> addParamsAndReSign(String appSecret, Map<String, String> authParams, Map<String, String> params) {
        authParams.remove("sign");
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (ymBankConfig.getParamsKeys().contains(entry.getKey())) {
                authParams.put(entry.getKey(), entry.getValue());
            }
        }
        authParams.put("appSecret", appSecret);
        authParams.put("sign", SignTool.sign(authParams));
        authParams.remove("appSecret");
        return authParams;
    }

    private  String getPureUrl(String urlWithParams) {
        return urlWithParams.substring(0, urlWithParams.indexOf('?'));
    }

    public CreditsMessageDto getAddCreditsMessage(CreditsMessageDto creditsMessageDto) {
        try {
            Map<String, String> params = creditsMessageDto.getParams();
            if (MapUtils.isEmpty(params)) {
                return creditsMessageDto;
            }
            String appSecret = params.get("appSecret");
            params.remove("appSecret");
            Map<String, String> map = creditsMessageDto.getAuthParams();
            Map<String, String> newAuth = addParamsAndReSign(appSecret, map, params);
            LOGGER.info("江西裕民银行加积分请求参数={}", JSONObject.toJSONString(newAuth));
            creditsMessageDto.setHttpUrl(AssembleTool.assembleUrl(getPureUrl(creditsMessageDto.getHttpUrl()), newAuth));
            LOGGER.info("江西裕民银行加积分请求，param={}", JSON.toJSONString(creditsMessageDto));
            return creditsMessageDto;
        } catch (Exception e) {
            LOGGER.info("江西裕民银行加积分异常，params:{}", JSON.toJSONString(creditsMessageDto), e);
            return creditsMessageDto;
        }
    }

    public SupplierRequest getVirtualExchange(SupplierRequest supplierRequest) {
        try {
            Map<String, String> params = supplierRequest.getParams();
            if (MapUtils.isEmpty(params)) {
                return supplierRequest;
            }
            String appSecret = params.get("appSecret");
            Map<String, String> map = supplierRequest.getAuthParams();
            Map<String, String> newAuth = addParamsAndReSign(appSecret, map, params);
            LOGGER.info("江西裕民银行虚拟兑换请求参数={}", JSONObject.toJSONString(newAuth));
            supplierRequest.setHttpUrl(AssembleTool.assembleUrl(getPureUrl(supplierRequest.getHttpUrl()), newAuth));
            LOGGER.info("江西裕民银行虚拟兑换请求, param={}", JSON.toJSONString(supplierRequest));
            return supplierRequest;
        } catch (Exception e) {
            LOGGER.info("江西裕民银行虚拟兑换异常，params:{}", JSON.toJSONString(supplierRequest), e);
            return supplierRequest;
        }
    }
}
