package cn.com.duiba.biz.credits.impl;

import cn.com.duiba.api.bo.subcredits.SubCreditsMsgDto;
import cn.com.duiba.biz.credits.CustomParamService;
import cn.com.duiba.constant.CustomParamConstant;
import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.tool.AssembleTool;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * @author qianjue
 * @date 2019/11/12
 * @description:
 */
@Service
public class CustomParamServiceImpl implements CustomParamService {

    @Autowired
    private CustomParamConstant customParamConstant;

    @Override
    public SubCreditsMsgWrapper getSubCreditsMessage(SubCreditsMsgWrapper subCreditsMsgWrapper) {
        SubCreditsMsgDto subCreditsMsg = subCreditsMsgWrapper.getSubCreditsMsg();
        //如果没有自定义的参数，不需要特殊处理，直接返回即可
        if(null == subCreditsMsg.getParams()){
            return subCreditsMsgWrapper;
        }
        if(null == subCreditsMsg.getRelationType()
          || !StringUtils.equals(subCreditsMsg.getRelationType().getMsg(),"mall")){
            return subCreditsMsgWrapper;
        }
        //将扣积分对象的所有参数解析成map
        Map<String, String> map = subCreditsMsg.getCreditConsumeParams().toRequestMap(subCreditsMsg.getAppSecret());
        //去除掉map中最初的sign字段
        map.remove("sign");
        //将自定参数param集合加入map中，并重新加入secret进行签名
        map.putAll(subCreditsMsg.getParams());
        map.put("appSecret",subCreditsMsg.getAppSecret());
        map.put("sign", SignTool.sign(map));
        //重新签名后移除appSecret参数
        map.remove("appSecret");
        //重新设置get请求的url地址
        subCreditsMsgWrapper.setHttpUrl( AssembleTool.assembleUrl(subCreditsMsg.getCreditsConsumeRequestUrl(), map));
        return subCreditsMsgWrapper;
    }

    @Override
    public boolean isCustomParamApp(Long appId) {
        if(CollectionUtils.isEmpty(customParamConstant.getSubCreditsAppIds())){
            return false;
        }
        return customParamConstant.getSubCreditsAppIds().contains(appId);
    }
}
