package cn.com.duiba.config;

import cn.com.duiba.biz.credits.strategy.ApiStrategyRouter;
import cn.com.duiba.biz.credits.strategy.Impl.ZhongYiApiStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

import javax.annotation.Resource;
import java.util.Set;

/**
 * @author MeiChang
 * @Description
 */
@Configuration
public class ZhongYiConfig implements InitializingBean {

    private static final Logger log = LoggerFactory.getLogger(ZhongYiConfig.class);

    // 兑吧应用ID集合
    @Value("#{'${zhongyi.subCredits.appIds}'.split(',')}")
    private Set<Long> appIds;

    /**
     * AccessID 访问ID
     */
    @Value("${zhongyi.subCredits.accessId:123}")
    private String accessId;

     /**
     * AccessKey
     */
    @Value("${zhongyi.subCredits.AccessKey:123}")
    private String AccessKey;



    @Resource
    private ZhongYiApiStrategy zhongYiApiStrategy;


    public Set<Long> getAppIds() {
        return appIds;
    }

    public void setAppIds(Set<Long> appIds) {
        this.appIds = appIds;
    }

    public String getAccessId() {
        return accessId;
    }

    public void setAccessId(String accessId) {
        this.accessId = accessId;
    }

    public String getAccessKey() {
        return AccessKey;
    }

    public void setAccessKey(String accessKey) {
        AccessKey = accessKey;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        log.info("掌上中意-开始注册策略---------");
        ApiStrategyRouter.register(appIds, zhongYiApiStrategy);
    }
}
