package cn.com.duiba.constant.yumin;

import com.google.common.collect.Sets;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.Set;

/**
 * @author chenzhenxing
 * @date 2021/11/16 5:25 下午
 */
@Configuration
@ConfigurationProperties(prefix = "ymBank")
public class YmBankConfig {

    private String url = "http://open.ymbank.com//";

    private Set<Long> appIds = Sets.newHashSet(85635L,85806L,83219L,19224L,19497L,83930L);

    private Set<String> paramsKeys = Sets.newHashSet("orderType","activityId", "activityTitle");

    public Boolean isVerify(Long appId) {
        return this.appIds.contains(appId);
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Set<Long> getAppIds() {
        return appIds;
    }

    public void setAppIds(Set<Long> appIds) {
        this.appIds = appIds;
    }

    public Set<String> getParamsKeys() {
        return paramsKeys;
    }

    public void setParamsKeys(Set<String> paramsKeys) {
        this.paramsKeys = paramsKeys;
    }
}
