package cn.com.duiba.job;

import io.elasticjob.lite.api.ShardingContext;
import io.elasticjob.lite.api.simple.SimpleJob;
import org.springframework.beans.factory.annotation.Value;


/**
 * ClassName:AbstractDuibaSimpleElasticJob <br/>
 * 简单的分布式作业抽象类，预发环境不执行任务<br/>
 * Date:     2017年2月5日 下午3:55:18 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public abstract class AbstractDuibaSimpleElasticJob implements SimpleJob {

    @Value("${notifycenter.timer.enable}")
    private boolean timerEnable;

    @Override
    public void execute(ShardingContext shardingContext) {
        if (!timerEnable) {
            return;
        }
        doProcess(shardingContext);
    }
    /**
     * @author zhanglihui
     * @param shardingContext
     */
    protected abstract void doProcess(ShardingContext shardingContext);
}

